/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.ISearchResult;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTSearchGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.search.ExactAndPotentialMatchesPerResourcePair;
import ro.amiq.dvt.ui.search.ISerchResultCategoryFilter;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class FilteredMap {
    private Map<Object, Set<Object>> fFullMap = new HashMap<Object, Set<Object>>();
    private Map<Object, Set<Object>> fFilteredMap;
    private Object fRoot;
    private ILabelProvider fLabelProvider;
    private int fDisplayed;
    private int fTotal;
    private boolean fGuiFiltered;
    private HashSet<Object> fMatchedBold;

    public FilteredMap(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public Object get(Object parent) {
        return this.fFullMap.get(parent);
    }

    public void remove(Object element) {
        this.fFullMap.remove(element);
    }

    public Object getFiltered(Object parentElement) {
        if (this.fFilteredMap == null) {
            return this.fFullMap.get(parentElement);
        }
        return this.fFilteredMap.get(parentElement);
    }

    public boolean filter(TextFilterObject textFilter, ISerchResultCategoryFilter categoryFilter) {
        this.fGuiFiltered = false;
        this.fMatchedBold = new HashSet();
        this.fFilteredMap = new HashMap<Object, Set<Object>>();
        for (Map.Entry<Object, Set<Object>> entry : this.fFullMap.entrySet()) {
            this.fFilteredMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        this.guiFilterInternal(this.fRoot);
        AtomicBoolean hasFilteredElements = new AtomicBoolean();
        if (categoryFilter != null) {
            categoryFilter.filter(this.fRoot, this.fFilteredMap, hasFilteredElements);
        }
        this.countMatches();
        if (textFilter == null) {
            return hasFilteredElements.get() || this.fGuiFiltered;
        }
        if (!textFilter.getTextFilterText().isEmpty() && textFilter.getSearchSegments() != null && textFilter.getSearchTextStrictness() != null) {
            this.fDisplayed = 0;
            this.filterInternal(this.fRoot, textFilter, hasFilteredElements);
        }
        return this.fGuiFiltered || hasFilteredElements.get();
    }

    private void countMatches() {
        this.fTotal = 0;
        for (Set<Object> v : this.fFilteredMap.values()) {
            if (v == null || v.isEmpty() || !(v.iterator().next() instanceof LineElement)) continue;
            this.fTotal += v.size();
        }
        this.fDisplayed = this.fTotal;
    }

    private void guiFilterInternal(Object root) {
        Set<Object> children = this.fFilteredMap.get(root);
        if (children == null) {
            this.fFilteredMap.remove(root);
            return;
        }
        Iterator<Object> iterator = children.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (child instanceof LineElement) {
                LineElement lineElement = (LineElement)child;
                IResource resource = lineElement.getParent();
                IPath location = DVTFileUtils.getInstance().resolveAutoLinkPath(resource);
                if (location != null && DVTSearchGUIFilterMatcher.filterElement(ViewSet.ViewName.SEARCH, location.toOSString(), lineElement.getContents(), resource.getProject()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    this.fGuiFiltered = true;
                    iterator.remove();
                    continue;
                }
            }
            if (!(child instanceof IResource)) continue;
            this.guiFilterInternal(child);
            if (this.fFilteredMap.get(child) != null && !this.fFilteredMap.get(child).isEmpty()) continue;
            iterator.remove();
        }
        if (children.isEmpty()) {
            this.fFilteredMap.remove(root);
        }
    }

    private boolean filterInternal(Object root, TextFilterObject filter, AtomicBoolean hasFilteredElements) {
        Set<Object> children = this.fFilteredMap.get(root);
        if (children == null) {
            return false;
        }
        Iterator<Object> iterator = children.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            boolean keep = false;
            if (!(child instanceof LineElement)) {
                keep = this.filterInternal(child, filter, hasFilteredElements);
            }
            boolean matches = ViewsUtils.matchesPath(child, this.fLabelProvider, filter.getSearchSegments(), filter.getSearchTextStrictness(), null, 1);
            if (child instanceof LineElement && matches) {
                ++this.fDisplayed;
            }
            if (matches) {
                this.fMatchedBold.add(child);
            }
            if (keep || matches) continue;
            iterator.remove();
            hasFilteredElements.set(true);
        }
        if (children.isEmpty()) {
            this.fFilteredMap.remove(root);
            return false;
        }
        return true;
    }

    public boolean insertChild(Object parent, Object child) {
        Set<Object> children;
        if (parent instanceof ISearchResult) {
            this.fRoot = parent;
        }
        if ((children = this.fFullMap.get(parent)) == null) {
            children = new HashSet<Object>();
            this.fFullMap.put(parent, children);
        }
        return children.add(child);
    }

    public boolean hasChild(Object parent, Object child) {
        Set<Object> children = this.fFullMap.get(parent);
        return children != null && children.contains(child);
    }

    public int getDisplayed() {
        return this.fDisplayed;
    }

    public ExactAndPotentialMatchesPerResourcePair getDisplayed(IResource resource) {
        Object filtered = this.getFiltered(resource);
        if (!(filtered instanceof Set)) {
            return new ExactAndPotentialMatchesPerResourcePair(0, 0);
        }
        Set elements = (Set)filtered;
        int nOfExactMatches = 0;
        int nOfPotentialMatches = 0;
        for (Object element : elements) {
            if (!(element instanceof LineElement)) continue;
            LineElement lineElement = (LineElement)element;
            if (lineElement.isPossibleMatch()) {
                ++nOfPotentialMatches;
                continue;
            }
            ++nOfExactMatches;
        }
        return new ExactAndPotentialMatchesPerResourcePair(nOfExactMatches, nOfPotentialMatches);
    }

    public int getTotal() {
        return this.fTotal;
    }

    public boolean isGuiFiltered() {
        return this.fGuiFiltered;
    }

    public HashSet<Object> getMatchedBold() {
        return this.fMatchedBold;
    }
}

