/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.text.ILineElement;

public class LineElement
implements ILineElement {
    private final IResource fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;
    private String fSearchedElement;
    private int fSearchedElementOffset;
    private String fExtraInfo;
    private boolean fPossibleMatch;
    private RWKind fWriteAccess = RWKind.NONE;
    private IRfNamedElement fRfElement;
    private ElementPath fDesignContextPath;
    private boolean isElaborationHit;
    private boolean fIsInUnelaboratedCode;
    private boolean fOutsideCurrentDesignContext;

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = RfReferencesUtils.computeContents(lineContents);
        this.fSearchedElement = null;
        this.fSearchedElementOffset = -1;
    }

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents, IRfNamedElement element) {
        this(parent, lineNumber, lineStartOffset, lineContents);
        this.fRfElement = element;
    }

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents, String extraInfo) {
        this(parent, lineNumber, lineStartOffset, lineContents);
        this.fExtraInfo = extraInfo;
    }

    public IResource getParent() {
        return this.fParent;
    }

    @Override
    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public String getExtraInfo() {
        return this.fExtraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.fExtraInfo = extraInfo;
    }

    public String getSearchedElement() {
        return this.fSearchedElement;
    }

    public int getSearchedElementOffset() {
        return this.fSearchedElementOffset;
    }

    public boolean isPossibleMatch() {
        return this.fPossibleMatch;
    }

    public void setIsInUnelaboratedCode(boolean isInUnelaboratedCode) {
        this.fIsInUnelaboratedCode = isInUnelaboratedCode;
    }

    public boolean isInUnelaboratedCode() {
        return this.fIsInUnelaboratedCode;
    }

    public void setSearchedElement(String searchedElement, int searchedElementOffset, boolean isPossibleMatch) {
        this.fSearchedElement = searchedElement;
        this.fSearchedElementOffset = searchedElementOffset;
        this.fPossibleMatch = isPossibleMatch;
    }

    public BaseFileMatch[] getMatches(AbstractTextSearchResult result) {
        ArrayList<BaseFileMatch> res = new ArrayList<BaseFileMatch>();
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            BaseFileMatch curr = (BaseFileMatch)matches[i];
            if (curr.getLineElement() == this) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new BaseFileMatch[res.size()]);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result) {
        return this.getNumberOfMatches(result, false);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result, boolean onlyPossible) {
        int count = 0;
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            BaseFileMatch curr = (BaseFileMatch)matches[i];
            if (curr.getLineElement() == this && (curr.isPossibleMatch() || !onlyPossible)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fLineContents == null ? 0 : this.fLineContents.hashCode());
        result = 31 * result + this.fLineNumber;
        result = 31 * result + this.fLineStartOffset;
        result = 31 * result + (this.fParent == null ? 0 : this.fParent.hashCode());
        result = 31 * result + (this.fSearchedElement == null ? 0 : this.fSearchedElement.hashCode());
        result = 31 * result + this.fSearchedElementOffset;
        result = this.fRfElement == null ? result : 31 * result + this.fRfElement.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        LineElement le;
        if (obj instanceof LineElement && this.fLineNumber == (le = (LineElement)obj).getLine() && this.fLineContents.equals(le.getContents()) && this.fLineStartOffset == le.getOffset() && this.fParent.equals((Object)le.getParent())) {
            if (this.fRfElement == null && le.getNamedElement() == null) {
                return true;
            }
            if (this.fRfElement == null) {
                return false;
            }
            return this.fRfElement.equals(le.fRfElement);
        }
        return false;
    }

    public void setWriteAccess(RWKind writeAccess) {
        this.fWriteAccess = writeAccess;
    }

    public RWKind getWriteAccess() {
        return this.fWriteAccess;
    }

    public boolean isWriteAccess() {
        return this.fWriteAccess == RWKind.WRITE;
    }

    public boolean isSetterAccess() {
        return this.fWriteAccess == RWKind.SETTER;
    }

    public boolean isGetterAccess() {
        return this.fWriteAccess == RWKind.GETTER;
    }

    public boolean hasNoAccess() {
        return this.fWriteAccess == RWKind.NONE;
    }

    public boolean isReadAccess() {
        return this.fWriteAccess == RWKind.READ;
    }

    public boolean isReadWriteAccess() {
        return this.fWriteAccess == RWKind.READ_WRITE;
    }

    public IRfNamedElement getNamedElement() {
        return this.fRfElement;
    }

    public void setElaborationHit(boolean isElaborationHit) {
        this.isElaborationHit = isElaborationHit;
    }

    public boolean isElaborationHit() {
        return this.isElaborationHit;
    }

    public void setOutsideCurrentDesignContext(boolean exactDesignContext) {
        this.fOutsideCurrentDesignContext = exactDesignContext;
    }

    public boolean isOutsideCurrentDesignContext() {
        return this.fOutsideCurrentDesignContext;
    }

    public ElementPath getDesignContextPath() {
        return this.fDesignContextPath;
    }

    public void setDesignContextPath(ElementPath designContextPath) {
        this.fDesignContextPath = designContextPath;
    }
}

