/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseFileSearchQuery;
import ro.amiq.dvt.ui.search.ReplaceDialog;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;

public class ReplaceAction
extends Action {
    private IWorkbenchSite fSite;
    private IFile[] fElements;
    private BaseFileSearchPage fPage;

    public ReplaceAction(BaseFileSearchPage page, IFile[] elements) {
        Assert.isNotNull((Object)page);
        this.fSite = page.getSite();
        this.fElements = elements != null ? elements : new IFile[0];
        this.fPage = page;
        this.setText(SearchMessages.ReplaceAction_label_all);
        this.setEnabled(this.fElements.length != 0);
    }

    public void run() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot());
        try {
            try {
                Job.getJobManager().beginRule(rule, null);
                if (this.validateResources((BaseFileSearchQuery)this.fPage.getInput().getQuery())) {
                    ReplaceDialog dialog = new ReplaceDialog(this.fSite.getShell(), this.fElements, this.fPage);
                    dialog.open();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                Job.getJobManager().endRule(rule);
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private boolean validateResources(BaseFileSearchQuery operation) {
        IFile[] readOnlyFiles = this.getReadOnlyFiles();
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles, (Object)this.fSite.getShell());
        if (!status.isOK()) {
            if (status.getSeverity() != 8) {
                ErrorDialog.openError((Shell)this.fSite.getShell(), (String)SearchMessages.ReplaceAction2_error_validate_title, (String)SearchMessages.ReplaceAction2_error_validate_message, (IStatus)status);
            }
            return false;
        }
        ArrayList<IFile> outOfDateEntries = new ArrayList<IFile>();
        int j = 0;
        while (j < this.fElements.length) {
            IFile entry = this.fElements[j];
            Match[] markers = this.fPage.getDisplayedMatches(entry);
            int i = 0;
            while (i < markers.length) {
                if (this.isOutOfDate((BaseFileMatch)markers[i])) {
                    outOfDateEntries.add(entry);
                    break;
                }
                ++i;
            }
            ++j;
        }
        ArrayList<IFile> outOfSyncEntries = new ArrayList<IFile>();
        int i = 0;
        while (i < this.fElements.length) {
            IFile entry = this.fElements[i];
            if (this.isOutOfSync(entry)) {
                outOfSyncEntries.add(entry);
            }
            ++i;
        }
        return outOfDateEntries.isEmpty() && outOfSyncEntries.isEmpty();
    }

    private IFile[] getReadOnlyFiles() {
        HashSet<IFile> readOnly = new HashSet<IFile>();
        int i = 0;
        while (i < this.fElements.length) {
            if (this.fElements[i].isReadOnly()) {
                readOnly.add(this.fElements[i]);
            }
            ++i;
        }
        IFile[] readOnlyArray = new IFile[readOnly.size()];
        return readOnly.toArray(readOnlyArray);
    }

    private void research(IProgressMonitor monitor, List<IFile> outOfDateEntries, BaseFileSearchQuery operation) throws CoreException {
        String message = SearchMessages.ReplaceAction2_statusMessage;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.search", 0, message, null);
        for (IFile entry : outOfDateEntries) {
            IStatus status = this.research(operation, monitor, entry);
            if (status == null || status.isOK()) continue;
            multiStatus.add(status);
        }
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private boolean isOutOfDate(BaseFileMatch match) {
        LocationKind locationKind;
        TextFileBufferInfo textFileBufferInfo;
        IPath path;
        IFile file = match.getFile();
        if (match.getCreationTimeStamp() != file.getModificationStamp()) {
            return true;
        }
        ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fb = bm.getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind());
        return fb != null && fb.isDirty();
    }

    private boolean isOutOfSync(IFile entry) {
        return !entry.isSynchronized(0);
    }

    private IStatus research(BaseFileSearchQuery operation, IProgressMonitor monitor, IFile entry) {
        Match[] matches = this.fPage.getDisplayedMatches(entry);
        IStatus status = operation.searchInFile(this.getResult(), monitor, entry);
        int i = 0;
        while (i < matches.length) {
            this.getResult().removeMatch(matches[i]);
            ++i;
        }
        return status;
    }

    private AbstractTextSearchResult getResult() {
        return this.fPage.getInput();
    }
}

