/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.ui.search.HitType;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHitConnectedElementInfo;

public class SearchHit {
    private HitType hitType = HitType.REGULAR;
    private final ParserPath fParent;
    private IProject fProject;
    private final int fLine;
    private int fOffset;
    private int fVirtualOffset;
    private final String fLineContents;
    private String fSearchedElement;
    private int fSearchedElementOffset;
    private String fExtraInfo;
    private boolean fPossibleMatch;
    private IRfDefElement scopeDef;
    private IRfScopeElement fSemanticScope;
    private boolean fShouldRename;
    private LeftRightHandSideOfOperatorEnum fLeftRightHandSideOfConnection;
    private String fConnectedElement;
    private IRfNamedElement fRfElement;
    private int fMatchLength;
    private IRfInstanceElement instance;
    private boolean fIsEscaped;
    private RWKind fWriteAccess;
    private boolean fFromDefparam;
    private boolean fIsInsideHierarchicalAccess;
    private boolean fIsDeclarationHit;
    private boolean fIsElaborationHit;
    private boolean fIsCommentHit;
    private Set<SearchHitConnectedElementInfo> fConnectedElements;

    public SearchHit(ParserPath parent, int lineNumber, int lineStartOffset, String lineContents, int matchLength, boolean shouldRename, String connectedElement, IRfNamedElement namedElement, IProject project) {
        this.fParent = parent;
        this.fLine = lineNumber;
        this.fOffset = lineStartOffset;
        this.fVirtualOffset = -1;
        this.fLineContents = this.computeContents(lineContents);
        this.fSearchedElement = null;
        this.fSearchedElementOffset = -1;
        this.fMatchLength = matchLength;
        this.fWriteAccess = RWKind.NONE;
        this.fShouldRename = shouldRename;
        this.fConnectedElement = connectedElement;
        this.fRfElement = namedElement;
        this.fLeftRightHandSideOfConnection = LeftRightHandSideOfOperatorEnum.NEUTRAL_MATCH;
        this.fProject = project;
        this.fConnectedElements = new LinkedHashSet<SearchHitConnectedElementInfo>();
    }

    public Set<SearchHitConnectedElementInfo> getConnectedElements() {
        return this.fConnectedElements;
    }

    public void setConnectedElement(Set<SearchHitConnectedElementInfo> elements) {
        this.fConnectedElements.addAll(elements);
    }

    public SearchHit(ParserPath parent, int lineNumber, int lineStartOffset, String lineContents, int matchLength, IProject project) {
        this(parent, lineNumber, lineStartOffset, lineContents, matchLength, true, null, null, project);
    }

    public boolean isEscaped() {
        return this.fIsEscaped;
    }

    public void setIsEscaped(boolean isEscaped) {
        this.fIsEscaped = isEscaped;
    }

    public void setInstance(IRfInstanceElement instance) {
        this.instance = instance;
    }

    public IRfInstanceElement getInstance() {
        return this.instance;
    }

    private String computeContents(String lineContents) {
        if (lineContents == null || !lineContents.contains("\t")) {
            return lineContents;
        }
        StringBuilder result = new StringBuilder();
        char[] cArray = lineContents.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\t') {
                result.append(' ');
            } else {
                result.append(c);
            }
            ++n2;
        }
        return result.toString();
    }

    public void setHitType(HitType hitType) {
        this.hitType = hitType;
    }

    public String getExtraInfo() {
        return this.fExtraInfo;
    }

    public int getLine() {
        return this.fLine;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public ParserPath getParserPath() {
        return this.fParent;
    }

    public String getSearchedElement() {
        return this.fSearchedElement;
    }

    public int getSearchedElementOffset() {
        return this.fSearchedElementOffset;
    }

    public HitType getHitType() {
        return this.hitType;
    }

    public void setSearchedElement(String searchedElement, int searchedElementOffset, boolean isPossibleMatch) {
        this.fSearchedElement = searchedElement;
        this.fSearchedElementOffset = searchedElementOffset;
        this.fPossibleMatch = isPossibleMatch;
    }

    public void setExtraInfo(String extraInfo) {
        this.fExtraInfo = extraInfo;
    }

    public boolean isPossibleMatch() {
        return this.fPossibleMatch;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getMatchLength() {
        return this.fMatchLength;
    }

    public void setMatchLength(int matchLength) {
        this.fMatchLength = matchLength;
    }

    public boolean equals(Object obj) {
        SearchHit le;
        if (obj instanceof SearchHit && this.fLine == (le = (SearchHit)obj).getLine() && this.fLineContents.equals(le.getContents()) && this.fOffset == le.getOffset() && this.fVirtualOffset == le.getVirtualOffset() && this.fParent.equals(le.getParserPath())) {
            if (this.fLeftRightHandSideOfConnection.isNeutralMatch() || le.getLeftRightHandSideOfConnection().isNeutralMatch()) {
                return true;
            }
            return this.fLeftRightHandSideOfConnection == le.getLeftRightHandSideOfConnection();
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fLineContents == null ? 0 : this.fLineContents.hashCode());
        result = 31 * result + this.fLine;
        result = 31 * result + this.fOffset;
        result = 31 * result + this.fVirtualOffset;
        result = 31 * result + (this.fParent == null ? 0 : this.fParent.hashCode());
        return result;
    }

    public void setAccess(RWKind writeAccess) {
        this.fWriteAccess = writeAccess;
    }

    public RWKind getAccess() {
        return this.fWriteAccess;
    }

    public boolean isInsideMacroCall() {
        return false;
    }

    public boolean isRenamed() {
        return this.fShouldRename;
    }

    public IRfDefElement getScopeDef() {
        return this.scopeDef;
    }

    public void setScopeDef(IRfDefElement scopeDef) {
        this.scopeDef = scopeDef;
    }

    public void setLeftRightHandSideOfConnection(LeftRightHandSideOfOperatorEnum rightHandSideOfConnection) {
        this.fLeftRightHandSideOfConnection = rightHandSideOfConnection;
    }

    public LeftRightHandSideOfOperatorEnum getLeftRightHandSideOfConnection() {
        return this.fLeftRightHandSideOfConnection;
    }

    public String getConnectedElement() {
        return this.fConnectedElement;
    }

    public IRfNamedElement getNamedElement() {
        return this.fRfElement;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setFromDefparam() {
        this.fFromDefparam = true;
    }

    public boolean isFromDefparam() {
        return this.fFromDefparam;
    }

    public boolean isInsideHierarchicalAccess() {
        return this.fIsInsideHierarchicalAccess;
    }

    public void setIsInsideHierarchicalAccess() {
        this.fIsInsideHierarchicalAccess = true;
    }

    public boolean isDeclarationHit() {
        return this.fIsDeclarationHit;
    }

    public void setIsDeclarationHit() {
        this.fIsDeclarationHit = true;
    }

    public String toString() {
        return String.valueOf(this.getLine()) + ": " + this.getContents() + "[" + this.getExtraInfo() + "]";
    }

    public void setIsElaborationHit() {
        this.fIsElaborationHit = true;
    }

    public boolean isElaborationHit() {
        return this.fIsElaborationHit;
    }

    public IRfScopeElement getSemanticScope() {
        return this.fSemanticScope;
    }

    public void setSemanticScope(IRfScopeElement semanticScope) {
        this.fSemanticScope = semanticScope;
    }

    public int getVirtualOffset() {
        return this.fVirtualOffset;
    }

    public void setVirtualOffset(int virtualOffset) {
        this.fVirtualOffset = virtualOffset;
    }

    public void setIsCommentHit(boolean fIsCommentHit) {
        this.fIsCommentHit = fIsCommentHit;
    }

    public boolean isCommentHit() {
        return this.fIsCommentHit;
    }

    public Hid getHid() {
        return null;
    }
}

