/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;

public class SearchPageScoreComputer
implements ISearchPageScoreComputer {
    private static final String C_SEARCH_PAGE_ID = "org.eclipse.cdt.ui.pdomSearchPage";
    private static final String E_SEARCH_PAGE_ID = "ro.amiq.edt.eSearchPage";
    private static final String PSS_SEARCH_PAGE_ID = "ro.amiq.pssdt.pssSearchPage";
    private static final String MSDL_SEARCH_PAGE_ID = "ro.amiq.msdldt.msdlSearchPage";
    private static final String SLN_SEARCH_PAGE_ID = "ro.amiq.slndt.eSearchPage";
    private static final String VHDL_SEARCH_PAGE_ID = "ro.amiq.vhdldt.vhdlSearchPage";
    private static final String VLOG_SEARCH_PAGE_ID = "ro.amiq.vlogdt.vlogSearchPage";

    public int computeScore(String pageId, Object input) {
        IFile file = null;
        if (input instanceof IFile) {
            file = (IFile)input;
        } else if (input instanceof FileEditorInput) {
            file = ((FileEditorInput)input).getFile();
        }
        if (file == null) {
            return -1;
        }
        String languageSyntaxId = PropertiesManager.getSessionProperty((IResource)file, PropertyTypes.QN_IMPORTED_FILE);
        if (languageSyntaxId == null) {
            return -1;
        }
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(languageSyntaxId);
        if (languageSyntax == null) {
            return -1;
        }
        if (E_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.E) {
            return Integer.MAX_VALUE;
        }
        if (VLOG_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.VLOG) {
            return Integer.MAX_VALUE;
        }
        if (PSS_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.PSS) {
            return Integer.MAX_VALUE;
        }
        if (MSDL_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.MSDL) {
            return Integer.MAX_VALUE;
        }
        if (VHDL_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.VHDL) {
            return Integer.MAX_VALUE;
        }
        if (SLN_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.SLN) {
            return Integer.MAX_VALUE;
        }
        if (C_SEARCH_PAGE_ID.equals(pageId) && languageSyntax.languageKind == LanguageKind.CPP) {
            return Integer.MAX_VALUE;
        }
        return -1;
    }
}

