/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.favorites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.search.favorites.FavoriteQuery;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class FavoriteSearchDialog
extends PopupDialog {
    private static final String EMPTY_STRING = "";
    private static final String THE_SEARCH_IS_NOT_DONE_BECAUSE_NO_QUERY_WAS_SELECTED = "Search not executed because no favorite search is selected!";
    private static final String QUERY_ALREADY_REGISTERED_MESSAGE = "Duplicate favorite search name!";
    private static final String DELETE_BUTTON_STRING = "Delete";
    private static final String DUPLICATE_BUTTON_STRING = "Duplicate";
    private static final String NEW_BUTTON_STRING = "New";
    private static final String SAVE_AND_RUN_BUTTON_STRING = "Save and Run";
    private static final String SAVE_BUTTON_STRING = "Save";
    private static final String CANCEL_BUTTON_STRING = "Cancel";
    private static final String OK_BUTTON_STRING = "OK";
    private static final String REPORT_NON_EXISTING_ELEMENTS_AT_RUNTIME = "Report undeclared elements when running this search";
    private static final String NEW_QUERY_LABEL_INITIAL_VALUE = "New query";
    private static final String QUERY_CONTENT_STRING = "Query content";
    private static final String NAME_LABEL_STRING = "Name:";
    private static final String LANGUAGE_LABEL_STRING = "Language:";
    public Map<String, List<FavoriteQuery>> favoriteSearchesQueriesByLanguage;
    private static final String SELECTION_RUNNABLE = "selection.runnable";
    private static final SelectionListener SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FavoriteSearchDialog.runWidgetSelectedAction(e.widget);
        }
    };
    private Composite contentsComposite;
    private boolean hasStatusLine;
    private IStatus lastStatus;
    private MessageLine statusLine;
    private volatile boolean disableClose;
    private IProject project;
    public Combo allQueriesCombo;
    public Combo newQuerylanguageCombo;
    public Composite newQueryComposite;
    public GridData newQueryGridData;
    private Label newQuerySetNameLabel;
    public Text newQuerySetNameText;
    public StyledText queryContentText;
    private Button newSetButton;
    public Button duplicateSetButton;
    public Button deleteSetButton;
    private Button OKButton;
    private Composite upComposite;
    private Composite buttonsComposite;
    private boolean fromDuplicate;
    private Composite nonExistingElementsCheckButtonComposite;
    private Composite queryContentComposite;
    private Button reportUnresolvedCheck;
    private static List<String> allLanguages = new ArrayList<String>();

    static {
        allLanguages.add("SystemVerilog");
        allLanguages.add("VHDL");
    }

    public FavoriteSearchDialog(IProject project) {
        super(Utils.getActiveShell(), 0, true, false, false, false, false, null, null);
        this.project = project;
    }

    protected final Control createContents(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.contentsComposite);
        this.createMainArea(this.contentsComposite);
        if (this.hasStatusLine) {
            this.createStatusLineArea(this.contentsComposite);
        }
        this.createButtonsArea(this.contentsComposite);
        this.setDefaults();
        Dialog.applyDialogFont((Control)this.contentsComposite);
        return this.contentsComposite;
    }

    private void createStatusLineArea(Composite parent) {
        this.statusLine = new MessageLine(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.statusLine);
        this.statusLine.setErrorStatus(this.lastStatus);
    }

    protected Button createButton(Composite composite, int style, String text, Runnable action) {
        return this.createButton(composite, style, GridDataFactory.fillDefaults().grab(true, true), text, action);
    }

    protected Button createButton(Composite composite, int style, GridDataFactory gridDataFactory, String text, Runnable action) {
        return this.createButton(composite, style, gridDataFactory, text, null, action);
    }

    protected Button createButton(Composite composite, int style, GridDataFactory gridDataFactory, Image image, Runnable action) {
        return this.createButton(composite, style, gridDataFactory, null, image, action);
    }

    protected Button createButton(Composite composite, int style, GridDataFactory gridDataFactory, String text, Image image, Runnable action) {
        Button button = new Button(composite, style);
        if (text != null) {
            button.setText(text);
        }
        if (image != null) {
            button.setImage(image);
        }
        if (gridDataFactory != null) {
            gridDataFactory.applyTo((Control)button);
        }
        if (action != null) {
            button.setData(SELECTION_RUNNABLE, (Object)action);
            button.addSelectionListener(SELECTION_LISTENER);
        }
        return button;
    }

    protected void createSeparator(Composite parent, int style) {
        Label separator = new Label(parent, 2 | style);
        boolean horizontalGrab = style == 256;
        int horizontalAlign = horizontalGrab ? 4 : 0x1000000;
        boolean verticalGrab = !horizontalGrab;
        int verticalAlign = verticalGrab ? 4 : 0x1000000;
        GridDataFactory.fillDefaults().align(horizontalAlign, verticalAlign).grab(horizontalGrab, verticalGrab).applyTo((Control)separator);
    }

    protected void updateStatus(IStatus status) {
        if (!this.hasStatusLine) {
            return;
        }
        this.lastStatus = status;
        if (this.statusLine != null && !this.statusLine.isDisposed()) {
            this.updateButtonsForStatus(status);
            this.statusLine.setErrorStatus(status);
        }
    }

    protected void updateButtonsForStatus(IStatus status) {
    }

    protected void disableClose(boolean disable) {
        this.disableClose = disable;
    }

    protected Control getFocusControl() {
        return this.contentsComposite;
    }

    public boolean close() {
        if (this.disableClose) {
            return false;
        }
        return super.close();
    }

    protected static void runWidgetSelectedAction(Widget widget) {
        Object action = widget.getData(SELECTION_RUNNABLE);
        if (action == null) {
            return;
        }
        ((Runnable)action).run();
    }

    protected void createMainArea(Composite parent) {
        this.upComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.upComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.upComposite);
        this.allQueriesCombo = new Combo(this.upComposite, 12);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.allQueriesCombo);
        this.allQueriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FavoriteSearchDialog.this.selectQuery(FavoriteSearchDialog.this.allQueriesCombo.getText());
                FavoriteQuery selectedQuery = FavoriteSearchDialog.this.getSelectedQuery();
                if (selectedQuery != null) {
                    FavoriteSearchDialog.this.reportUnresolvedCheck.setSelection(selectedQuery.isReportUnresolved());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.newSetButton = this.createButton(this.upComposite, 8, GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false), DVTImages.imageCache.getImage(DVTImages.NEW_CONFIG), () -> this.newQuery());
        this.newSetButton.setToolTipText(NEW_BUTTON_STRING);
        this.duplicateSetButton = this.createButton(this.upComposite, 8, GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false), DVTImages.imageCache.getImage(DVTImages.DUPLICATE_CONFIG), () -> this.duplicateSet());
        this.duplicateSetButton.setToolTipText(DUPLICATE_BUTTON_STRING);
        this.deleteSetButton = this.createButton(this.upComposite, 8, GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false), DVTImages.imageCache.getImage(DVTImages.DELETE_CONFIG), () -> this.deleteSet());
        this.deleteSetButton.setToolTipText(DELETE_BUTTON_STRING);
        this.createNewSetComposite(parent);
        this.queryContentComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.queryContentComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.queryContentComposite);
        this.queryContentText = new StyledText(this.queryContentComposite, 2626);
        FontMetrics fontMetrics = this.getFontMetrics(parent);
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)70);
        int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)10);
        GridDataFactory.fillDefaults().hint(width, height).minSize(width, height).span(6, 1).align(4, 4).grab(true, false).applyTo((Control)this.queryContentText);
        this.queryContentText.setToolTipText(QUERY_CONTENT_STRING);
    }

    private void createNewSetComposite(Composite parent) {
        this.newQueryComposite = new Composite(parent, 0);
        this.newQueryGridData = GridDataFactory.fillDefaults().align(4, 4).grab(true, false).create();
        this.newQueryGridData.horizontalSpan = 6;
        this.newQueryComposite.setLayoutData((Object)this.newQueryGridData);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.newQueryComposite);
        this.newQueryGridData.exclude = true;
        this.newQueryComposite.setVisible(false);
        this.newQuerySetNameLabel = new Label(this.newQueryComposite, 0);
        this.newQuerySetNameLabel.setText(NAME_LABEL_STRING);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)this.newQuerySetNameLabel);
        this.newQuerySetNameText = new Text(this.newQueryComposite, 2052);
        GridDataFactory.fillDefaults().minSize(100, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.newQuerySetNameText);
        this.OKButton = this.createButton(this.newQueryComposite, 8, OK_BUTTON_STRING, () -> this.addNewQuerySet(this.fromDuplicate));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)this.OKButton);
        this.OKButton.setEnabled(false);
        Button cancelButton = this.createButton(this.newQueryComposite, 8, CANCEL_BUTTON_STRING, () -> this.toggleNewQueryComposite());
        GridDataFactory.fillDefaults().align(131072, 0x1000000).grab(false, false).applyTo((Control)cancelButton);
        Label queryLanguageLabel = new Label(this.newQueryComposite, 0);
        queryLanguageLabel.setText(LANGUAGE_LABEL_STRING);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)queryLanguageLabel);
        this.newQuerySetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FavoriteSearchDialog.this.newQuerySetNameText.getText().isEmpty()) {
                    FavoriteSearchDialog.this.OKButton.setEnabled(false);
                } else {
                    FavoriteSearchDialog.this.OKButton.setEnabled(true);
                }
            }
        });
        this.newQuerylanguageCombo = new Combo(this.newQueryComposite, 12);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.newQuerylanguageCombo);
        this.newQuerylanguageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addNewQuerySet(boolean fromDuplicate) {
        if (!fromDuplicate) {
            FavoriteQuery query;
            List<FavoriteQuery> queriesPerLanguage = this.favoriteSearchesQueriesByLanguage.get(this.newQuerylanguageCombo.getText());
            if (queriesPerLanguage == null) {
                queriesPerLanguage = new ArrayList<FavoriteQuery>();
                this.favoriteSearchesQueriesByLanguage.put(this.newQuerylanguageCombo.getText(), queriesPerLanguage);
            }
            if (queriesPerLanguage.contains(query = new FavoriteQuery(this.newQuerylanguageCombo.getText(), this.newQuerySetNameText.getText(), this.reportUnresolvedCheck.getSelection()))) {
                RfGUIReferencesUtils.errorDialog(QUERY_ALREADY_REGISTERED_MESSAGE, this.getShell());
                return;
            }
            queriesPerLanguage.add(query);
            Collections.sort(queriesPerLanguage);
            this.allQueriesCombo.add(query.getLabel());
            this.sortQueriesFromCombo();
            this.allQueriesCombo.setText(query.getLabel());
            this.reportUnresolvedCheck.setSelection(false);
        } else {
            FavoriteQuery candidate = this.getSelectedQuery();
            if (candidate != null) {
                List<FavoriteQuery> queriesPerLanguage = this.favoriteSearchesQueriesByLanguage.get(candidate.getLanguageKind());
                if (queriesPerLanguage == null) {
                    queriesPerLanguage = new ArrayList<FavoriteQuery>();
                    this.favoriteSearchesQueriesByLanguage.put(candidate.getLanguageKind(), queriesPerLanguage);
                }
                FavoriteQuery query = new FavoriteQuery(candidate.getSearchedElements(), candidate.getLanguageKind(), this.newQuerySetNameText.getText(), candidate.isReportUnresolved());
                queriesPerLanguage.add(query);
                Collections.sort(queriesPerLanguage);
                this.allQueriesCombo.add(query.getLabel());
                this.sortQueriesFromCombo();
                this.allQueriesCombo.setText(query.getLabel());
                this.reportUnresolvedCheck.setSelection(query.isReportUnresolved());
            }
            fromDuplicate = false;
        }
        this.toggleNewQueryComposite();
    }

    private void sortQueriesFromCombo() {
        String[] items = this.allQueriesCombo.getItems();
        List<String> asList = Arrays.asList(items);
        Collections.sort(asList);
        this.allQueriesCombo.setItems(asList.toArray(new String[asList.size()]));
    }

    private void saveNewQuerySet() {
        String newQueryContent = this.queryContentText.getText();
        String[] tokens = newQueryContent.split("\n");
        if (tokens == null || tokens.length == 0) {
            return;
        }
        ArrayList<String> searchedElements = new ArrayList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String trim = token.trim();
            if (!trim.isEmpty()) {
                searchedElements.add(trim);
            }
            ++n2;
        }
        FavoriteQuery selectedQuery = this.getSelectedQuery();
        if (selectedQuery != null) {
            selectedQuery.setSearchedElements(searchedElements);
            selectedQuery.setReportUnresolved(this.reportUnresolvedCheck.getSelection());
        }
        this.saveQueries();
    }

    private void saveAndRun() {
        this.saveNewQuerySet();
        if (this.runSelectedQuery()) {
            this.close();
        }
    }

    public void toggleNewQueryComposite() {
        this.newQueryGridData.exclude = !this.newQueryGridData.exclude;
        this.newQueryComposite.setVisible(!this.newQueryGridData.exclude);
        this.newQueryComposite.getParent().pack();
        Utils.setEnabledRecursive(this.upComposite, this.newQueryGridData.exclude);
        Utils.setEnabledRecursive(this.buttonsComposite, this.newQueryGridData.exclude);
        Utils.setEnabledRecursive(this.nonExistingElementsCheckButtonComposite, this.newQueryGridData.exclude);
        Utils.setEnabledRecursive(this.queryContentComposite, this.newQueryGridData.exclude);
        this.getShell().pack();
        this.getShell().layout(true);
        if (this.newQueryGridData.exclude) {
            return;
        }
        this.newQuerySetNameText.setText(NEW_QUERY_LABEL_INITIAL_VALUE);
        this.newQuerySetNameText.selectAll();
        this.newQuerySetNameText.setFocus();
    }

    private void newQuery() {
        this.toggleNewQueryComposite();
        if (this.newQueryComposite.isVisible()) {
            this.queryContentText.setText(EMPTY_STRING);
        }
    }

    private void duplicateSet() {
        this.toggleNewQueryComposite();
        this.fromDuplicate = true;
    }

    private void deleteSet() {
        String toRemove = this.allQueriesCombo.getText();
        FavoriteQuery queryToRemove = null;
        for (List<FavoriteQuery> queriesPerLanguage : this.favoriteSearchesQueriesByLanguage.values()) {
            if (queriesPerLanguage == null || queriesPerLanguage.isEmpty()) continue;
            for (FavoriteQuery query : queriesPerLanguage) {
                if (!toRemove.equals(query.getLabel())) continue;
                queryToRemove = query;
                break;
            }
            if (queryToRemove == null) continue;
            queriesPerLanguage.remove(queryToRemove);
            Collections.sort(queriesPerLanguage);
            break;
        }
        this.allQueriesCombo.remove(toRemove);
        this.queryContentText.setText(EMPTY_STRING);
        this.selectFirstQuery();
    }

    private FontMetrics getFontMetrics(Composite composite) {
        GC gc = new GC((Drawable)composite);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    protected void createButtonsArea(Composite parent) {
        this.nonExistingElementsCheckButtonComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)this.nonExistingElementsCheckButtonComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(this.nonExistingElementsCheckButtonComposite);
        this.reportUnresolvedCheck = this.createButton(this.nonExistingElementsCheckButtonComposite, 32, REPORT_NON_EXISTING_ELEMENTS_AT_RUNTIME, null);
        this.reportUnresolvedCheck.setSelection(false);
        this.buttonsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000008).grab(false, false).applyTo((Control)this.buttonsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 5, 0).applyTo(this.buttonsComposite);
        Composite subButtonsComposite = new Composite(this.buttonsComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)subButtonsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 5, 0).numColumns(3).equalWidth(true).applyTo(subButtonsComposite);
        this.createButton(subButtonsComposite, 8, CANCEL_BUTTON_STRING, () -> {
            boolean bl = this.close();
        });
        this.createButton(subButtonsComposite, 8, SAVE_BUTTON_STRING, () -> this.save());
        this.createButton(subButtonsComposite, 8, SAVE_AND_RUN_BUTTON_STRING, () -> this.saveAndRun());
    }

    private FavoriteQuery getSelectedQuery() {
        FavoriteQuery candidate = null;
        block0: for (List<FavoriteQuery> queriesPerLanguage : this.favoriteSearchesQueriesByLanguage.values()) {
            if (queriesPerLanguage == null || queriesPerLanguage.isEmpty()) continue;
            for (FavoriteQuery predefinedQuery : queriesPerLanguage) {
                if (!this.allQueriesCombo.getText().equals(predefinedQuery.getLabel())) continue;
                candidate = predefinedQuery;
                break block0;
            }
        }
        return candidate;
    }

    private void save() {
        this.saveNewQuerySet();
        this.close();
    }

    public void saveQueries(Map<String, List<FavoriteQuery>> predefinedSearches) {
        RfGUIReferencesUtils.saveQueries(predefinedSearches, "favorite.searches");
    }

    public void saveQueries() {
        this.saveQueries(this.favoriteSearchesQueriesByLanguage);
    }

    protected void setDefaults() {
        this.favoriteSearchesQueriesByLanguage = new LinkedHashMap<String, List<FavoriteQuery>>();
        this.favoriteSearchesQueriesByLanguage.putAll(RfGUIReferencesUtils.getSearchQueries("favorite.searches"));
        for (List<FavoriteQuery> queriesPerLanguage : this.favoriteSearchesQueriesByLanguage.values()) {
            if (queriesPerLanguage == null) continue;
            Collections.sort(queriesPerLanguage);
        }
        for (String language : allLanguages) {
            this.newQuerylanguageCombo.add(language);
        }
        int queryIndex = 0;
        FavoriteQuery firstQuery = null;
        for (List<FavoriteQuery> queriesPerLanguage : this.favoriteSearchesQueriesByLanguage.values()) {
            if (queriesPerLanguage == null || queriesPerLanguage.isEmpty()) continue;
            for (FavoriteQuery query : queriesPerLanguage) {
                this.allQueriesCombo.add(query.getLabel());
                if (queryIndex == 0) {
                    firstQuery = query;
                }
                ++queryIndex;
            }
        }
        this.sortQueriesFromCombo();
        if (firstQuery != null) {
            this.allQueriesCombo.setText(firstQuery.getLabel());
            this.queryContentText.setText(firstQuery.getText());
            this.newQuerylanguageCombo.setText(firstQuery.getLanguageKind());
            this.reportUnresolvedCheck.setSelection(firstQuery.isReportUnresolved());
        }
    }

    private boolean runSelectedQuery() {
        FavoriteQuery candidate = this.getSelectedQuery();
        if (candidate != null) {
            return this.runQuery(candidate);
        }
        RfGUIReferencesUtils.errorDialog(THE_SEARCH_IS_NOT_DONE_BECAUSE_NO_QUERY_WAS_SELECTED, Utils.getActiveShell());
        return false;
    }

    private boolean runQuery(FavoriteQuery query) {
        return RfGUIReferencesUtils.run(query, this.project, this.getShell());
    }

    public void selectQuery(String queryLabel) {
        if (queryLabel == null) {
            return;
        }
        if (this.newQueryComposite.isVisible()) {
            this.toggleNewQueryComposite();
        }
        this.queryContentText.setEnabled(true);
        this.allQueriesCombo.setText(queryLabel);
        FavoriteQuery candidate = this.getSelectedQuery();
        if (candidate != null) {
            this.queryContentText.setText(candidate.getText());
            this.newQuerylanguageCombo.setText(candidate.getLanguageKind());
        }
    }

    private void selectFirstQuery() {
        int queryIndex = 0;
        this.allQueriesCombo.removeAll();
        for (List<FavoriteQuery> queries : this.favoriteSearchesQueriesByLanguage.values()) {
            if (queries == null || queries.isEmpty()) continue;
            for (FavoriteQuery query : queries) {
                this.allQueriesCombo.add(query.getLabel());
                if (queryIndex == 0) {
                    this.allQueriesCombo.setText(query.getLabel());
                    this.queryContentText.setText(query.getText());
                    this.newQuerylanguageCombo.setText(query.getLanguageKind());
                    this.reportUnresolvedCheck.setSelection(query.isReportUnresolved());
                }
                ++queryIndex;
            }
        }
    }

    private static class MessageLine
    extends CLabel {
        public MessageLine(Composite parent) {
            super(parent, 16384);
        }

        private Image findImage(IStatus status) {
            if (status.isOK()) {
                return null;
            }
            if (status.matches(4)) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            if (status.matches(2)) {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            if (status.matches(1)) {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            return null;
        }

        public void setErrorStatus(IStatus status) {
            String message;
            if (status != null && !status.isOK() && (message = status.getMessage()) != null && message.length() > 0) {
                this.setText(LegacyActionTools.escapeMnemonics((String)message));
                this.setImage(this.findImage(status));
                DVTColorUtil.INSTANCE.setBackground((Control)this, DVTColorUtil.INSTANCE.getBackground((Control)this.getParent()), true);
                return;
            }
            DVTColorUtil.INSTANCE.setBackground((Control)this, DVTColorUtil.INSTANCE.getBackground((Control)this.getParent()), true);
            this.setText(FavoriteSearchDialog.EMPTY_STRING);
            this.setImage(null);
        }
    }
}

