/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.favorites;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.search.favorites.FavoriteQuery;
import ro.amiq.dvt.ui.search.favorites.FavoriteSearchDialog;

public class FavoriteSearchHandler
extends AbstractHandler
implements IResourceSelectionChangeListener {
    private static final String CUSTOMIZE_ACTION_BUTTON = "Customize...";

    public FavoriteSearchHandler() {
        DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FavoriteSearchHandler.openMenu(RfGUIReferencesUtils.getCurrentProject());
        return null;
    }

    private static void openMenu(final IProject finalProject) {
        List<FavoriteQuery> queriesToBeShown = RfGUIReferencesUtils.getQueries(finalProject);
        Menu menu = new Menu((Decorations)Utils.getActiveShell(), 8);
        int menuItemIndex = 0;
        if (queriesToBeShown != null && !queriesToBeShown.isEmpty()) {
            for (final FavoriteQuery query : queriesToBeShown) {
                MenuItem menuItem = new MenuItem(menu, 8, menuItemIndex);
                menuItem.setText(query.getLabel());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        RfGUIReferencesUtils.run(query, finalProject, Utils.getActiveShell());
                    }
                });
                ++menuItemIndex;
            }
        }
        MenuItem menuItem = new MenuItem(menu, 8, menuItemIndex);
        menuItem.setText(CUSTOMIZE_ACTION_BUTTON);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new FavoriteSearchDialog(finalProject).open();
            }
        });
        menu.setVisible(true);
    }

    @Override
    public void resourceSelectionChanged(IResource resource) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void dispose() {
        super.dispose();
        DVTPlugin.getSelectionManager().removeResourceSelectionChangeListener(Utils.getActiveWorkbenchWindow(), this);
    }
}

