/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.ISerchResultCategoryFilter;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.search.text.CategoryFilterConfig;

public abstract class BaseCategoryFilteredFileSearchPage
extends BaseFileSearchPage {
    private static final String IGNORE_POTENTIAL_MATCHES_TEXT_FILTER = "Hide Potential Matches";
    private static final String HIDE_POST_CONFIG_MATCHES_TEXT_FILTER = "Hide Post Config Matches";
    private static final String FILTERS_TEXT = "Filters and Customization...";
    private static final String FILTERS_SEPARATOR = "FILTERS_SEPARATOR";
    private FiltersAction fFiltersAction = new FiltersAction("Filters and Customization...");
    protected static final CategoryFilterConfig POSSIBLE_MATCH_CONFIG = new CategoryFilterConfig("Hide Potential Matches", "org.eclipse.search.potentialMatch.ignore"){

        @Override
        public boolean filter(LineElement lineElement) {
            return lineElement.isPossibleMatch();
        }
    };
    protected static final CategoryFilterConfig POST_CONFIG_MATCH_CONFIG = new CategoryFilterConfig("Hide Post Config Matches", "search.view.dvt.hide_post_config"){

        @Override
        public boolean filter(LineElement lineElement) {
            return lineElement.isElaborationHit();
        }
    };

    public BaseCategoryFilteredFileSearchPage() {
        this.updateActionState();
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addFilterActions(tbm);
        }
    }

    private void addFilterActions(IToolBarManager tbm) {
        tbm.prependToGroup("group.show", (IContributionItem)new Separator(FILTERS_SEPARATOR));
        tbm.prependToGroup("group.show", (IAction)this.getFilterAction());
    }

    protected void updateActionState() {
        FiltersAction filterAction = this.getFilterAction();
        if (filterAction == null) {
            return;
        }
        List<CategoryFilterConfig> filterConfigs = this.internalGetFilterConfigs();
        if (filterConfigs == null || filterConfigs.isEmpty()) {
            return;
        }
        filterAction.setEnabled(true);
        filterAction.setChecked(CategoryFilterConfig.oneEnabled(filterConfigs));
    }

    private List<CategoryFilterConfig> internalGetFilterConfigs() {
        ArrayList<CategoryFilterConfig> result = new ArrayList<CategoryFilterConfig>();
        List<CategoryFilterConfig> other = this.getFilterConfigs();
        if (other != null && !other.isEmpty()) {
            result.addAll(other);
            this.getFilterAction().setEnabled(true);
        } else {
            this.getFilterAction().setEnabled(false);
        }
        return result;
    }

    protected List<CategoryFilterConfig> getFilterConfigs() {
        AbstractTextSearchResult searchResult = this.getInput();
        if (!(searchResult instanceof BaseFileSearchResult)) {
            return null;
        }
        BaseFileSearchResult baseFileSearchResult = (BaseFileSearchResult)searchResult;
        Object[] files = baseFileSearchResult.getElements();
        if (files == null || files.length == 0) {
            return null;
        }
        LinkedHashSet<CategoryFilterConfig> result = new LinkedHashSet<CategoryFilterConfig>();
        boolean hasNeutralHits = false;
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        block0: while (n2 < n) {
            Object file = objectArray[n2];
            Match[] matchesPerFile = baseFileSearchResult.getMatches(file);
            if (matchesPerFile != null && matchesPerFile.length != 0) {
                Match[] matchArray = matchesPerFile;
                int n3 = matchesPerFile.length;
                int n4 = 0;
                while (n4 < n3) {
                    BaseFileMatch fileMatch;
                    LineElement lineElement;
                    Match match = matchArray[n4];
                    if (match instanceof BaseFileMatch && (lineElement = (fileMatch = (BaseFileMatch)match).getLineElement()) != null) {
                        if (lineElement.isPossibleMatch()) {
                            result.add(POSSIBLE_MATCH_CONFIG);
                        }
                        if (lineElement.isElaborationHit()) {
                            result.add(POST_CONFIG_MATCH_CONFIG);
                        }
                        if (lineElement.getWriteAccess() == RWKind.NONE) {
                            hasNeutralHits = true;
                        }
                        if (this.hasAllBaseFilters(result)) break block0;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!hasNeutralHits && result.size() == 1) {
            return null;
        }
        return new ArrayList<CategoryFilterConfig>(result);
    }

    protected boolean hasAllBaseFilters(Set<CategoryFilterConfig> result) {
        if (result == null) {
            return false;
        }
        return result.contains(POSSIBLE_MATCH_CONFIG) || result.contains(POST_CONFIG_MATCH_CONFIG);
    }

    protected FiltersAction getFilterAction() {
        return this.fFiltersAction;
    }

    @Override
    protected ISerchResultCategoryFilter getCategoryFilter() {
        return (root, filteredMap, hasFilteredElements) -> this.categoryFilter(root, filteredMap, hasFilteredElements);
    }

    boolean categoryFilter(Object root, Map<Object, Set<Object>> filteredMap, AtomicBoolean hasFilteredElements) {
        Set<Object> children = filteredMap.get(root);
        if (children == null) {
            return false;
        }
        Iterator<Object> iterator = children.iterator();
        block0: while (iterator.hasNext()) {
            Object child = iterator.next();
            boolean keep = false;
            if (!(child instanceof LineElement)) {
                keep = this.categoryFilter(child, filteredMap, hasFilteredElements);
            } else {
                LineElement line = (LineElement)child;
                List<CategoryFilterConfig> filterConfigs = this.internalGetFilterConfigs();
                if (filterConfigs == null) {
                    return true;
                }
                for (CategoryFilterConfig config : filterConfigs) {
                    if (!config.isEnabled() || !config.filter(line)) continue;
                    iterator.remove();
                    if (hasFilteredElements.get()) continue block0;
                    hasFilteredElements.set(true);
                    continue block0;
                }
                keep = true;
            }
            if (keep) continue;
            iterator.remove();
        }
        if (children.isEmpty()) {
            filteredMap.remove(root);
            return false;
        }
        return true;
    }

    public int getButtonStyle() {
        return 32;
    }

    class FiltersAction
    extends Action {
        public FiltersAction(String name) {
            super(name, 2);
            this.setDescription(name);
            this.setToolTipText(name);
            this.setImageDescriptor(DVTImages.FILTER);
        }

        public void run() {
            Menu menu = new Menu((Control)BaseCategoryFilteredFileSearchPage.this.getViewPart().getViewSite().getShell());
            List<CategoryFilterConfig> configs = BaseCategoryFilteredFileSearchPage.this.internalGetFilterConfigs();
            int buttonStyle = BaseCategoryFilteredFileSearchPage.this.getButtonStyle();
            if (configs == null || configs.isEmpty()) {
                menu.setVisible(true);
                BaseCategoryFilteredFileSearchPage.this.updateActionState();
                return;
            }
            for (final CategoryFilterConfig config : configs) {
                if (config.isHidden()) continue;
                MenuItem menuItem = new MenuItem(menu, buttonStyle);
                menuItem.setText(config.label);
                final boolean isShowLogicFilterExpection = CategoryFilterConfig.isShowLogicFilterExpection(config);
                boolean buttonEnabled = isShowLogicFilterExpection ? !config.isEnabled() : config.isEnabled();
                menuItem.setSelection(buttonEnabled);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(e.widget instanceof MenuItem)) {
                            return;
                        }
                        config.setEnabled(isShowLogicFilterExpection ? !((MenuItem)e.widget).getSelection() : ((MenuItem)e.widget).getSelection());
                        BaseCategoryFilteredFileSearchPage.this.updateActionState();
                        BaseCategoryFilteredFileSearchPage.this.refresh(true);
                    }
                });
            }
            menu.setVisible(true);
            BaseCategoryFilteredFileSearchPage.this.updateActionState();
        }
    }
}

