/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.text;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.SearchViewDVTNotification;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.search.BaseFileLabelProvider;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseFileTreeContentProvider;
import ro.amiq.dvt.ui.search.BaseSearchQuery;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.EditorOpener;
import ro.amiq.dvt.ui.search.IFileSearchContentProvider;
import ro.amiq.dvt.ui.search.ISerchResultCategoryFilter;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.NewTextSearchActionGroup;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.ui.search.SortAction;
import ro.amiq.dvt.ui.search.text.FileTableContentProvider;
import ro.amiq.dvt.ui.search.text.ResourceTransferDragAdapter;
import ro.amiq.dvt.ui.search.ui.OpenSearchPreferencesAction;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class BaseFileSearchPage
extends AbstractTextSearchViewPage
implements IAdaptable,
IFilterableView,
IDVTNotificationsHost {
    private static final String NOTIFICATION_TEXT = "{0} {1} containing search hits {2} been modified outside DVT.\nUpdate the database to get accurate results (might be time consuming).";
    private static final String MATCHES_STRING = "matches";
    public static final String GUI_FILTER_INDICATION = "GUI_FILTER_INDICATION";
    public static final String FILTER_MESSAGE_TABLE = "Filter by path";
    public static final String FILTER_MESSAGE_TREE = "Filter hierarchically by path / match text";
    public static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private ActionGroup fActionGroup;
    protected IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByPathAction;
    protected EditorOpener fEditorOpener = new EditorOpener();
    private boolean fShowPossibleMatches;
    private ApiAccessTreeViewer fTreeViewer;
    private ApiAccessTableViewer fTableViewer;
    protected TextFilterObject fTextFilter;
    private Composite fNotificationsHostComposite;
    private SimpleDVTNotification fNotification;
    public static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    public static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private static final Pattern MATCHES_MATCHER = Pattern.compile("\\d[\\d,]* match");

    public BaseFileSearchPage() {
        this.fSortByNameAction = new SortAction(SearchMessages.FileSearchPage_sort_name_label, this, 2);
        this.fSortByPathAction = new SortAction(SearchMessages.FileSearchPage_sort_path_label, this, 3);
    }

    public boolean getShowPossibleMatches() {
        return this.fShowPossibleMatches;
    }

    public void setPossibleMatches(boolean showPossibleMatches) {
        this.fShowPossibleMatches = showPossibleMatches;
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        DelegatingDragAdapter adapter = new DelegatingDragAdapter();
        adapter.addDragSourceListener((TransferDragSourceListener)new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)adapter);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        BaseFileLabelProvider innerLabelProvider = this.makeLabelProvider(this, this.fCurrentSortOrder, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        viewer.setLabelProvider((IBaseLabelProvider)innerLabelProvider);
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this, innerLabelProvider));
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter(innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        BaseFileLabelProvider innerLabelProvider = this.makeLabelProvider(this, 1, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        viewer.setLabelProvider((IBaseLabelProvider)innerLabelProvider);
        viewer.setContentProvider(this.makeFileTreeContentProvider(this, viewer, innerLabelProvider));
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter(innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IEditorPart editor = this.fEditorOpener.open(file, activate);
        if (offset != 0 && length != 0) {
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(offset, length);
                if (textEditor instanceof DVTEditor && match instanceof BaseFileMatch) {
                    this.updateDPMForSearchNavigation(((BaseFileMatch)match).getLineElement(), (DVTEditor)textEditor);
                }
            } else if (editor != null) {
                this.showWithMarker(editor, file, offset, length);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        IMarker marker = null;
        try {
            try {
                marker = file.createMarker("org.eclipse.search.searchmarker");
                HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
                attributes.put("charStart", offset);
                attributes.put("charEnd", offset + length);
                marker.setAttributes(attributes);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
            catch (CoreException e) {
                throw new PartInitException(SearchMessages.FileSearchPage_error_marker, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException coreException) {}
            }
            throw throwable;
        }
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {}
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.appendToGroup("group.properties", (IAction)new OpenSearchPreferencesAction());
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
        this.updateNotification();
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)this.getViewer().getLabelProvider();
        ((BaseFileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fCurrentSortOrder = value;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return label;
        }
        int displayed = this.fContentProvider.getDisplayed();
        int total = this.fContentProvider.getTotal();
        Matcher matcher = MATCHES_MATCHER.matcher(label);
        if (displayed != total) {
            int indexOf;
            label = matcher.replaceFirst("[" + displayed + "/" + total + "] match");
            if (displayed == 1 && label != null && (indexOf = label.indexOf(" matches")) != -1) {
                label = String.valueOf(label.substring(0, indexOf)) + " match" + label.substring(indexOf + " matches".length());
            }
        } else {
            int indexOf;
            label = matcher.replaceFirst(String.valueOf(total) + " match");
            if (displayed == 1 && label != null && (indexOf = label.indexOf(" matches")) != -1) {
                label = String.valueOf(label.substring(0, indexOf)) + " match" + label.substring(indexOf + " matches".length());
            }
        }
        return label;
    }

    public int getDisplayedMatchCount(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getNumberOfMatches(this.getInput());
            }
            return 0;
        }
        return super.getDisplayedMatchCount(element);
    }

    public Match[] getDisplayedMatches(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getMatches(this.getInput());
            }
            return new Match[0];
        }
        return super.getDisplayedMatches(element);
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (this.showLineMatches() && firstElement instanceof IFile && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.fEditorOpener.open((IFile)firstElement, false);
            }
            catch (PartInitException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return;
        }
        super.handleOpen(event);
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return;
        }
        this.updateDPMForSearchNavigation(firstElement, (DVTEditor)activeEditor);
    }

    private void updateDPMForSearchNavigation(Object firstElement, DVTEditor editor) {
        if (!(firstElement instanceof LineElement)) {
            return;
        }
        LineElement lineElement = (LineElement)firstElement;
        if (lineElement.getDesignContextPath() == null) {
            return;
        }
        DesignPathManager.getInstance().updateFor(editor, lineElement.getDesignContextPath());
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (e instanceof RemoveAllEvent) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    BaseFileSearchPage.this.fTextFilter.resetTextFilter("id");
                    BaseFileSearchPage.this.fTextFilter.setTextFilterText("");
                }
            });
        }
        if (this.showLineMatches() && e instanceof MatchEvent) {
            Match[] originalMatches = ((MatchEvent)e).getMatches();
            Match[] fixedMatches = new BaseFileMatch[originalMatches.length];
            int i = 0;
            while (i < originalMatches.length) {
                if (originalMatches[i] instanceof BaseFileMatch) {
                    BaseFileMatch originalMatch = (BaseFileMatch)originalMatches[i];
                    fixedMatches[i] = new BaseFileMatch(originalMatch.getLineElement(), originalMatch.getCreationTimeStamp(), originalMatch.getOffset(), originalMatch.getLength(), originalMatch.isPossibleMatch(), originalMatch.getLineElement());
                }
                ++i;
            }
            MatchEventFix newMatchEvent2 = new MatchEventFix((MatchEvent)e, fixedMatches);
            super.handleSearchResultChanged((SearchResultEvent)newMatchEvent2);
        } else {
            super.handleSearchResultChanged(e);
        }
    }

    public boolean showLineMatches() {
        AbstractTextSearchResult input = this.getInput();
        if (this.getLayout() != 2) {
            return false;
        }
        if (input == null) {
            return false;
        }
        if (!(input.getQuery() instanceof BaseSearchQuery)) {
            return false;
        }
        return !((BaseSearchQuery)input.getQuery()).isFileNameSearch();
    }

    protected void selectFirstMatch() {
        if (!(this.getViewer() instanceof IViewerApiAccess)) {
            return;
        }
        IViewerApiAccess viewer = (IViewerApiAccess)this.getViewer();
        Object firstChild = null;
        Object[] children = new Object[]{this.getViewer().getInput()};
        do {
            firstChild = children[0];
        } while ((children = viewer.getSortedChildren(children[0])) != null && children.length > 0);
        if (firstChild != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(new Object[]{firstChild}), true);
        }
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.fTreeViewer = new ApiAccessTreeViewer(parent, 770);
        return this.fTreeViewer;
    }

    protected TableViewer createTableViewer(Composite parent) {
        this.fTableViewer = new ApiAccessTableViewer(parent, 770);
        return this.fTableViewer;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite container = this.getSearchContainer();
        container.setLayout((Layout)new GridLayout());
        Control viewer = container.getChildren()[0];
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fNotificationsHostComposite = new Composite(container, 0);
        this.fNotificationsHostComposite.setBackground(new Color(null, 255, 255, 0));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fNotificationsHostComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).spacing(0, 0).margins(0, 0).applyTo(this.fNotificationsHostComposite);
        this.fTextFilter = new TextFilterObject(this, "id", container, "treeId", false);
        this.fTextFilter.getControl().moveAbove(viewer);
        String message = this.getViewer() instanceof TreeViewer ? FILTER_MESSAGE_TREE : FILTER_MESSAGE_TABLE;
        this.fTextFilter.setTextFilterMessage(message);
    }

    public void setLayout(int layout) {
        super.setLayout(layout);
        Composite container = this.getSearchContainer();
        this.getViewer().getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        container.layout(true);
        this.fTextFilter.resetTextFilter("id");
        String message = this.getViewer() instanceof TreeViewer ? FILTER_MESSAGE_TREE : FILTER_MESSAGE_TABLE;
        this.fTextFilter.setTextFilterMessage(message);
        this.refresh(true);
    }

    protected Composite getSearchContainer() {
        return (Composite)((PageBook)this.getControl()).getChildren()[1];
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        Object element = ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
        Match[] matches = this.getDisplayedMatches(element);
        if (matches.length == 0) {
            return;
        }
        IRegion location = this.getCurrentMatchLocation(matches[0]);
        try {
            this.showMatch(matches[0], location.getOffset(), location.getLength(), true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void setFocusOnTree(String treeId) {
        this.getViewer().getControl().setFocus();
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return String.valueOf(text) + "//";
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.refresh(true);
    }

    public void refresh(boolean selectFirstMatch) {
        this.refresh(selectFirstMatch, false);
    }

    public void refresh(boolean selectFirstMatch, boolean triggeredFromSetInput) {
        boolean hasFilteredElements = this.fContentProvider.filter(this.fTextFilter, this.getCategoryFilter());
        ((BaseFileLabelProvider)this.getViewer().getLabelProvider()).setMatchedBold(this.fContentProvider.getMatchedBold());
        if (!triggeredFromSetInput || hasFilteredElements) {
            this.getViewer().refresh();
        }
        if (selectFirstMatch) {
            this.selectFirstMatch();
        }
        NewSearchUI.getSearchResultView().updateLabel();
        this.showGuiFilteredIndication(this.fContentProvider.isGuiFiltered());
    }

    protected void showGuiFilteredIndication(boolean show) {
        if (this.getControl() == null) {
            return;
        }
        if (!(this.getControl() instanceof PageBook)) {
            return;
        }
        PageBook pageBook = (PageBook)this.getControl();
        if (pageBook.getParent() == null || pageBook.getParent().getParent() == null) {
            return;
        }
        Composite parentContainer = pageBook.getParent().getParent();
        if (parentContainer.getChildren() == null || parentContainer.getChildren().length == 0) {
            return;
        }
        Control labelControl = parentContainer.getChildren()[0];
        if (!(labelControl instanceof Composite)) {
            return;
        }
        Composite labelContainer = (Composite)labelControl;
        Label guiFilteredIndication = null;
        Control[] controlArray = labelContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Label && child.getData(GUI_FILTER_INDICATION) != null) {
                guiFilteredIndication = (Label)child;
                break;
            }
            ++n2;
        }
        if (guiFilteredIndication == null) {
            Control[] children = labelContainer.getChildren();
            if (children == null || children.length < 2) {
                return;
            }
            Link label = null;
            if (children[0] instanceof Link) {
                label = (Link)children[0];
            }
            if (label == null) {
                return;
            }
            Label separator = null;
            if (children[1] instanceof Label) {
                separator = (Label)children[1];
            }
            if (separator == null) {
                return;
            }
            GridLayout layout = new GridLayout(2, false);
            labelContainer.setLayout((Layout)layout);
            label.setLayoutData((Object)new GridData(4, 1, true, false));
            DVTUiUtils.setPlatformLinkColor((Link)label);
            GridData separatorData = new GridData(4, 4, true, false);
            separatorData.horizontalSpan = 2;
            separator.setLayoutData((Object)separatorData);
            guiFilteredIndication = new Label(labelContainer, 0);
            guiFilteredIndication.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
            guiFilteredIndication.setToolTipText("Content Filters matched!");
            guiFilteredIndication.setLayoutData((Object)new GridData(1, 128, false, true));
            guiFilteredIndication.setData(GUI_FILTER_INDICATION, (Object)"");
            guiFilteredIndication.moveAbove((Control)label);
        }
        guiFilteredIndication.setEnabled(show);
        labelContainer.getParent().layout();
    }

    protected AbstractTextSearchResult getResult() {
        return ((BaseFileTreeContentProvider)this.fContentProvider).getResult();
    }

    protected ISerchResultCategoryFilter getCategoryFilter() {
        return null;
    }

    protected abstract BaseFileLabelProvider makeLabelProvider(BaseFileSearchPage var1, int var2, ILabelDecorator var3);

    protected abstract IContentProvider makeFileTreeContentProvider(BaseFileSearchPage var1, TreeViewer var2, BaseFileLabelProvider var3);

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
        this.updateNotification();
        if (newSearch != null) {
            this.refresh(true, true);
        }
    }

    public IFileSearchContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    @Override
    public Composite getNotificationsHostComposite() {
        return this.fNotificationsHostComposite;
    }

    public void updateNotification() {
        AbstractTextSearchResult input = this.getInput();
        if (input == null) {
            if (this.fNotification != null) {
                this.fNotification.destroy();
                this.fNotification = null;
            }
            return;
        }
        ISearchQuery query = input.getQuery();
        if (!(query instanceof BaseTextSearchQuery)) {
            return;
        }
        BaseTextSearchQuery searchQuery = (BaseTextSearchQuery)query;
        Set<ParserPath> unsynchedFiles = searchQuery.getUnsynchedFiles();
        if (unsynchedFiles == null || unsynchedFiles.isEmpty()) {
            if (this.fNotification != null) {
                this.fNotification.destroy();
                this.fNotification = null;
            }
            return;
        }
        if (this.fNotification != null) {
            return;
        }
        this.fNotification = new SearchViewDVTNotification(searchQuery, this, 256, "notification").setText(MessageFormat.format(NOTIFICATION_TEXT, unsynchedFiles.size(), " file" + (unsynchedFiles.size() > 1 ? "s" : ""), unsynchedFiles.size() > 1 ? "have" : "has"));
        this.fNotification.create();
    }

    static class ApiAccessTableViewer
    extends TableViewer
    implements IViewerApiAccess {
        public ApiAccessTableViewer(Composite parent, int style) {
            super(parent);
        }

        @Override
        public Object[] getSortedChildren(Object parentElementOrTreePath) {
            return super.getSortedChildren(parentElementOrTreePath);
        }
    }

    static class ApiAccessTreeViewer
    extends TreeViewer
    implements IViewerApiAccess {
        public ApiAccessTreeViewer(Composite parent, int style) {
            super(parent);
        }

        @Override
        public Object[] getSortedChildren(Object parentElementOrTreePath) {
            return super.getSortedChildren(parentElementOrTreePath);
        }
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerSorter {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            super(null);
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IContainer) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = null;
            String name2 = null;
            if (e1 instanceof LineElement && e2 instanceof LineElement) {
                return Integer.signum(((LineElement)e1).getLine() - ((LineElement)e2).getLine());
            }
            name1 = this.fLabelProvider.getText(e1);
            name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }

    static interface IViewerApiAccess {
        public Object[] getSortedChildren(Object var1);
    }

    public static class MatchEventFix
    extends MatchEvent {
        private static final long serialVersionUID = 1L;

        public MatchEventFix(MatchEvent oldMatchEvent, Match[] newMatches) {
            super(oldMatchEvent.getSearchResult());
            this.setMatches(newMatches);
            this.setKind(oldMatchEvent.getKind());
        }
    }
}

