/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.text;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class BaseTextSearchResultCollector
extends TextSearchRequestor {
    private final AbstractTextSearchResult fResult;
    private final boolean fIsFileSearchOnly;
    private final boolean fSearchInBinaries;
    protected ArrayList<BaseFileMatch> fCachedMatches;

    public BaseTextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
        this.fResult = result;
        this.fIsFileSearchOnly = isFileSearchOnly;
        this.fSearchInBinaries = searchInBinaries;
    }

    public boolean acceptFile(IFile file) throws CoreException {
        if (this.fIsFileSearchOnly) {
            this.fResult.addMatch((Match)this.makeMatch(file));
        }
        this.flushMatches();
        return true;
    }

    protected abstract BaseFileMatch makeMatch(IFile var1);

    public boolean reportBinaryFile(IFile file) {
        return this.fSearchInBinaries;
    }

    public void beginReporting() {
        this.fCachedMatches = new ArrayList();
    }

    public void endReporting() {
        this.flushMatches();
        this.fCachedMatches = null;
    }

    private void flushMatches() {
        if (this.fCachedMatches != null && !this.fCachedMatches.isEmpty()) {
            this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
            this.fCachedMatches.clear();
        }
    }

    protected LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor) {
        int lineNumber = DVTFileUtils.getInstance().getLineFromOffset(matchRequestor.getFile(), offset);
        String lineContents = DVTFileUtils.getInstance().getLineFromFile(matchRequestor.getFile(), lineNumber);
        return new LineElement((IResource)matchRequestor.getFile(), lineNumber, offset, lineContents);
    }
}

