/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.text;

import java.util.List;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.NewSearchUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.search.LineElement;

public abstract class CategoryFilterConfig {
    String label;
    String prefKey;

    public CategoryFilterConfig(String label, String prefKey) {
        this.label = label;
        this.prefKey = prefKey;
    }

    public static boolean oneEnabled(List<CategoryFilterConfig> list) {
        if (list == null) {
            return false;
        }
        for (CategoryFilterConfig config : list) {
            if (config.isHidden() || !(!CategoryFilterConfig.isShowLogicFilterExpection(config) ? DVTPlugin.getDefault().getPreferenceStore().getBoolean(config.prefKey) : !DVTPlugin.getDefault().getPreferenceStore().getBoolean(config.prefKey))) continue;
            return true;
        }
        return false;
    }

    public static boolean isShowLogicFilterExpection(CategoryFilterConfig config) {
        return "search.view.vlogdt.hide_non_type_matching_specializations".equals(config.prefKey);
    }

    public abstract boolean filter(LineElement var1);

    public boolean isHidden() {
        return false;
    }

    public boolean isEnabled() {
        if (this.prefKey.equals("org.eclipse.search.potentialMatch.ignore")) {
            return NewSearchUI.arePotentialMatchesIgnored();
        }
        return DVTPlugin.getDefault().getPreferenceStore().getBoolean(this.prefKey);
    }

    public void setEnabled(boolean enabled) {
        SearchPlugin.getDefault().getPreferenceStore().setValue(this.prefKey, enabled);
        DVTPlugin.getDefault().getPreferenceStore().setValue(this.prefKey, enabled);
    }
}

