/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.text;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTSearchGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.search.BaseFileLabelProvider;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.ExactAndPotentialMatchesPerResourcePair;
import ro.amiq.dvt.ui.search.IFileSearchContentProvider;
import ro.amiq.dvt.ui.search.ISerchResultCategoryFilter;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class FileTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private BaseFileSearchPage fPage;
    private AbstractTextSearchResult fResult;
    private Object[] fFilteredElements = this.EMPTY_ARR;
    private BaseFileLabelProvider fLabelProvider;
    private int fDisplayed;
    private int fTotal;
    private boolean fGuiFiltered;

    public FileTableContentProvider(BaseFileSearchPage page, BaseFileLabelProvider innerLabelProvider) {
        this.fPage = page;
        this.fLabelProvider = innerLabelProvider;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this.fResult && this.fFilteredElements != this.EMPTY_ARR) {
            return this.fFilteredElements;
        }
        if (inputElement instanceof BaseFileSearchResult) {
            return ((BaseFileSearchResult)((Object)inputElement)).getElements();
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof AbstractTextSearchResult) {
            this.fResult = (AbstractTextSearchResult)newInput;
        }
        this.fPage.refresh(true);
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    viewer.update(updatedElements[i], null);
                } else {
                    viewer.add(updatedElements[i]);
                }
            } else {
                viewer.remove(updatedElements[i]);
            }
            ++i;
        }
        this.fPage.refresh(true);
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    @Override
    public void clear() {
        this.getViewer().refresh();
    }

    @Override
    public boolean filter(TextFilterObject textFilter, ISerchResultCategoryFilter categoryFilter) {
        this.fDisplayed = 0;
        this.fTotal = 0;
        this.fGuiFiltered = false;
        ArrayList<Object> filtered = new ArrayList<Object>();
        if (this.fResult == null) {
            this.fFilteredElements = this.EMPTY_ARR;
            return this.fGuiFiltered;
        }
        StringMatcher matcher = ViewsUtils.createCamelCaseOrRegexMatcher(textFilter.getTextFilterText(), true, false);
        Object[] objectArray = this.fResult.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                IResource resource = (IResource)element;
                boolean guiFilteredParent = true;
                Match[] matchArray = this.fResult.getMatches(element);
                int n3 = matchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Match match = matchArray[n4];
                    if (match instanceof BaseFileMatch) {
                        LineElement lineElement = ((BaseFileMatch)match).getLineElement();
                        IPath location = DVTFileUtils.getInstance().resolveAutoLinkPath(resource);
                        if (location != null) {
                            if (DVTSearchGUIFilterMatcher.filterElement(ViewSet.ViewName.SEARCH, location.toOSString(), lineElement.getContents(), resource.getProject()) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                                guiFilteredParent = false;
                            } else {
                                this.fGuiFiltered = true;
                            }
                        }
                    }
                    ++n4;
                }
                if (!guiFilteredParent) {
                    ++this.fTotal;
                    if (ViewsUtils.matchCamelCaseOrRegex(matcher, this.fLabelProvider.getLabelProviderText(element))) {
                        filtered.add(element);
                        ++this.fDisplayed;
                    }
                }
            }
            ++n2;
        }
        this.fFilteredElements = filtered.toArray();
        return this.fGuiFiltered;
    }

    @Override
    public int getDisplayed() {
        return this.fDisplayed;
    }

    @Override
    public int getTotal() {
        return this.fTotal;
    }

    @Override
    public boolean isGuiFiltered() {
        return this.fGuiFiltered;
    }

    public void dispose() {
    }

    @Override
    public HashSet<Object> getMatchedBold() {
        return null;
    }

    @Override
    public ExactAndPotentialMatchesPerResourcePair getDisplayedPerResource(IResource resource) {
        if (this.fResult instanceof BaseFileSearchResult) {
            int possibleMatchCount = ((BaseFileSearchResult)this.fResult).getPossibleMatchCount(resource);
            return new ExactAndPotentialMatchesPerResourcePair(this.fResult.getMatchCount((Object)resource) - possibleMatchCount, possibleMatchCount);
        }
        return new ExactAndPotentialMatchesPerResourcePair(this.fResult != null ? this.fResult.getMatchCount((Object)resource) : 0, 0);
    }
}

