/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyConstants;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyMorpher;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyTranslater;
import ro.amiq.dvt.ui.smartcopy.SmartCopyIdentity;
import ro.amiq.dvt.ui.smartcopy.SmartCopyOrder;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.ui.smartcopy.SmartCopyTranslation;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.ui.smartcopy.model.ISCObject;

public class SmartCopyAgent {
    private Map<LanguageKind, ISmartCopyTranslater> cachedTranslaters;
    private Map<LanguageKind, ISmartCopyMorpher> cachedMorphers;
    private ISmartCopyTranslater translater;
    private ISmartCopyMorpher morpher;

    private boolean resetMorpherFor(SmartCopyIdentity identity) {
        if (this.isGoodMorpher(this.morpher, identity)) {
            return true;
        }
        this.morpher = this.getGoodMorpher(identity);
        return this.morpher != null;
    }

    private boolean resetTranslaterFor(SmartCopyIdentity identity) {
        if (this.isGoodTranslater(this.translater, identity)) {
            return true;
        }
        this.translater = this.getGoodTranslater(identity);
        return this.translater != null;
    }

    private ISmartCopyTranslater getGoodTranslater(SmartCopyIdentity identity) {
        if (this.cachedTranslaters == null) {
            this.cachedTranslaters = SmartCopyUtils.getAllTranslaters();
        }
        return this.cachedTranslaters.get((Object)identity.lang);
    }

    private ISmartCopyMorpher getGoodMorpher(SmartCopyIdentity identity) {
        if (this.cachedMorphers == null) {
            this.cachedMorphers = SmartCopyUtils.getAllMorphers();
        }
        return this.cachedMorphers.get((Object)identity.lang);
    }

    public SmartCopyTranslation getTemplatePatternFor(SmartCopyIdentity templateIdentity, boolean doFormat) {
        CopyOnWriteArrayList<SmartCopyOrder> orders = SmartCopyPrincipal.INSTANCE.reportOrders();
        Iterator it = orders.iterator();
        SmartCopyOrder order = null;
        SmartCopyTranslation result = new SmartCopyTranslation();
        StringBuilder resultPattern = new StringBuilder();
        while (it.hasNext()) {
            order = (SmartCopyOrder)it.next();
            SmartCopyIdentity morpherIdentity = new SmartCopyIdentity(templateIdentity.operation, order.lang);
            if (!this.resetMorpherFor(morpherIdentity) || !this.resetTranslaterFor(templateIdentity)) continue;
            if (this.morpher.getLanguageKind() != this.translater.getLanguageKind()) {
                result.addError(ISmartCopyConstants.TranslationError.CROSS_LANGUAGE);
                continue;
            }
            if (order.lang == LanguageKind.VLOG && templateIdentity.operation == ISmartCopyConstants.SmartCopyOperation.PASTE_AS_COMPONENT || order.lang == LanguageKind.VHDL && templateIdentity.operation == ISmartCopyConstants.SmartCopyOperation.PASTE_AS_LOGIC_SIGNALS) {
                result.addError(ISmartCopyConstants.TranslationError.CROSS_LANGUAGE);
                continue;
            }
            ISCObject root = this.morpher.getGeneralForm(order.scope, order.lang);
            String templatePattern = this.translater.translateToPattern(templateIdentity, order.lang, root, doFormat);
            if (templatePattern == null) {
                result.addError(ISmartCopyConstants.TranslationError.GENERAL);
            }
            resultPattern.append(templatePattern);
        }
        result.setPattern(resultPattern.toString());
        return result;
    }

    public boolean isGoodTranslater(ISmartCopyTranslater translater, SmartCopyIdentity identity) {
        if (translater == null) {
            return false;
        }
        return translater.getLanguageKind().equals((Object)identity.lang);
    }

    public boolean isGoodMorpher(ISmartCopyMorpher morpher, SmartCopyIdentity identity) {
        if (morpher == null) {
            return false;
        }
        return morpher.getLanguageKind().equals((Object)identity.lang);
    }
}

