/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.text.MessageFormat;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyConstants;
import ro.amiq.dvt.ui.smartcopy.SmartCopyEditorEndActionCommon;
import ro.amiq.dvt.ui.smartcopy.SmartCopyMessages;
import ro.amiq.dvt.ui.smartcopy.SmartCopyOrder;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;

public class SmartCopyEditorEndAction
extends SmartCopyEditorEndActionCommon {
    public SmartCopyEditorEndAction(IEditorPart editor, ISmartCopyConstants.SmartCopyOperation operation) {
        if (!this.init(editor, operation)) {
            throw new IllegalArgumentException();
        }
    }

    public void run() {
        Object[] args = this.getArguments();
        CustomTemplate cTemp = this.getCustomTemplate(args);
        if (cTemp == null) {
            return;
        }
        if (TemplatesViewUtils.showTemplateProposalInEditor(cTemp)) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_INFO_FINISHED_PASTE, args, false);
        } else {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_GENERAL_PASTE, args, true);
        }
    }

    @Override
    public void updateStatusBar(String message, Object[] args, boolean isError) {
        String formatedMessage = message;
        if (args != null && args.length != 0) {
            formatedMessage = MessageFormat.format(message, args);
        }
        if (isError) {
            SmartCopyUtils.updateStatusBarWithError(formatedMessage);
        } else {
            SmartCopyUtils.updateStatusBarWithInfo(formatedMessage);
        }
    }

    public SmartCopyEditorEndAction setTemplatePath(String templatePath) {
        SmartCopyPrincipal.INSTANCE.setCustomTemplatePath(templatePath);
        return this;
    }

    @Override
    protected LanguageKind getLanguageKind(IEditorPart editor) {
        if (editor instanceof DVTEditor && (((DVTEditor)editor).getLanguageKind() == LanguageKind.VHDL || ((DVTEditor)editor).getLanguageKind() == LanguageKind.VLOG)) {
            DVTEditor dvtEditor = (DVTEditor)editor;
            return dvtEditor.getLanguageKind();
        }
        SmartCopyOrder order = SmartCopyPrincipal.INSTANCE.getLastOrder();
        return order.lang;
    }

    @Override
    protected void updateStatusBar(String message, boolean isError) {
        if (isError) {
            SmartCopyUtils.updateStatusBarWithError(message);
        } else {
            SmartCopyUtils.updateStatusBarWithInfo(message);
        }
    }

    @Override
    protected void updateStatusBarForEmptyPattern(String message, Object[] args, boolean isError) {
        this.updateStatusBar(message, args, isError);
    }

    @Override
    protected void updateStatusBarCrossLanguage() {
        this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_UNSUPPORTED_OPERATION, null, true);
    }
}

