/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import org.eclipse.jface.text.templates.Template;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyConstants;
import ro.amiq.dvt.ui.smartcopy.SmartCopyAgent;
import ro.amiq.dvt.ui.smartcopy.SmartCopyIdentity;
import ro.amiq.dvt.ui.smartcopy.SmartCopyMessages;
import ro.amiq.dvt.ui.smartcopy.SmartCopyOrder;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.ui.smartcopy.SmartCopyTranslation;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;

public abstract class SmartCopyEditorEndActionCommon {
    protected SmartCopyAgent agent;
    protected SmartCopyIdentity identity;
    protected IEditorPart editor;

    public boolean init(IEditorPart editor, ISmartCopyConstants.SmartCopyOperation operation) {
        this.editor = editor;
        LanguageKind lang = this.getLanguageKind(editor);
        this.identity = new SmartCopyIdentity(operation, lang);
        this.agent = new SmartCopyAgent();
        return true;
    }

    protected CustomTemplate getCustomTemplate(Object[] args) {
        SmartCopyTranslation result = this.agent.getTemplatePatternFor(this.identity, this.editor instanceof DVTEditor);
        if (result.hasError(ISmartCopyConstants.TranslationError.CROSS_LANGUAGE)) {
            this.updateStatusBarCrossLanguage();
            return null;
        }
        if (result.hasError(ISmartCopyConstants.TranslationError.GENERAL)) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_GENERAL_PASTE, args, true);
            return null;
        }
        if (result.getPattern().isEmpty() || result.getPattern().trim().isEmpty()) {
            this.updateStatusBarForEmptyPattern(SmartCopyMessages.STATUS_MESSAGE_INFO_EMPTY_FINISHED_PASTE, args, false);
            return null;
        }
        Template temp = SmartCopyUtilsCommon.createTemplateFromSCPattern(this.identity, result.getPattern());
        if (temp == null) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_GENERAL_PASTE, args, true);
            return null;
        }
        CustomTemplate cTemp = new CustomTemplate(temp, null);
        return cTemp;
    }

    protected Object[] getArguments() {
        this.updateStatusBar(null, false);
        if (!SmartCopyPrincipal.INSTANCE.isOrdered()) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_INFO_FIRST_COPY, null, false);
            return null;
        }
        SmartCopyOrder order = SmartCopyPrincipal.INSTANCE.getLastOrder();
        Object[] args = new Object[]{SmartCopyUtilsCommon.getDesignKindText(order.scope), SmartCopyUtilsCommon.getScopeName(order.scope), SmartCopyUtilsCommon.getOperationTypeName(this.identity.operation)};
        return args;
    }

    protected abstract void updateStatusBar(String var1, Object[] var2, boolean var3);

    protected abstract void updateStatusBar(String var1, boolean var2);

    protected abstract void updateStatusBarForEmptyPattern(String var1, Object[] var2, boolean var3);

    protected abstract void updateStatusBarCrossLanguage();

    protected abstract LanguageKind getLanguageKind(IEditorPart var1);
}

