/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.smartcopy.SmartCopyEditorStartActionCommon;
import ro.amiq.dvt.ui.smartcopy.SmartCopyMessages;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class SmartCopyEditorStartAction
extends SmartCopyEditorStartActionCommon {
    public SmartCopyEditorStartAction(IEditorPart editor) {
        this.editor = editor;
    }

    @Override
    public void run() {
        if (!(this.editor instanceof DVTEditor) && !(this.editor instanceof MultiPageEditorPart)) {
            return;
        }
        if (this.editor instanceof MultiPageEditorPart) {
            Object selectedPage = ((MultiPageEditorPart)this.editor).getSelectedPage();
            if (!(selectedPage instanceof DVTEditor)) {
                return;
            }
            this.editor = (DVTEditor)selectedPage;
        }
        DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VLOG_FAMILY_REPARSE);
        DVTBuildUtils.waitForAllBuildJobsDone(IDVTConstants.VHDL_FAMILY_REPARSE);
        ISelectionProvider selectionProvider = ((DVTEditor)this.editor).getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return;
        }
        DVTEditor dvtEditor = (DVTEditor)this.editor;
        IRfNamedElementAndScope namedElementAndScope = dvtEditor.getCursorElement();
        if (namedElementAndScope == null) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_NULL_SCOPE, true);
            return;
        }
        IRfNamedElement element = namedElementAndScope.getIRfNamedElement();
        if (element == null) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_NULL_SCOPE, true);
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        String selectedText = textSelection.getText();
        if (selectedText != null) {
            selectedText = selectedText.trim();
        }
        if (selectedText != null && !selectedText.isEmpty() && !selectedText.equals(element.getName())) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_NULL_SCOPE, true);
            return;
        }
        this.giveOrder(dvtEditor, element);
    }

    @Override
    public void updateStatusBar(String Text2, boolean isError) {
        if (isError) {
            SmartCopyUtils.updateStatusBarWithError(Text2);
            return;
        }
        SmartCopyUtils.updateStatusBarWithInfo(Text2);
    }

    @Override
    public IFile getFile(DVTEditor editor) {
        return ResourceUtil.getFile((Object)editor);
    }

    @Override
    public int getOffset(DVTEditor editor) {
        return editor.getCursor();
    }

    @Override
    protected void computeTemplatesBeforehand(DVTEditor dvtEditor) {
    }
}

