/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.smartcopy.SmartCopyMessages;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;

public abstract class SmartCopyEditorStartActionCommon {
    protected IEditorPart editor;

    protected void giveOrder(DVTEditor dvtEditor, IRfNamedElement element) {
        IRfDefElement scopeRaw = element.getDeclaration();
        if (!(scopeRaw instanceof IRfScopeElement)) {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_ERROR_NULL_SCOPE, true);
            return;
        }
        IRfScopeElement scope = (IRfScopeElement)((Object)scopeRaw);
        this.updateStatusBar(null, false);
        if (SmartCopyPrincipal.INSTANCE.giveOrder(this.getLanguageKind(dvtEditor), scope, this.getFile(dvtEditor), this.getOffset(dvtEditor))) {
            Object[] args = new Object[]{SmartCopyUtilsCommon.getDesignKindText(scope), SmartCopyUtilsCommon.getScopeName(scope)};
            this.computeTemplatesBeforehand(dvtEditor);
            String message = MessageFormat.format(SmartCopyMessages.STATUS_MESSAGE_INFO_FINISHED_COPY, args);
            this.updateStatusBar(message, false);
        } else {
            this.updateStatusBar(SmartCopyMessages.STATUS_MESSAGE_INFO_WRONG_SCOPE, true);
        }
    }

    public LanguageKind getLanguageKind(DVTEditor editor) {
        return editor.getLanguageKind();
    }

    protected abstract void computeTemplatesBeforehand(DVTEditor var1);

    public abstract void updateStatusBar(String var1, boolean var2);

    public abstract void run();

    public abstract IFile getFile(DVTEditor var1);

    public abstract int getOffset(DVTEditor var1);
}

