/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyConstants;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.utils.DVTFileUtils;

public class SmartCopyPickTemplateHandler
extends AbstractHandler {
    private static final FilenameFilter FTL_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".ftl") && new File(dir, name).isFile();
        }
    };

    public boolean isEnabled() {
        return SmartCopyPrincipal.INSTANCE.isOrdered();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow;
        String selectedFile;
        block5: {
            block4: {
                FileDialog fileDialog = new FileDialog(DVTUiUtils.getActiveWorkbenchShell());
                fileDialog.setFilterPath(this.computeFilterPath());
                fileDialog.setText("Select Template File");
                fileDialog.setFilterExtensions(new String[]{"*.ftl"});
                selectedFile = fileDialog.open();
                if (selectedFile != null) break block4;
                return null;
            }
            activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null) break block5;
            return null;
        }
        try {
            ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
            Command command = commandService.getCommand("ro.amiq.dvt.ui.smartcopy.pasteFromTemplate");
            Map<String, String> parameters = ISmartCopyConstants.getSCPasteFromTemplateCommandParameters(selectedFile);
            ParameterizedCommand createFromTemplateCommand = ParameterizedCommand.generateCommand((Command)command, parameters);
            IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
            handlerService.executeCommand(createFromTemplateCommand, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private String computeFilterPath() {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.addAll(SmartCopyPickTemplateHandler.getMruTemplateLocations());
        String dotDvtPathString = this.getDotDvtPathString();
        if (dotDvtPathString != null) {
            candidates.add(dotDvtPathString);
        }
        if (DVTSConstants.DVT_USER_SETTINGS != null) {
            candidates.add(DVTSConstants.DVT_USER_SETTINGS);
        }
        if (DVTSConstants.DVT_COMMON_SETTINGS != null) {
            candidates.addAll(Arrays.asList(DVTSConstants.DVT_COMMON_SETTINGS));
        }
        for (String candidate : candidates) {
            File candidateFile;
            if (candidate == null || !(candidateFile = new File(candidate)).exists() || candidateFile.list(FTL_FILTER).length == 0) continue;
            return candidateFile.getAbsolutePath();
        }
        return null;
    }

    private static List<String> getMruTemplateLocations() {
        return SmartCopyPickTemplateHandler.getMruTemplates().stream().map(s -> Path.fromOSString((String)s).removeLastSegments(1).toOSString()).collect(Collectors.toList());
    }

    public static List<String> getMruTemplates() {
        String mruTemplatesString = DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.ui.code.factory.prev_templates");
        return Arrays.asList(mruTemplatesString.split(",")).stream().filter(s -> !s.isEmpty() && new File((String)s).exists()).collect(Collectors.toList());
    }

    private String getDotDvtPathString() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof FileEditorInput)) {
            return null;
        }
        IFile iFile = ((FileEditorInput)editorInput).getFile();
        if (iFile == null) {
            return null;
        }
        IPath dotDvtLocation = iFile.getProject().getFolder(".dvt").getLocation();
        if (dotDvtLocation == null) {
            return null;
        }
        return dotDvtLocation.toOSString();
    }

    public static void injectMru(String templatePath) {
        List<String> existingTemplates = SmartCopyPickTemplateHandler.getMruTemplates();
        existingTemplates.remove(templatePath);
        existingTemplates.add(0, templatePath);
        StringBuilder newPreference = new StringBuilder();
        existingTemplates.stream().limit(10L).forEach(s -> {
            StringBuilder stringBuilder2 = newPreference.append((String)s).append(",");
        });
        DVTPlugin.getDefault().getPreferenceStore().setValue("ro.amiq.dvt.ui.code.factory.prev_templates", newPreference.toString());
    }
}

