/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.smartcopy.SmartCopyOrder;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPlaceHolder;

public enum SmartCopyPrincipal {
    INSTANCE;

    private CopyOnWriteArrayList<SmartCopyOrder> orders = new CopyOnWriteArrayList();
    private String customTemplatePath;

    public boolean giveOrder(LanguageKind lang, IRfScopeElement scope, IFile f2, int offset) {
        if (!this.goodOrder(scope, f2, offset)) {
            return false;
        }
        if (!this.orders.isEmpty()) {
            this.orders.clear();
        }
        this.orders.add(new SmartCopyOrder(new SmartCopyPlaceHolder(f2, offset), scope, lang));
        return true;
    }

    public boolean isOrdered() {
        this.makeOrdersConsistent();
        return !this.orders.isEmpty();
    }

    private void makeOrdersConsistent() {
        if (this.orders.isEmpty()) {
            return;
        }
        ArrayList<SmartCopyOrder> shouldRemove = new ArrayList<SmartCopyOrder>();
        for (SmartCopyOrder order : this.orders) {
            if (order.scope.getName() != null) continue;
            shouldRemove.add(order);
        }
        this.orders.removeAll(shouldRemove);
    }

    private boolean goodOrder(IRfScopeElement elem, IFile file, int offset) {
        if (file == null || offset < 0) {
            return false;
        }
        if (elem instanceof IRfDefElement) {
            elem = ((IRfDefElement)((Object)elem)).getNamedElement();
        }
        if (!(elem instanceof IRfDesignElement)) {
            return false;
        }
        switch (((IRfDesignElement)elem).getKind()) {
            case VHDL_ENTITY: 
            case VLOG_MODULE: 
            case VLOG_PROGRAM: 
            case VLOG_INTERFACE: 
            case VLOG_CHECKER: {
                return true;
            }
        }
        return false;
    }

    public CopyOnWriteArrayList<SmartCopyOrder> reportOrders() {
        return this.orders;
    }

    public SmartCopyOrder getLastOrder() {
        return this.orders.get(this.orders.size() - 1);
    }

    public void flushOrders(IProject project) {
        if (this.orders.isEmpty()) {
            return;
        }
        ArrayList<SmartCopyOrder> removed = new ArrayList<SmartCopyOrder>();
        for (SmartCopyOrder order : this.orders) {
            if (this.getProjectOfOrder(order) != project) continue;
            removed.add(order);
        }
        this.orders.removeAll(removed);
    }

    public IProject getProjectOfOrder(SmartCopyOrder order) {
        if (order == null || order.scope == null) {
            return null;
        }
        if (!(order.scope instanceof IRfDefElement)) {
            return null;
        }
        IResource file = ((IRfDefElement)((Object)order.scope)).getFileAdapter();
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public void setCustomTemplatePath(String customTemplatePath) {
        this.customTemplatePath = customTemplatePath;
    }

    public String getCustomTemplatePath() {
        return this.customTemplatePath;
    }
}

