/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyMorpher;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyTranslater;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;

public class SmartCopyUtils
extends SmartCopyUtilsCommon {
    public static void updateStatusBarWithWarning(String text) {
        SmartCopyUtils.updateStatusBar(text, DVTImages.WARNING_ICON);
    }

    public static void updateStatusBarWithError(String text) {
        SmartCopyUtils.updateStatusBar(text, DVTImages.DESC_ERROR_TASK);
    }

    public static void updateStatusBarWithInfo(String text) {
        SmartCopyUtils.updateStatusBar(text, DVTImages.INFORMATION);
    }

    private static void updateStatusBar(String text, ImageDescriptor image) {
        IActionBars actionBars;
        IWorkbenchWindow activeWorkbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbench == null) {
            return;
        }
        IWorkbenchPage page = activeWorkbench.getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return;
        }
        boolean isEditorSite = site instanceof IEditorSite;
        boolean isViewSite = site instanceof IViewSite;
        Object object = isEditorSite ? ((IEditorSite)site).getActionBars() : (actionBars = isViewSite ? ((IViewSite)site).getActionBars() : null);
        if (actionBars == null) {
            return;
        }
        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
        if (statusLineManager == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (statusLineManager instanceof SubStatusLineManager) {
                ((SubStatusLineManager)statusLineManager).setVisible(true);
            }
            if (text == null) {
                statusLineManager.setMessage(null, null);
                return;
            }
            String capitalizedText = text;
            if (text.length() > 0) {
                String firstChar = text.substring(0, 1).toUpperCase();
                capitalizedText = String.valueOf(firstChar) + text.substring(1, text.length());
            }
            statusLineManager.setMessage(DVTImages.imageCache.getImage(image), capitalizedText);
            ObjectionManager.getInstance().clear(Objection.STATUS_BAR_MESSAGE_UPDATED);
        });
    }

    public static Map<LanguageKind, ISmartCopyMorpher> getAllMorphers() {
        EnumMap<LanguageKind, ISmartCopyMorpher> morphers = new EnumMap<LanguageKind, ISmartCopyMorpher>(LanguageKind.class);
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.SCMorphers");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!"SCMorphers".equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.SCMorphers"));
                    }
                    ISmartCopyMorpher morpher = (ISmartCopyMorpher)configurationElement.createExecutableExtension("class");
                    morphers.put(morpher.getLanguageKind(), morpher);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return morphers;
    }

    public static Map<LanguageKind, ISmartCopyTranslater> getAllTranslaters() {
        EnumMap<LanguageKind, ISmartCopyTranslater> translaters = new EnumMap<LanguageKind, ISmartCopyTranslater>(LanguageKind.class);
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.SCTranslaters");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!"SCTranslaters".equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.SCMorphers"));
                    }
                    ISmartCopyTranslater translater = (ISmartCopyTranslater)configurationElement.createExecutableExtension("class");
                    translaters.put(translater.getLanguageKind(), translater);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return translaters;
    }
}

