/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.smartcopy;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.templates.Template;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyConstants;
import ro.amiq.dvt.ui.smartcopy.IllegalMorphException;
import ro.amiq.dvt.ui.smartcopy.IllegalTranslateException;
import ro.amiq.dvt.ui.smartcopy.SmartCopyIdentity;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsCommon;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtilsCommon;

public class SmartCopyUtilsCommon {
    public static String getOperationTypeName(ISmartCopyConstants.SmartCopyOperation operation) {
        if (operation == null) {
            return "";
        }
        switch (operation) {
            case PASTE_AS_INSTANCE: {
                return "instance";
            }
            case PASTE_AS_SIGNALS: {
                return "signals";
            }
            case PASTE_AS_LOGIC_SIGNALS: {
                return "logic_signals";
            }
            case PASTE_AS_TESTBENCH: {
                return "testbench";
            }
            case PASTE_AS_COMPONENT: {
                return "component";
            }
            case PASTE_AS_WAVEDROM_DIAGRAM: {
                return "wavedrom";
            }
            case PASTE_FROM_TEMPLATE: {
                return "content";
            }
        }
        return "";
    }

    public static String getOperationTypeDescription(ISmartCopyConstants.SmartCopyOperation operation) {
        if (operation == null) {
            return "";
        }
        switch (operation) {
            case PASTE_AS_INSTANCE: {
                return "instance";
            }
            case PASTE_AS_SIGNALS: {
                return "signals";
            }
            case PASTE_AS_LOGIC_SIGNALS: {
                return "logic signals";
            }
            case PASTE_AS_TESTBENCH: {
                return "testbench";
            }
            case PASTE_AS_COMPONENT: {
                return "component";
            }
            case PASTE_AS_WAVEDROM_DIAGRAM: {
                return "wavedrom";
            }
            case PASTE_FROM_TEMPLATE: {
                return "content";
            }
        }
        return "";
    }

    public static String getTemplateDescription(ISmartCopyConstants.SmartCopyOperation operation) {
        return "Create " + SmartCopyUtilsCommon.getOperationTypeDescription(operation);
    }

    public static Template createTemplateFromSCPattern(SmartCopyIdentity templateIdentity, String pattern) {
        if (templateIdentity == null || pattern == null) {
            return null;
        }
        String fullNatureName = TemplatesViewUtilsCommon.getNatureFromLanguageKind(templateIdentity.lang);
        if (fullNatureName.isEmpty()) {
            return null;
        }
        String fullContextId = TemplatesViewUtilsCommon.getFullContextId(fullNatureName, "Any Context");
        if (fullContextId.isEmpty()) {
            return null;
        }
        Template template = new Template(SmartCopyUtilsCommon.getTemplateName(templateIdentity), SmartCopyUtilsCommon.getTemplateDescription(templateIdentity.operation), fullContextId, pattern, false);
        return template;
    }

    public static String getTemplateName(SmartCopyIdentity templateIdentity) {
        if (templateIdentity.lang == LanguageKind.VLOG) {
            return "vlog_paste_as_" + SmartCopyUtilsCommon.getOperationTypeName(templateIdentity.operation);
        }
        if (templateIdentity.lang == LanguageKind.VHDL) {
            return "vhdl_paste_as_" + SmartCopyUtilsCommon.getOperationTypeName(templateIdentity.operation);
        }
        return "paste_as_" + SmartCopyUtilsCommon.getOperationTypeName(templateIdentity.operation);
    }

    public static String getTemplatePath(SmartCopyIdentity templateIdentity) {
        if (templateIdentity.operation == ISmartCopyConstants.SmartCopyOperation.PASTE_FROM_TEMPLATE) {
            return SmartCopyPrincipal.INSTANCE.getCustomTemplatePath();
        }
        return String.valueOf(SmartCopyUtilsCommon.getTemplateName(templateIdentity)) + ".ftl";
    }

    public static void checkNonNullMorph(Object ... args) {
        if (args == null) {
            throw new IllegalMorphException();
        }
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg == null) {
                throw new IllegalMorphException();
            }
            ++n2;
        }
    }

    public static void checkNonNullTranslate(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg == null) {
                throw new IllegalTranslateException();
            }
            ++n2;
        }
    }

    public static String getDesignKindText(IRfScopeElement scope) {
        if (!(scope instanceof IRfDefElement)) {
            return "";
        }
        IRfNamedElement elem = ((IRfDefElement)((Object)scope)).getNamedElement();
        if (!(elem instanceof IRfDesignElement)) {
            return "";
        }
        return TCViewUtilsCommon.getDesignKindText(elem);
    }

    public static String getScopeName(IRfScopeElement scope) {
        if (!(scope instanceof IRfDefElement)) {
            return "";
        }
        String name = ((IRfDefElement)((Object)scope)).getName();
        return name != null ? name : "";
    }

    public static String escapeTemplateText(String text) {
        if (text == null) {
            return null;
        }
        try {
            String result = text.replace("\\$", "\\$\\$").replace("\\uFFF0", " ");
            return result;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return text;
        }
    }

    public static String nonNull(String field) {
        return field == null ? "" : field;
    }

    public static <T> List<T> nonNull(List<T> objects) {
        return objects == null ? Collections.emptyList() : objects;
    }

    public static boolean hasField(String field) {
        return field != null && !field.isEmpty();
    }

    public static boolean hasField(List<? extends Object> objects) {
        return objects != null && !objects.isEmpty();
    }

    public static void logError(Throwable e) {
        DVTLogger.INSTANCE.logError(e);
    }
}

