/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.statusbarnotifications;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogConstants;
import ro.amiq.dvt.ui.statusbarnotifications.ButtonAction;
import ro.amiq.dvt.ui.statusbarnotifications.StatusBarNotificationManager;
import ro.amiq.dvt.ui.statusbarnotifications.widgets.AbstractStatusBarNotificationWidget;

public abstract class AbstractStatusBarNotification {
    private static final int MAX_MESSAGE_LENGHT = 1000;
    protected AbstractStatusBarNotificationWidget widget;
    private String message;
    private int timeout;
    private LinkedList<ButtonAction> actions;

    protected AbstractStatusBarNotification(String message, int timeout, LinkedList<ButtonAction> actions) {
        if (message.length() > 1000) {
            message = message.substring(0, 1000);
            message = message.concat("...");
        }
        this.message = message;
        this.timeout = timeout;
        this.actions = actions;
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        ButtonAction closeButtonAction = new ButtonAction(IDialogConstants.CLOSE_LABEL){

            @Override
            public void run() {
                StatusBarNotificationManager.INSTANCE.dismissNotification(AbstractStatusBarNotification.this.getWidget());
            }
        };
        this.actions.add(closeButtonAction);
    }

    public String getMessage() {
        return this.message;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List<ButtonAction> getActions() {
        return this.actions;
    }

    public void addAction(ButtonAction action) {
        this.actions.add(action);
    }

    public AbstractStatusBarNotificationWidget getWidget() {
        if (this.widget == null || this.widget.isDisposed()) {
            this.widget = this.createWidget();
        }
        return this.widget;
    }

    protected abstract AbstractStatusBarNotificationWidget createWidget();

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStatusBarNotification other = (AbstractStatusBarNotification)obj;
        return Objects.equals(this.message, other.message);
    }
}

