/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.statusbarnotifications;

import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.statusbarnotifications.AbstractStatusBarNotification;
import ro.amiq.dvt.ui.statusbarnotifications.widgets.AbstractStatusBarNotificationWidget;

public enum StatusBarNotificationManager {
    INSTANCE;

    private static final String SHOW_NOTIFICATIONS_TOOLTIP = "Show Notifications";
    private static final String NO_AVAILABLE_NOTIFICATIONS_TOOLTIP = "No Available Notifications";
    private static final int POSITION_UPDATE_DELAY = 100;
    private static final float MAX_NOTIFICATIONS_SPACE_SCREEN_RATIO = 0.66f;
    private static final int NOTIFICATION_SPACING = 10;
    private static final int SCREEN_MARGIN = 10;
    private int maxNotificationSpace;
    private int availableNotificationSpace;
    private final LinkedHashSet<AbstractStatusBarNotificationWidget> activeNotificationsWidgets = new LinkedHashSet();
    private final LinkedHashSet<AbstractStatusBarNotification> notificationHistory = new LinkedHashSet();
    private final ScheduledExecutorService positionUpdateExecutorService = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> updatePositionJob;
    private Button showNotificationsButton;
    private boolean isShowNotificationButtonInitialized;

    public void init() {
        try {
            this.addListenersToShell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            if (!this.isShowNotificationButtonInitialized) {
                this.createShowNotificationButton();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.updateMaxNotificationSpace();
    }

    private boolean addNotificationWiget(AbstractStatusBarNotificationWidget notification) {
        if (this.activeNotificationsWidgets.contains(notification)) {
            return false;
        }
        this.availableNotificationSpace -= notification.getWidgetHeight();
        return this.activeNotificationsWidgets.add(notification);
    }

    private boolean removeNotificationWidget(AbstractStatusBarNotificationWidget notification) {
        if (!this.activeNotificationsWidgets.contains(notification)) {
            return false;
        }
        this.availableNotificationSpace += notification.getWidgetHeight();
        return this.activeNotificationsWidgets.remove(notification);
    }

    private void updateMaxNotificationSpace() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        try {
            display.syncExec(() -> {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell parentShell = window.getShell();
                int oldMaxSpace = this.maxNotificationSpace;
                this.maxNotificationSpace = (int)(parentShell == null ? 0.0f : (float)parentShell.getSize().y * 0.66f);
                this.availableNotificationSpace -= oldMaxSpace - this.maxNotificationSpace;
                while (this.availableNotificationSpace < 0) {
                    Optional oldestNotification = this.activeNotificationsWidgets.stream().findFirst();
                    if (!oldestNotification.isPresent()) break;
                    this.internalDismissNotification((AbstractStatusBarNotificationWidget)oldestNotification.get(), false, false);
                }
            });
        }
        catch (SWTException sWTException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addListenersToShell(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Listener listener = event -> {
            this.updateMaxNotificationSpace();
            if (this.activeNotificationsWidgets == null || this.activeNotificationsWidgets.isEmpty()) {
                return;
            }
            this.updateNotificationPositions();
        };
        shell.addListener(10, listener);
        shell.addListener(11, listener);
    }

    private void createShowNotificationButton() {
        Composite trimToolbar = DVTUiUtils.getTrimToolbarParent((Composite)DVTUiUtils.getActiveWorkbenchShell());
        if (trimToolbar == null) {
            DVTLogger.INSTANCE.logError("Statusbar Notifications History not initialized. Trim toolbar could not be found.");
            return;
        }
        Composite composite = new Composite(trimToolbar, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, 0).applyTo(composite);
        this.showNotificationsButton = new Button(composite, 8);
        this.showNotificationsButton.setImage(DVTImages.imageCache.getImage(DVTImages.SHOW_NOTIFICATIONS));
        this.showNotificationsButton.setToolTipText(NO_AVAILABLE_NOTIFICATIONS_TOOLTIP);
        this.showNotificationsButton.setEnabled(false);
        this.showNotificationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(() -> StatusBarNotificationManager.this.showTimedOutNotifications());
            }
        });
        this.isShowNotificationButtonInitialized = true;
    }

    private void disableShowNotificationsButton() {
        Display.getDefault().asyncExec(() -> {
            this.showNotificationsButton.setToolTipText(NO_AVAILABLE_NOTIFICATIONS_TOOLTIP);
            this.showNotificationsButton.setEnabled(false);
            this.showNotificationsButton.redraw();
        });
    }

    private void enableShowNotificationsButton() {
        Display.getDefault().asyncExec(() -> {
            this.showNotificationsButton.setToolTipText(SHOW_NOTIFICATIONS_TOOLTIP);
            this.showNotificationsButton.setEnabled(true);
            this.showNotificationsButton.redraw();
        });
    }

    public void showNotification(AbstractStatusBarNotification notification) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        try {
            display.syncExec(() -> this.lambda$4(notification, display));
        }
        catch (SWTException sWTException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateNotificationPositions() {
        if (this.updatePositionJob != null) {
            this.updatePositionJob.cancel(false);
        }
        this.updatePositionJob = this.positionUpdateExecutorService.schedule(() -> {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().syncExec(() -> {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell shell = window.getShell();
                if (shell != null && !shell.isDisposed()) {
                    Rectangle clientArea = shell.getClientArea();
                    Point shellLocation = shell.getLocation();
                    int clientX = shellLocation.x + clientArea.x;
                    int clientY = shellLocation.y + clientArea.y;
                    int clientWidth = clientArea.width;
                    int clientHeight = clientArea.height;
                    int y = clientY + clientHeight - 10 + 10;
                    for (AbstractStatusBarNotificationWidget notificationWidget : this.activeNotificationsWidgets) {
                        Point size = notificationWidget.getSize();
                        y -= size.y;
                        int x = clientX + clientWidth - size.x - 10;
                        notificationWidget.setLocation(x, y -= 10);
                        notificationWidget.open();
                    }
                }
            });
        }, 100L, TimeUnit.MILLISECONDS);
    }

    public void dismissNotification(AbstractStatusBarNotificationWidget widget) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.internalDismissNotification(widget, true, false));
    }

    private void internalDismissNotification(AbstractStatusBarNotificationWidget widget, boolean withPositionUpdate, boolean keepHistory) {
        if (widget == null) {
            return;
        }
        if (widget.isDisposed()) {
            this.removeNotificationWidget(widget);
            return;
        }
        this.removeNotificationWidget(widget);
        widget.close();
        if (keepHistory) {
            this.notificationHistory.add(widget.getNotification());
            this.enableShowNotificationsButton();
        }
        if (withPositionUpdate) {
            this.updateNotificationPositions();
        }
    }

    public void showTimedOutNotifications() {
        this.disableShowNotificationsButton();
        LinkedHashSet<AbstractStatusBarNotification> historyCopy = new LinkedHashSet<AbstractStatusBarNotification>(this.notificationHistory);
        this.notificationHistory.clear();
        for (AbstractStatusBarNotification notification : historyCopy) {
            this.showNotification(notification);
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$4(AbstractStatusBarNotification var1_1, Display var2_2) {
        block4: {
            widget = var1_1.getWidget();
            if (this.maxNotificationSpace < widget.getWidgetHeight()) {
                this.internalDismissNotification(widget, false, false);
                return;
            }
            if (!this.isShowNotificationButtonInitialized) {
                this.createShowNotificationButton();
            }
            if (!(alreadyDisplayed = this.activeNotificationsWidgets.contains(widget))) ** GOTO lbl15
            for (AbstractStatusBarNotificationWidget activeWidget : this.activeNotificationsWidgets) {
                if (!widget.equals(activeWidget)) continue;
                this.internalDismissNotification(activeWidget, true, false);
                break block4;
            }
            break block4;
            while ((oldestNotification = this.activeNotificationsWidgets.stream().findFirst()).isPresent()) {
                this.internalDismissNotification((AbstractStatusBarNotificationWidget)oldestNotification.get(), false, false);
lbl15:
                // 2 sources

                if (this.availableNotificationSpace <= widget.getWidgetHeight()) continue;
            }
        }
        this.addNotificationWiget(widget);
        this.updateNotificationPositions();
        var2_2.timerExec(var1_1.getTimeout(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$5(ro.amiq.dvt.ui.statusbarnotifications.widgets.AbstractStatusBarNotificationWidget ), ()V)((StatusBarNotificationManager)this, (AbstractStatusBarNotificationWidget)widget));
    }

    private /* synthetic */ void lambda$5(AbstractStatusBarNotificationWidget abstractStatusBarNotificationWidget) {
        this.internalDismissNotification(abstractStatusBarNotificationWidget, true, true);
    }
}

