/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.statusbarnotifications.widgets;

import java.util.List;
import java.util.Objects;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.statusbarnotifications.AbstractStatusBarNotification;
import ro.amiq.dvt.ui.statusbarnotifications.ButtonAction;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class AbstractStatusBarNotificationWidget {
    public static final String SHELL_METADATA = "StatusBarNotification";
    private static final Color LIGHT_BACKGROUND = DVTColorUtil.INSTANCE.getColor(255, 255, 255);
    private static final Color DARK_BACKGROUND = DVTColorUtil.INSTANCE.getColor(60, 60, 60);
    protected static final boolean IS_DARK = DVTThemeUtils.isDarkUI();
    protected static final Color BACKGROUND_COLOR = IS_DARK ? DARK_BACKGROUND : LIGHT_BACKGROUND;
    protected static final int SHELL_STYLE = 524296;
    protected static final int FIXED_WIDTH = 450;
    protected static final int MINIMUM_HEIGHT = 100;
    protected static final int MAX_HEIGHT = 200;
    protected static final int MARGIN_SIZE = 10;
    protected int widgetHeight;
    protected Shell shell;
    protected AbstractStatusBarNotification notification;

    public int getWidgetHeight() {
        return this.widgetHeight;
    }

    protected AbstractStatusBarNotificationWidget(AbstractStatusBarNotification notification) {
        this.notification = notification;
        this.createShell();
        this.createLayout();
    }

    private void createShell() {
        Shell parentShell = DVTUiUtils.getActiveWorkbenchShell();
        this.shell = parentShell == null ? new Shell(PlatformUI.getWorkbench().getDisplay(), 524296) : new Shell(parentShell, 524296);
        this.shell.setVisible(false);
        this.shell.setData((Object)SHELL_METADATA);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setBackground(BACKGROUND_COLOR);
    }

    private void createLayout() {
        GridLayout layout = (GridLayout)this.shell.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        Composite contentComposite = new Composite((Composite)this.shell, 0);
        contentComposite.setLayout((Layout)new GridLayout(1, false));
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        contentComposite.setSize(450, 100);
        contentComposite.setBackground(this.shell.getBackground());
        this.createContents(contentComposite);
        Composite buttonsComposite = new Composite(contentComposite, 0);
        List<ButtonAction> actions = this.notification.getActions();
        int numButtons = actions != null ? actions.size() : 0;
        buttonsComposite.setLayout((Layout)new GridLayout(numButtons, false));
        buttonsComposite.setLayoutData((Object)new GridData(0x1000008, 1024, true, false));
        buttonsComposite.setBackground(this.shell.getBackground());
        this.createButtons(buttonsComposite);
        int elementsSize = contentComposite.computeSize((int)-1, (int)-1).y;
        this.widgetHeight = Math.min(elementsSize, 200);
        this.shell.setSize(460, this.widgetHeight + 10);
        contentComposite.setSize(450, this.widgetHeight);
    }

    protected abstract void createButtons(Composite var1);

    protected abstract void createContents(Composite var1);

    public void open() {
        this.shell.setVisible(true);
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public Point getSize() {
        return this.shell.getSize();
    }

    public void setLocation(int x, int y) {
        this.shell.setLocation(x, y);
    }

    public AbstractStatusBarNotification getNotification() {
        return this.notification;
    }

    public int hashCode() {
        return Objects.hash(this.notification);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStatusBarNotificationWidget other = (AbstractStatusBarNotificationWidget)obj;
        return Objects.equals(this.notification, other.notification);
    }
}

