/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.statusbarnotifications.widgets;

import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.ui.statusbarnotifications.AbstractStatusBarNotification;
import ro.amiq.dvt.ui.statusbarnotifications.ButtonAction;
import ro.amiq.dvt.ui.statusbarnotifications.widgets.AbstractStatusBarNotificationWidget;

public class StatusBarBasicNotificationWidget
extends AbstractStatusBarNotificationWidget {
    public static final String MESSAGE_LABEL_METADATA = "StatusBarNotificationMessage";
    private static final int SCROLLBAR_WIDTH = 30;

    public StatusBarBasicNotificationWidget(AbstractStatusBarNotification notification) {
        super(notification);
    }

    @Override
    protected void createContents(Composite contentComposite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(contentComposite, 512);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setBackground(this.shell.getBackground());
        Composite messageComposite = new Composite((Composite)scrolledComposite, 0);
        messageComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        messageComposite.setBackground(this.shell.getBackground());
        GridData messageLayoutData = new GridData(4, 128, true, true);
        messageLayoutData.widthHint = this.getAvailableWidth(contentComposite);
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setData((Object)MESSAGE_LABEL_METADATA);
        messageLabel.setText(this.notification.getMessage());
        messageLabel.setLayoutData((Object)messageLayoutData);
        messageLabel.setBackground(this.shell.getBackground());
        messageComposite.pack();
        scrolledComposite.setContent((Control)messageComposite);
        scrolledComposite.setMinHeight(messageComposite.computeSize((int)-1, (int)-1).y);
    }

    private int getAvailableWidth(Composite parentComposite) {
        int parentWidth = parentComposite.getSize().x;
        Control[] children = parentComposite.getChildren();
        if (children.length > 0 && children[0] instanceof Label) {
            Label firstColumnLabel = (Label)children[0];
            int firstColumnWidth = firstColumnLabel.computeSize((int)-1, (int)-1).x;
            return parentWidth - firstColumnWidth - 20 - 10 - 30;
        }
        return parentWidth / 2;
    }

    @Override
    protected void createButtons(Composite buttonsComposite) {
        List<ButtonAction> actions = this.notification.getActions();
        if (actions == null || actions.isEmpty()) {
            return;
        }
        for (final ButtonAction action : actions) {
            Button actionButton = new Button(buttonsComposite, 8);
            actionButton.setText(action.getLabel());
            actionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    action.run();
                }
            });
        }
    }
}

