/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.trace.connections.TCJob;
import ro.amiq.dvt.ui.trace.connections.TCViewMessages;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;

public class TCEditorJob
extends TCJob {
    private ElementPath instancePath;

    public TCEditorJob(IRfNamedElement tracedConn, IRfNamedElement tracedModule, ElementPath instancePath, boolean matchPrefix, boolean forceDiagramAll, IProject project, TCOperation traceOperation) {
        super(tracedConn, tracedModule, instancePath, matchPrefix, forceDiagramAll, project, traceOperation);
        this.instancePath = instancePath;
    }

    @Override
    protected IStatus runTrace(IProgressMonitor monitor) {
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.subTask("");
            if (this.instancePath == null || this.instancePath.isEmpty()) {
                this.popNoInstanceFoundDialog();
                return Status.CANCEL_STATUS;
            }
            if (!this.traceConnectionOperation(this.tracedConn, this.instancePath, this.forceDiagramAll, this.traceOperation, monitor)) {
                TCViewUtils.popDialog(1, TCViewMessages.fFailedTraceOperationMessage);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (CanceledTraceException canceledTraceException) {
            return Status.CANCEL_STATUS;
        }
    }
}

