/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsView;

public enum TCEngine {
    INSTANCE;

    private TraceConnectionsView traceConnectionsView;

    public void runFromHierarchy(TCOperation traceOperation, IRfNamedElement conn, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap, IProgressMonitor monitor, ElementPath dhTopElementPath, ElementPath selectedInstanceElementPath) throws CanceledTraceException {
        if (conn == null || selectedInstanceElementPath == null || traceOperation == null) {
            return;
        }
        if (ViewsUtils.isCanceled(monitor)) {
            throw new CanceledTraceException();
        }
        this.traceConnection(conn, traceOperation, dummyPortMap, false, monitor, dhTopElementPath, selectedInstanceElementPath);
    }

    public boolean runFromEditor(TCOperation traceOperation, IRfNamedElement signal, ElementPath instanceElementPath, boolean forceShowDiagramAll, IProgressMonitor monitor) throws CanceledTraceException {
        if (signal == null || instanceElementPath == null || traceOperation == null) {
            return false;
        }
        if (ViewsUtils.isCanceled(monitor)) {
            throw new CanceledTraceException();
        }
        ELManager elManager = signal.getRfProject().getELManager();
        ELInstance elInstance = elManager.getMemory().instanceFor(instanceElementPath);
        IRfInstanceElement instance = elInstance.getDescription();
        IRfNamedElement componentHint = elInstance.getBinding(true);
        List<IRfPortElement> ports = DesignUtils.getPorts(DesignUtils.DesignRequest.of((IRfNamedElement)instance, componentHint), false, null);
        IRfNamedElement tracedConn = signal;
        if (tracedConn instanceof IRfPortElement) {
            for (IRfPortElement possiblePort : ports) {
                if (!possiblePort.getName().equals(signal.getName())) continue;
                tracedConn = possiblePort;
                break;
            }
        }
        ElementPath topElementPath = instanceElementPath;
        ElementPath upperPath = ElementPath.upperPathOf(instanceElementPath);
        while (upperPath != null && !upperPath.isEmpty()) {
            topElementPath = upperPath;
            upperPath = ElementPath.upperPathOf(upperPath);
        }
        this.traceConnection(tracedConn, traceOperation, new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>(0), forceShowDiagramAll, monitor, topElementPath, instanceElementPath);
        return true;
    }

    private TraceConnectionsView openTracePortsView() {
        IViewPart view;
        IWorkbenchPage page;
        block6: {
            block5: {
                try {
                    page = DVTUiUtils.getActivePage();
                    if (page != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            view = null;
            if (page.findViewReference("ro.amiq.dvt.ui.views.TraceConnectionsView") == null) {
                view = page.showView("ro.amiq.dvt.ui.views.TraceConnectionsView", null, 3);
            }
            if ((view = page.showView("ro.amiq.dvt.ui.views.TraceConnectionsView", null, 2)) instanceof TraceConnectionsView) break block6;
            return null;
        }
        page.bringToTop((IWorkbenchPart)view);
        return (TraceConnectionsView)view;
    }

    private void traceConnection(IRfNamedElement signal, TCOperation traceOperation, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap, boolean forceShowDiagramAll, IProgressMonitor monitor, ElementPath rootElementPath, ElementPath selectedInstanceElementPath) throws CanceledTraceException {
        if (ViewsUtils.isCanceled(monitor)) {
            throw new CanceledTraceException();
        }
        Utils.safeRunSynchInUIThread(() -> {
            this.traceConnectionsView = this.openTracePortsView();
            if (this.traceConnectionsView != null) {
                this.traceConnectionsView.setFocus();
            }
        });
        if (this.traceConnectionsView == null) {
            return;
        }
        this.traceConnectionsView.clean();
        this.traceConnectionsView.updateTrace(traceOperation, signal, dummyPortMap, forceShowDiagramAll, monitor, rootElementPath, selectedInstanceElementPath);
        this.traceConnectionsView = null;
    }
}

