/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.trace.connections.TCEngine;
import ro.amiq.dvt.ui.trace.connections.TCViewMessages;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsCommon;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.designhierarchy.IDHLabelProvider;
import ro.amiq.dvt.utils.ElementListSelectionDialog;
import ro.amiq.dvt.utils.FilteredList;
import ro.amiq.dvt.utils.StringMatcher;

public class TCJob
extends WorkspaceJob {
    private IRfNamedElement tracedModule;
    private boolean isCanceled;
    protected IRfNamedElement tracedConn;
    protected TCOperation traceOperation;
    protected boolean forceDiagramAll;
    private IProject project;
    private List<ElementPath> instancesList;
    private ElementPath partialInstancePath;
    private boolean matchPrefix;
    private final DVTBaseLabelProvider labelProvider = new DVTBaseLabelProvider(){

        @Override
        public String getText(Object element) {
            if (element instanceof ElementPath) {
                return ((ElementPath)element).toString();
            }
            return super.getText(element);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof ElementPath && TCJob.this.tracedConn != null) {
                IRfNamedElement elementFromElInstance;
                ELManager elManager = TCJob.this.tracedConn.getRfProject().getELManager();
                ELInstance elInstance = elManager.getMemory().instanceFor((ElementPath)element);
                IRfNamedElement iRfNamedElement = elementFromElInstance = elInstance.getDescription() instanceof DummyInstance ? elInstance.getBinding(true) : elInstance.getDescription();
                if (elementFromElInstance != null) {
                    IDHLabelProvider dhLabelProvider = DHViewUtils.getLabelProvider();
                    if (dhLabelProvider == null) {
                        return null;
                    }
                    BasicElementWrapper elementWrapper = new BasicElementWrapper(elementFromElInstance);
                    elementWrapper.setInstanceType((IRfDesignElement)elInstance.getBinding(true));
                    return dhLabelProvider.getImage(elementWrapper);
                }
            }
            return super.getImage(element);
        }
    };

    public TCJob(IRfNamedElement tracedConn, IRfNamedElement tracedModule, ElementPath partialInstancePath, boolean matchPrefix, boolean forceDiagramAll, IProject project, TCOperation traceOperation) {
        super(TCViewMessages.fJobText);
        this.setUser(true);
        this.setSystem(false);
        this.setRule((ISchedulingRule)project);
        this.tracedConn = tracedConn;
        this.tracedModule = tracedModule;
        this.partialInstancePath = partialInstancePath;
        this.matchPrefix = matchPrefix;
        this.forceDiagramAll = forceDiagramAll;
        this.project = project;
        this.traceOperation = traceOperation;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        this.isCanceled = false;
        monitor.subTask(TCViewMessages.fJobTaskSearchInstancesText);
        if (this.tracedModule == null) {
            return Status.CANCEL_STATUS;
        }
        IRfSingleLangProject rfProject = this.tracedModule.getRfProject();
        if (rfProject == null) {
            return Status.CANCEL_STATUS;
        }
        return this.runTrace(monitor);
    }

    protected IStatus runTrace(IProgressMonitor monitor) {
        this.instancesList = this.getInstancesForTracedModule(this.tracedModule);
        this.instancesList = this.filterInstanceListElabMode(this.instancesList, this.matchPrefix);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask("");
        if (this.instancesList == null || this.instancesList.isEmpty()) {
            this.popNoInstanceFoundDialog();
            return Status.CANCEL_STATUS;
        }
        if (this.instancesList.size() > 1) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display d = workbench.getDisplay();
            d.asyncExec(() -> new SelectInstanceDialog(this.tracedModule).open());
        } else {
            try {
                if (!this.traceConnectionOperation(this.tracedConn, this.instancesList.get(0), this.forceDiagramAll, this.traceOperation, monitor)) {
                    TCViewUtils.popDialog(1, TCViewMessages.fFailedTraceOperationMessage);
                }
                monitor.done();
            }
            catch (CanceledTraceException canceledTraceException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    protected void popNoInstanceFoundDialog() {
        String fTraceModuleName = this.tracedModule.getName();
        String designName = TCViewUtilsCommon.getDesignKindText(this.tracedModule);
        Object[] args = new Object[]{fTraceModuleName, designName};
        String customText = MessageFormat.format(TCViewMessages.fNoInstancesFoundMessageParam, args);
        TCViewUtils.popDialog(2, customText);
    }

    private List<ElementPath> filterInstanceListElabMode(List<ElementPath> list, boolean matchPrefix) {
        if (this.partialInstancePath == null || this.partialInstancePath.isEmpty() || list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<ElementPath> listOfInstances = new ArrayList<ElementPath>(list);
        Iterator iterator = listOfInstances.iterator();
        while (iterator.hasNext()) {
            ElementPath potential = (ElementPath)iterator.next();
            if (!(matchPrefix ? !potential.startsWith(this.partialInstancePath) : !potential.endsWith(this.partialInstancePath))) continue;
            iterator.remove();
        }
        return !listOfInstances.isEmpty() ? listOfInstances : list;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    protected void canceling() {
        super.canceling();
        this.isCanceled = true;
    }

    protected boolean traceConnectionOperation(IRfNamedElement tracedConn, ElementPath instancePathElement, boolean forceDiagramAll, TCOperation traceOperation, IProgressMonitor monitor) throws CanceledTraceException {
        if (monitor.isCanceled()) {
            throw new CanceledTraceException();
        }
        return TCEngine.INSTANCE.runFromEditor(traceOperation, tracedConn, instancePathElement, forceDiagramAll, monitor);
    }

    private List<ElementPath> getInstancesForTracedModule(IRfNamedElement tracedModule) {
        ArrayList<ElementPath> foundInstances = new ArrayList<ElementPath>();
        DHViewUtils.findInstancesForDesignElementElabMode(this.project, tracedModule, foundInstances, Integer.MAX_VALUE);
        return foundInstances;
    }

    private void cleanTrace() {
        this.project = null;
        this.tracedConn = null;
        this.tracedModule = null;
        if (this.instancesList != null) {
            this.instancesList.clear();
        }
        this.instancesList = null;
    }

    private class SelectInstanceDialog {
        private ElementListSelectionDialog dialog;

        public SelectInstanceDialog(IRfNamedElement tracedModule) {
            this.dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TCJob.this.labelProvider){

                @Override
                protected FilteredList createFilteredList(Composite parent2) {
                    FilteredList list = super.createFilteredList(parent2);
                    list.setFilterMatcher(new FilteredList.FilterMatcher(){
                        private StringMatcher localMatcher;

                        @Override
                        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                            this.localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                        }

                        @Override
                        public boolean match(Object element) {
                            return ViewsUtils.matchCamelCaseOrRegex(this.localMatcher, fFilteredList.getLabelProvider().getText(element));
                        }
                    });
                    return list;
                }
            };
            String title = "Select Instance";
            String tracedModuleName = tracedModule != null ? tracedModule.getName() : "";
            String tracedConnName = TCJob.this.tracedConn != null ? TCJob.this.tracedConn.getName() : "";
            Object[] args = new Object[]{"", ""};
            if (tracedModuleName != null) {
                args[0] = tracedModuleName;
                args[1] = tracedConnName;
            }
            String message = MessageFormat.format(TCViewMessages.fSelectInstanceViewMessage, args);
            this.dialog.setAutoResizeable(true);
            this.dialog.setTitle(title);
            this.dialog.setMessage(message);
            this.dialog.setMultipleSelection(false);
            this.dialog.setHelpAvailable(false);
        }

        private void open() {
            if (TCJob.this.instancesList == null || TCJob.this.instancesList.size() <= 1 || this.dialog == null) {
                return;
            }
            this.dialog.setElements(TCJob.this.instancesList.toArray());
            if (this.dialog.open() == 0) {
                Object result = this.dialog.getFirstResult();
                if (!(result instanceof ElementPath)) {
                    return;
                }
                final ElementPath selectedInstance = (ElementPath)result;
                WorkspaceJob job = new WorkspaceJob(TCViewMessages.fJobText){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        monitor.beginTask("", -1);
                        try {
                            if (!TCJob.this.traceConnectionOperation(((SelectInstanceDialog)SelectInstanceDialog.this).TCJob.this.tracedConn, selectedInstance, ((SelectInstanceDialog)SelectInstanceDialog.this).TCJob.this.forceDiagramAll, ((SelectInstanceDialog)SelectInstanceDialog.this).TCJob.this.traceOperation, monitor)) {
                                TCViewUtils.popDialog(1, TCViewMessages.fFailedTraceOperationMessage);
                            }
                        }
                        catch (CanceledTraceException canceledTraceException) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(false);
                job.setRule((ISchedulingRule)TCJob.this.project);
                job.schedule(0L);
            }
        }
    }
}

