/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCNodeSignalPair;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsBatch;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsView;

public class TCLabelProvider
extends DVTBaseLabelProvider {
    private final TraceConnectionsView view;

    public TCLabelProvider(TraceConnectionsView traceConnectionsView) {
        if (traceConnectionsView == null) {
            throw new IllegalArgumentException(String.valueOf(TCLabelProvider.class.getName()) + " requires a " + TraceConnectionsView.class.getName());
        }
        this.view = traceConnectionsView;
    }

    @Override
    public String getText(Object object) {
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(Object element) {
        if (!(element instanceof IDVTElementWrapper)) {
            return "";
        }
        IDVTElementWrapper w = (IDVTElementWrapper)element;
        if (w.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            this.setBoldFont(w);
        }
        if ((element = w.getRfElement()) instanceof String) {
            return (String)element;
        }
        if (element instanceof TCNodeSignalPair) {
            TCNode node = ((TCNodeSignalPair)element).node;
            IRfNamedElement signal = ((TCNodeSignalPair)element).hotSignal;
            String hierarchicalPath = TCViewUtils.pathToRoot(node, ".", new ViewsUtils.ITreePathAccessor<TCNode>(){

                @Override
                public String getNameForPath(TCNode wrapper) {
                    return TCViewUtils.getCopyHierarchyName(wrapper, false);
                }
            });
            String result = hierarchicalPath + "." + DHViewUtils.getSignalLabelText(signal);
            return TCViewUtils.shortenTextInFront(result, 55, this.view.getUpperSash());
        }
        if (!(element instanceof TCNode)) {
            return "";
        }
        TCNode node = (TCNode)element;
        TCNode startNode = this.view.getStartNode();
        TCNode startWhyNode = this.view.getStartWhyNode();
        TCNode selectedWhyNode = this.view.getSelectedWhyNode();
        if (node == startNode) {
            this.setBoldFont(w, 9);
        }
        if (node == startWhyNode) {
            this.setBoldFont(w, 9);
        }
        if (node == selectedWhyNode) {
            this.setBoldFont(w, 3);
        }
        String text = this.getTextForModelNode(node);
        if (w.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.WHYPATHNODE) != null) {
            text = "* " + text;
        }
        return text;
    }

    private String getTextForModelNode(TCNode node) {
        if (node == null) {
            return "";
        }
        switch (node.type) {
            case BLOCK: {
                String genBlockLabel = TCUtils.getELMemory(node) == null ? null : node.getLabel();
                return genBlockLabel != null && !genBlockLabel.isEmpty() ? genBlockLabel : DHViewUtils.getLabelText(node.namedElement, node.component, node.designHint, PrefConst.getDHViewPrependLibrary(), false);
            }
            case INSTANCE: {
                if (node.namedElement instanceof IRfInstanceElement && ((IRfInstanceElement)node.namedElement).isArray()) {
                    return String.valueOf(node.getLabel()) + " : " + DHViewUtils.getLabelText(node.designHint, node.component, node.designHint, PrefConst.getDHViewPrependLibrary(), false);
                }
            }
            case DESIGN: {
                return DHViewUtils.getLabelText(node.namedElement, node.component, node.designHint, PrefConst.getDHViewPrependLibrary(), false);
            }
            case RECURRENCE_DETECTED: {
                return "Recurrence Detected";
            }
        }
        return "";
    }

    @Override
    public Image getImage(Object element) {
        if (!(element instanceof IDVTElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if ((element = ((IDVTElementWrapper)element).getRfElement()) instanceof TCNodeSignalPair) {
            TCNode node = ((TCNodeSignalPair)element).node;
            Image image = TCLabelProvider.getImageForModelNode(node);
            return TCViewUtils.getEndKindDecoratedImage(image, ((TCNodeSignalPair)element).endPointKind);
        }
        if (!(element instanceof TCNode)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        TCNode node = (TCNode)element;
        Image image = TCLabelProvider.getImageForModelNode(node);
        TCViewUtilsBatch.TCEndPointKind endKind = this.view.isEndNode(node);
        return TCViewUtils.getEndKindDecoratedImage(image, endKind);
    }

    private static Image getImageForModelNode(TCNode node) {
        if (node == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        switch (node.type) {
            case RECURRENCE_DETECTED: {
                return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
            }
            case BLOCK: {
                if (node.hasHotSignals()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_WIRE);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONDITION_GRAY);
            }
            case DESIGN: {
                if (!node.hasHotSignals()) {
                    switch (DesignUtils.getDesignKind(node.namedElement)) {
                        case VLOG_MODULE: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_GRAY);
                        }
                        case VLOG_INTERFACE: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_GRAY);
                        }
                        case VLOG_PROGRAM: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROGRAM_GRAY);
                        }
                        case VLOG_PRIMITIVE: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PRIMITIVE_GRAY);
                        }
                        case VHDL_ARCHITECTURE: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARCHITECTURE_GRAY);
                        }
                        case VHDL_ENTITY: 
                        case VHDL_VUNIT: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY_GRAY);
                        }
                        case VHDL_COMPONENT: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COMPONENT_GRAY);
                        }
                        case VHDL_CONFIGURATION: {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONFIGURATION_GRAY);
                        }
                    }
                    return DVTImages.imageCache.getImage(DVTImages.NONE);
                }
            }
            case INSTANCE: {
                if (!node.hasHotSignals()) {
                    IRfDesignElement design = DesignUtils.getDesign(node.designRequest());
                    IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(design);
                    if (designKind == IRfNamedElement.ElementKind.VLOG_INTERFACE) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_GRAY);
                    }
                    if (designKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARCHITECTURE_GRAY);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_GRAY);
                }
                if (node.hasHotPorts()) {
                    boolean foundInput = false;
                    boolean foundOutput = false;
                    boolean foundInout = false;
                    for (IRfPortElement p : node.getHotPorts()) {
                        if (p.isInput()) {
                            foundInput = true;
                        } else if (p.isOutput()) {
                            foundOutput = true;
                        } else if (p.isInout()) {
                            foundInout = true;
                        } else if (p.isInterfacePort()) {
                            foundOutput = true;
                            foundInput = true;
                        }
                        if (!(foundInput && foundOutput || foundInput && foundInout) && (!foundOutput || !foundInout)) continue;
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TRACE_MULTIDIR_PORT);
                    }
                    if (foundInout) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INOUT_PORT);
                    }
                    if (foundInput) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INPUT_PORT);
                    }
                    if (foundOutput) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_OUTPUT_PORT);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_NODIR_PORT);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_WIRE);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }
}

