/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;

public abstract class TraceConnectionsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected Group optionsGroup;
    protected Group diagramsGroup;
    protected NegatedPreferenceButton assigns;
    protected NegatedPreferenceButton alwaysBlocks;
    protected NegatedPreferenceButton nonBlockingAssignments;
    protected BooleanFieldEditor linkWithTraceDiagram;

    protected TraceConnectionsPreferencesPage() {
        super(1);
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription(null);
    }

    protected Control createContents(Composite _parent) {
        this.createHeader(_parent);
        Control result = super.createContents(_parent);
        result.addPaintListener(e -> {
            this.assigns.load();
            this.alwaysBlocks.load();
            if (this.nonBlockingAssignments != null) {
                this.nonBlockingAssignments.load();
            }
            this.linkWithTraceDiagram.load();
        });
        return result;
    }

    protected abstract void createHeader(Composite var1);

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.assigns.performDefaults();
        this.alwaysBlocks.performDefaults();
        if (this.nonBlockingAssignments != null) {
            this.nonBlockingAssignments.performDefaults();
        }
    }

    protected void initialize() {
        super.initialize();
        this.assigns.load();
        this.alwaysBlocks.load();
        if (this.nonBlockingAssignments != null) {
            this.nonBlockingAssignments.load();
        }
        this.linkWithTraceDiagram.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.linkWithTraceDiagram.load();
    }

    public boolean performOk() {
        this.assigns.performOk();
        this.alwaysBlocks.performOk();
        if (this.nonBlockingAssignments != null) {
            this.nonBlockingAssignments.performOk();
        }
        return super.performOk();
    }

    public void dispose() {
        super.dispose();
        this.optionsGroup.dispose();
        this.diagramsGroup.dispose();
        this.assigns.dispose();
        this.assigns = null;
        this.alwaysBlocks.dispose();
        this.alwaysBlocks = null;
        if (this.nonBlockingAssignments != null) {
            this.nonBlockingAssignments.dispose();
        }
        this.nonBlockingAssignments = null;
    }

    public static class NegatedPreferenceButton {
        Button button;
        String preference;
        Boolean newValue;

        public NegatedPreferenceButton(String preference, String label, Group optionsGroup) {
            this.preference = preference;
            this.button = new Button((Composite)optionsGroup, 32);
            this.button.setFont(optionsGroup.getFont());
            this.button.setText(label);
            GridData buttonGridData = new GridData(1, 0x1000000, false, false);
            this.button.setLayoutData((Object)buttonGridData);
        }

        public void addDefaultSelectionListener() {
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    newValue = !button.getSelection();
                }
            });
        }

        public void addSelectionListener(SelectionListener selectionListener) {
            this.button.addSelectionListener(selectionListener);
        }

        public boolean getSelection() {
            return this.button.getSelection();
        }

        public void performOk() {
            boolean oldValue = DVTPlugin.getDefault().getPreferenceStore().getBoolean(this.preference);
            if (this.newValue != null && this.newValue != oldValue) {
                DVTPlugin.getDefault().getPreferenceStore().setValue(this.preference, this.newValue.booleanValue());
                this.newValue = null;
            }
        }

        public void performDefaults() {
            IPreferenceStore dvtPreferenceStore = DVTPlugin.getDefault().getPreferenceStore();
            dvtPreferenceStore.setToDefault(this.preference);
            this.button.setSelection(!DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean(this.preference));
        }

        public void load() {
            this.button.setSelection(!DVTPlugin.getDefault().getPreferenceStore().getBoolean(this.preference));
        }

        public void setNewValue(boolean newValue) {
            this.newValue = newValue;
        }

        public void setEnabled(boolean isEnabled) {
            this.button.setEnabled(isEnabled);
        }

        public void dispose() {
            this.button.dispose();
        }
    }
}

