/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections;

import org.eclipse.core.resources.IFile;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.utils.DVTFileUtils;

public class WhyViewElement {
    public final TCPathPoint point;
    public final TCStatement.TCStatementKind kind;
    public final String text;

    public WhyViewElement(TCPathPoint p, TCStatement.TCStatementKind kind) {
        this.point = p;
        this.kind = kind;
        this.text = this.getText();
    }

    public WhyViewElement(TCPathPoint p) {
        this.point = p;
        this.kind = null;
        this.text = this.getText();
    }

    public TCStatement getStatement() {
        return this.kind != null ? this.point.statement : null;
    }

    public String toString() {
        return this.text;
    }

    private String getText() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.getElementText(this.point.node)).append("] ");
        TCStatement statement = this.getStatement();
        if (statement == null) {
            return result.append(this.point.signal.toString()).toString();
        }
        IRfSingleLangProject rfProject = this.point.node.namedElement.getRfProject();
        if (rfProject == null) {
            return result.append(this.point.signal.toString()).toString();
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(rfProject.getProject(), statement.getFilePath());
        return result.append(DVTFileUtils.getInstance().getLineFromFile(iFile, statement.getLine()).trim().replaceAll("\\s+", " ")).toString();
    }

    private String getElementText(TCNode node) {
        if (this.point.node.namedElement instanceof IRfBlockElement && ((IRfBlockElement)this.point.node.namedElement).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            IRfBlockElement blockElement = (IRfBlockElement)this.point.node.namedElement;
            StringBuilder result = new StringBuilder();
            result.append(blockElement.getName());
            IRfDesignElement entity = ((IRfBlockElement)node.namedElement).getEntity();
            if (entity instanceof IRfDesignElement) {
                return entity.getName();
            }
        }
        return this.point.node.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.point == null ? 0 : this.point.hashCode());
        result = 31 * result + (this.kind != null ? 1231 : 1237);
        TCStatement statement = this.getStatement();
        result = 31 * result + (statement != null ? statement.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WhyViewElement other = (WhyViewElement)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.point == null ? other.point != null : !this.point.equals(other.point)) {
            return false;
        }
        TCStatement thisStatement = this.getStatement();
        TCStatement otherStatement = other.getStatement();
        return !(thisStatement == null ? otherStatement != null : !thisStatement.equals(otherStatement));
    }
}

