/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;

public class TCNode {
    protected static final int INITIAL_CAPACITY = 4;
    public TCNode parent;
    @NotNull
    public TCNodeType type;
    public IRfNamedElement namedElement;
    public String genBlockPrefixForDiagram;
    public IRfNamedElement designHint;
    public IRfNamedElement component;
    public Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap;
    private List<TCNode> hotChildren;
    private Map<IRfNamedElement, Long> hotSignals;
    private int hashCode = 0;
    private String genBlockLabel;

    private void ensureHotApplicable(IRfNamedElement signal) {
        if (!this.hotApplicable()) {
            throw new UnsupportedOperationException("HOT signals not applicable to Trace Connections node of type: " + (Object)((Object)this.type));
        }
        if (signal == null) {
            throw new IllegalStateException();
        }
    }

    public static TCNode of(IRfNamedElement namedElem, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        if (namedElem == null) {
            throw new IllegalArgumentException("The node cannot have a NULL element.");
        }
        if (namedElem == DummyElement.RECURRENCE_NODE) {
            return new TCNode(TCNodeType.RECURRENCE_DETECTED, namedElem, dummyPortMap);
        }
        if (namedElem instanceof DummyInstance && ((DummyInstance)namedElem).isGenerateInstance()) {
            return new TCNode(TCNodeType.BLOCK, ((DummyInstance)namedElem).design, dummyPortMap);
        }
        if (namedElem instanceof IRfInstanceElement) {
            return new TCNode(TCNodeType.INSTANCE, namedElem, dummyPortMap);
        }
        if (namedElem instanceof IRfBlockElement && DesignUtils.getDesignKind(namedElem) != IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            return new TCNode(TCNodeType.BLOCK, namedElem, dummyPortMap);
        }
        if (namedElem instanceof IRfDesignElement) {
            return new TCNode(TCNodeType.DESIGN, namedElem, dummyPortMap);
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    @Deprecated
    public TCNode(TCNodeType type, TCNode parent, IRfNamedElement namedElem, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap, boolean do_not_copy_port_map) {
        if (type == null) {
            throw new IllegalArgumentException("The node cannot have NULL item type.");
        }
        this.type = type;
        if (parent == null && dummyPortMap == null || parent != null && dummyPortMap != null) {
            throw new IllegalArgumentException("Exactly one of 'parent' and 'dummyPortMap' must be non-NULL in node constructor.");
        }
        this.dummyPortMap = parent != null ? parent.dummyPortMap : (do_not_copy_port_map ? dummyPortMap : new HashMap<IRfInstanceElement, Set<DummyPort>>(dummyPortMap));
        switch (type) {
            case RECURRENCE_DETECTED: {
                if (parent == null) {
                    throw new IllegalArgumentException("Tried to create node of type " + (Object)((Object)type) + " with NULL parent.");
                }
                this.parent = parent;
                this.namedElement = null;
                return;
            }
            case INSTANCE: {
                if (namedElem instanceof IRfInstanceElement) break;
                throw new IllegalArgumentException("Tried to create node with " + (Object)((Object)type) + " item type but invalid namedElement.");
            }
            case BLOCK: {
                if (namedElem instanceof IRfBlockElement) break;
                throw new IllegalArgumentException("Tried to create node with " + (Object)((Object)type) + " item type but invalid namedElement.");
            }
            case DESIGN: {
                if (namedElem instanceof IRfDesignElement) break;
                throw new IllegalArgumentException("Tried to create node with " + (Object)((Object)type) + " item type but invalid namedElement");
            }
            default: {
                throw new IllegalArgumentException("Unknown node type " + (Object)((Object)type));
            }
        }
        this.parent = parent;
        this.namedElement = namedElem;
    }

    public TCNode(TCNodeType type, IRfNamedElement namedElem, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        this.type = type;
        this.namedElement = namedElem;
        this.dummyPortMap = dummyPortMap;
    }

    public void addChild(TCNode child) {
        if (child == null) {
            return;
        }
        if (this.hotChildren == null) {
            this.hotChildren = new ArrayList<TCNode>(4);
        }
        this.hotChildren.add(child);
        child.setParent(this);
    }

    public void setParent(TCNode parent) {
        this.parent = parent;
    }

    public boolean removeChild(TCNode child) {
        if (child == null || this.hotChildren == null) {
            return false;
        }
        boolean hasChild = this.hotChildren.remove(child);
        if (this.hotChildren.isEmpty()) {
            this.hotChildren = null;
        }
        return hasChild;
    }

    @NotNull
    public List<TCNode> getChildren() {
        if (this.hotChildren == null) {
            return Collections.emptyList();
        }
        return this.hotChildren;
    }

    public boolean hasChildren() {
        if (this.hotChildren == null) {
            return false;
        }
        return !this.hotChildren.isEmpty();
    }

    public boolean hotApplicable() {
        return this.type != null && this.type != TCNodeType.RECURRENCE_DETECTED;
    }

    public boolean hotVisible() {
        if (this.hasHotSignals()) {
            return true;
        }
        IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(this.namedElement);
        if (designKind == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || designKind == IRfNamedElement.ElementKind.VHDL_CONFIGURATION) {
            return false;
        }
        if (this.type == TCNodeType.BLOCK && this.hasChildren()) {
            for (TCNode child : this.hotChildren) {
                if (!child.hotVisible()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasHotSignal(IRfNamedElement signal) {
        if (this.hotSignals == null) {
            return false;
        }
        return this.hotSignals.containsKey(signal);
    }

    public boolean addHotSignal(IRfNamedElement signal, TCOperation role) {
        long previousRolesValue;
        this.ensureHotApplicable(signal);
        if (role != TCOperation.DRIVE && role != TCOperation.LOAD) {
            return false;
        }
        if (this.hotSignals == null) {
            this.hotSignals = new LinkedHashMap<IRfNamedElement, Long>();
        }
        long roleValue = role.value();
        Long previousRoles = this.hotSignals.get(signal);
        if (previousRoles == null) {
            previousRoles = 0L;
        }
        if (((previousRolesValue = previousRoles.longValue()) & roleValue) == roleValue) {
            return false;
        }
        this.hotSignals.put(signal, previousRolesValue | roleValue);
        return true;
    }

    public boolean removeHotSignal(IRfNamedElement signal) {
        boolean removed;
        this.ensureHotApplicable(signal);
        if (this.hotSignals == null) {
            return false;
        }
        boolean bl = removed = this.hotSignals.remove(signal) != null;
        if (this.hotSignals.isEmpty()) {
            this.hotSignals = null;
        }
        return removed;
    }

    public boolean removeRole(IRfNamedElement signal, TCOperation role) {
        boolean hadRole;
        this.ensureHotApplicable(signal);
        if (this.hotSignals == null) {
            return false;
        }
        Long previousRoles = this.hotSignals.get(signal);
        if (previousRoles == null) {
            return false;
        }
        long roleValue = role.value();
        long previousRolesValue = previousRoles;
        boolean bl = hadRole = (previousRolesValue & roleValue) == roleValue;
        if (hadRole) {
            previousRolesValue &= roleValue ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (previousRolesValue == 0L) {
            this.removeHotSignal(signal);
        }
        return hadRole;
    }

    public boolean hasHotPorts() {
        return !this.getHotPorts().isEmpty();
    }

    public boolean hasHotFields() {
        return !this.getHotFields().isEmpty();
    }

    public boolean hasHotSignals() {
        return this.hotSignals != null;
    }

    @NotNull
    public Set<IRfPortElement> getHotPorts() {
        if (this.hotSignals == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IRfPortElement> result = new LinkedHashSet<IRfPortElement>(this.hotSignals.size());
        for (IRfNamedElement element : this.hotSignals.keySet()) {
            if (element instanceof HierarchicalElement) {
                element = ((HierarchicalElement)element).getFirstSegment();
            }
            if (!(element instanceof IRfPortElement)) continue;
            result.add((IRfPortElement)element);
        }
        return result;
    }

    @NotNull
    public Set<IRfNamedElement> getHotFields() {
        if (this.hotSignals == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>(this.hotSignals.size());
        for (IRfNamedElement element : this.hotSignals.keySet()) {
            if (element instanceof HierarchicalElement) {
                element = ((HierarchicalElement)element).getFirstSegment();
            }
            if (element instanceof IRfPortElement) continue;
            result.add(element);
        }
        return result;
    }

    @NotNull
    public List<IRfNamedElement> getHotSignals() {
        if (this.hotSignals == null || this.hotSignals.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<IRfNamedElement>(this.hotSignals.keySet());
    }

    @NotNull
    public Map<IRfNamedElement, Long> getHotSignalsMap() {
        if (this.hotSignals == null) {
            return Collections.emptyMap();
        }
        return this.hotSignals;
    }

    public void clearHotData() {
        this.hotSignals = null;
    }

    public void setAdditionalInfo(String info) {
    }

    public void setDesignHint(IRfNamedElement designHint) {
        this.designHint = designHint;
    }

    public void setComponent(IRfNamedElement component) {
        this.component = component;
    }

    public HierarchicalElement isInterfaceShell() {
        if (this.hotSignals == null) {
            return null;
        }
        if (this.hotSignals.size() > 1) {
            return null;
        }
        for (IRfNamedElement signal : this.hotSignals.keySet()) {
            if (!(signal instanceof HierarchicalElement)) continue;
            return (HierarchicalElement)signal;
        }
        return null;
    }

    public void deepClean() {
        this.type = null;
        if (this.hotChildren != null) {
            for (TCNode child : this.hotChildren) {
                child.deepClean();
            }
        }
        this.hotChildren = null;
        this.parent = null;
        this.namedElement = null;
        this.designHint = null;
        this.hotSignals = null;
        this.dummyPortMap = null;
    }

    public String toString() {
        return this.getLabel();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 1;
        result = 31 * result + (this.designHint == null ? 0 : this.designHint.hashCode());
        result = 31 * result + (this.namedElement == null ? 0 : this.namedElement.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        this.hashCode = result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCNode other = (TCNode)obj;
        if (this.designHint == null ? other.designHint != null : this.designHint != other.designHint) {
            return false;
        }
        if (this.namedElement == null ? other.namedElement != null : this.namedElement != other.namedElement) {
            return false;
        }
        if (this.parent == null ? other.parent != null : this.parent != other.parent) {
            return false;
        }
        return this.type == other.type;
    }

    @NotNull
    public List<TCNode> getDirectDescendantBlocks() {
        if (!this.hasChildren()) {
            return Collections.emptyList();
        }
        ArrayList<TCNode> result = new ArrayList<TCNode>();
        for (TCNode child : this.getChildren()) {
            if (child.type != TCNodeType.BLOCK) continue;
            result.add(child);
        }
        return result;
    }

    @NotNull
    public List<TCNode> getDirectDescendantsSkippingBlocks() {
        if (!this.hasChildren()) {
            return Collections.emptyList();
        }
        ArrayList<TCNode> result = new ArrayList<TCNode>();
        ArrayDeque<TCNode> queue = new ArrayDeque<TCNode>();
        queue.addAll(this.hotChildren);
        block5: while (!queue.isEmpty()) {
            TCNode node = (TCNode)queue.remove();
            switch (node.type) {
                case INSTANCE: {
                    result.add(node);
                    break;
                }
                case BLOCK: {
                    for (TCNode child : node.getChildren()) {
                        queue.add(child);
                    }
                    continue block5;
                }
                case RECURRENCE_DETECTED: {
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
        }
        return result;
    }

    @NotNull
    public List<TCNode> getDirectDescendantInstances() {
        if (!this.hasChildren()) {
            return Collections.emptyList();
        }
        ArrayList<TCNode> result = new ArrayList<TCNode>();
        for (TCNode child : this.getChildren()) {
            if (child.type != TCNodeType.INSTANCE) continue;
            result.add(child);
        }
        return result;
    }

    public TCNode getClosestAncestorInstanceSkippingBlocks() {
        if (this.type == TCNodeType.INSTANCE) {
            return this;
        }
        TCNode parent = this.parent;
        while (parent != null) {
            switch (parent.type) {
                case BLOCK: {
                    break;
                }
                case INSTANCE: {
                    return parent;
                }
                default: {
                    return null;
                }
            }
            parent = parent.parent;
        }
        return null;
    }

    public TCNode getFarthestHotAncestor() {
        TCNode result = this;
        TCNode parent = this.parent;
        while (parent != null) {
            if (!parent.hotVisible()) break;
            result = parent;
            parent = parent.parent;
        }
        return result;
    }

    public DesignUtils.DesignRequest designRequest() {
        return DesignUtils.DesignRequest.of(this.namedElement, this.designHint);
    }

    public IRfInstanceElement getInstance() {
        return this.type == TCNodeType.INSTANCE ? (IRfInstanceElement)this.namedElement : null;
    }

    public ElementPath getElementPath() {
        ArrayList<TCNode> parents = new ArrayList<TCNode>();
        TCNode tmp = this;
        while (tmp != null) {
            parents.add(tmp);
            tmp = tmp.parent;
        }
        ElementPath instancePath = ElementPath.EMPTY_PATH;
        int i = parents.size() - 1;
        while (i >= 0) {
            instancePath = ElementPath.join(instancePath, ((TCNode)parents.get(i)).getLabel());
            --i;
        }
        return instancePath;
    }

    public ELInstance getELInstance() {
        IRfSingleLangProject project = this.namedElement.getRfProject();
        if (project == null) {
            return null;
        }
        ELManager manager = project.getELManager();
        if (manager == null) {
            return null;
        }
        return manager.getMemory().instanceFor(this.getElementPath());
    }

    public String getLabel() {
        if (this.genBlockLabel != null) {
            return this.genBlockLabel;
        }
        if (this.namedElement != null) {
            return this.namedElement.getName();
        }
        return "";
    }

    public void setLabel(String genBlockLabel) {
        this.genBlockLabel = genBlockLabel;
    }

    public void setGenblockPrefixPrefixForDiagram(String prefix) {
        this.genBlockPrefixForDiagram = prefix;
    }

    public static enum TCNodeType {
        INSTANCE,
        DESIGN,
        BLOCK,
        RECURRENCE_DETECTED;

    }
}

