/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.model;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;

public class TCPathChain {
    private Map<TCPathPoint, TCPathLink> links = new HashMap<TCPathPoint, TCPathLink>();

    public void clear() {
        this.links.clear();
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public int size() {
        return this.links.size();
    }

    public void addLink(TCPathPoint effect, TCPathPoint cause) {
        if (effect == null) {
            return;
        }
        TCPathPoint potentialCause = cause;
        if (!this.links.containsKey(effect)) {
            if (cause != null) {
                potentialCause = this.getEffectFromEffect(cause);
            }
            TCPathLink pair = new TCPathLink(potentialCause, effect);
            this.links.put(effect, pair);
        }
    }

    public TCPathPoint getCauseFromEffect(TCPathPoint effect) {
        TCPathLink pair = this.links.get(effect);
        if (pair != null) {
            return pair.getCause();
        }
        return null;
    }

    @NotNull
    public TCPathPoint getEffectFromEffect(TCPathPoint effect) {
        TCPathLink pair = this.links.get(effect);
        if (pair != null) {
            return pair.getEffect();
        }
        return effect;
    }

    public boolean hasEffect(TCPathPoint effect) {
        return this.links.containsKey(effect);
    }

    public void addLinks(TCPathChain chain) {
        this.links.putAll(chain.links);
    }

    public static class TCPathLink {
        public TCPathPoint cause;
        public TCPathPoint effect;

        public TCPathLink(TCPathPoint cause, TCPathPoint effect) {
            this.cause = cause;
            this.effect = effect;
        }

        public TCPathPoint getEffect() {
            return this.effect;
        }

        public TCPathPoint getCause() {
            return this.cause;
        }

        public String toString() {
            return this.cause.toString();
        }
    }
}

