/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.model;

import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;

public class TCPathPoint {
    public TCNode node;
    public IRfNamedElement signal;
    public TCStatement statement;
    private DesignUtils.SupplierInDesign<LogicForm> enclosingLogicFormSupplier;

    public static final TCPathPoint of(TCNode node, IRfNamedElement hotSignal, DesignUtils.SupplierInDesign<LogicForm> logicSupplier, TCStatement statement) {
        TCPathPoint point = new TCPathPoint(node, hotSignal);
        point.enclosingLogicFormSupplier = logicSupplier;
        point.statement = statement;
        return point;
    }

    public static final TCPathPoint of(TCNode node, IRfNamedElement hotSignal, TCStatement statement) {
        return TCPathPoint.of(node, hotSignal, null, statement);
    }

    private TCPathPoint(TCNode node, IRfNamedElement hotSignal) {
        this.node = node;
        this.signal = hotSignal;
    }

    public LogicForm getEnclosingLogicForm(IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance) {
        return this.enclosingLogicFormSupplier != null ? this.enclosingLogicFormSupplier.get(enclosingDesignOrInstance, closestAncestorInstance) : null;
    }

    public boolean isPortConnection() {
        return this.statement != null && TCStatement.TCStatementKind.PORT_CONNECTION == this.statement.kind;
    }

    public boolean isPortExpression() {
        return this.statement != null && TCStatement.TCStatementKind.PORT_EXPRESSION == this.statement.kind;
    }

    public boolean isLogic() {
        TCStatement.TCStatementKind kind;
        TCStatement.TCStatementKind tCStatementKind = kind = this.statement != null ? this.statement.kind : null;
        return TCStatement.TCStatementKind.ASSIGN == kind || TCStatement.TCStatementKind.ALIAS == kind || TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK == kind || TCStatement.TCStatementKind.SEQUENTIAL_ALWAYS_BLOCK == kind;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.signal == null ? 0 : this.signal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TCPathPoint)) {
            return false;
        }
        TCPathPoint other = (TCPathPoint)obj;
        if (this.node != other.node) {
            return false;
        }
        if (this.signal instanceof HierarchicalElement && other.signal instanceof HierarchicalElement) {
            return this.signal.equals(other.signal);
        }
        return this.signal == other.signal;
    }

    public String toString() {
        return (this.node != null ? this.node.toString() : "") + " . " + (this.signal != null ? this.signal.toString() : "");
    }
}

