/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.model;

import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;

public class TCStatement {
    public final TCStatementKind kind;
    public final GoToInfo goToInfo;
    public final IHidOperator cacheImplicitPortConnection;

    public static TCStatement of(TCStatementKind kind, GoToInfo goToInfo) {
        return TCStatement.of(kind, goToInfo, null);
    }

    public static TCStatement of(TCStatementKind kind, GoToInfo goToInfo, IHidOperator cachePortConnection) {
        if (kind == null || goToInfo == null) {
            return null;
        }
        return new TCStatement(kind, goToInfo, cachePortConnection);
    }

    public static TCStatement of(TCStatementKind kind) {
        return new TCStatement(kind, null);
    }

    private TCStatement(TCStatementKind kind, GoToInfo goToInfo) {
        this(kind, goToInfo, null);
    }

    private TCStatement(TCStatementKind kind, GoToInfo goToInfo, IHidOperator cachePortConnection) {
        this.kind = kind;
        this.goToInfo = goToInfo;
        this.cacheImplicitPortConnection = cachePortConnection;
    }

    public String getFilePath() {
        if (this.goToInfo == null) {
            return "[dummy]";
        }
        return this.goToInfo.filePath;
    }

    public int getOffset() {
        if (this.goToInfo == null) {
            return -1;
        }
        return this.goToInfo.offset;
    }

    public int getVirtualOffset() {
        if (this.goToInfo == null) {
            return -1;
        }
        return this.goToInfo.virtualOffset;
    }

    public int getLine() {
        if (this.goToInfo == null) {
            return -1;
        }
        return this.goToInfo.line;
    }

    public String getText() {
        if (this.goToInfo == null) {
            return "";
        }
        return this.goToInfo.text;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + this.getOffset();
        result = 31 * result + this.getVirtualOffset();
        result = 31 * result + this.getLine();
        result = 31 * result + (this.getFilePath() == null ? 0 : this.getFilePath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCStatement other = (TCStatement)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getVirtualOffset() != other.getVirtualOffset()) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        return this.getFilePath().equals(other.getFilePath());
    }

    public String toString() {
        return "(" + this.getOffset() + ", " + this.getVirtualOffset() + ", " + this.getLine() + ", " + this.getFilePath() + ", " + (Object)((Object)this.kind) + ")";
    }

    public static enum TCStatementKind {
        PORT_CONNECTION,
        ASSIGN,
        ALIAS,
        PORT_EXPRESSION,
        CONCURRENT_ALWAYS_BLOCK,
        SEQUENTIAL_ALWAYS_BLOCK,
        WRITER,
        READER;

    }
}

