/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.utils.LRUCache;

public enum TCCache {
    INSTANCE;

    private static final int CACHE_LIMIT = 5000;
    private int cacheLimit = 5000;
    private Map<TCNode, Map<IRfPortElement, Set<TCConnSignal>>> portConnections;
    private Map<IRfNamedElement, Map<IRfNamedElement, List<IHidOperator>>> concurrentBlockLogic;
    private Map<IRfNamedElement, Map<IRfNamedElement, LogicForm>> concurrentBlockLogicForm;
    private Map<IRfNamedElement, List<IHidOperator>> assignAndPortExpressionLogic;
    private HidOperatorQualifier[] assignAndPortExpressionQualifiers;
    private Map<Object, TCLogic> elemLogic;
    private Map<IHidOperator, LogicForm> elemLogicForm;
    private Map<IRfInstanceElement, IHidOperator> predefinedGateOperators;

    public void addPortConnections(TCNode instance, Map<IRfPortElement, Set<TCConnSignal>> pcs) {
        if (instance == null) {
            return;
        }
        if (this.portConnections == null) {
            this.portConnections = new LRUCache<TCNode, Map<IRfPortElement, Set<TCConnSignal>>>(this.cacheLimit);
        }
        this.portConnections.put(instance, pcs);
    }

    public void addConcurrentBlockLogic(IRfNamedElement searchElemType, Map<IRfNamedElement, List<IHidOperator>> cbLogic) {
        if (searchElemType == null) {
            return;
        }
        if (this.concurrentBlockLogic == null) {
            this.concurrentBlockLogic = new LRUCache<IRfNamedElement, Map<IRfNamedElement, List<IHidOperator>>>(this.cacheLimit);
        }
        this.concurrentBlockLogic.put(searchElemType, cbLogic);
    }

    public void addConcurrentBlocksLogicForm(IRfNamedElement searchElemType, Map<IRfNamedElement, LogicForm> cbLogic) {
        if (searchElemType == null) {
            return;
        }
        if (this.concurrentBlockLogicForm == null) {
            this.concurrentBlockLogicForm = new LRUCache<IRfNamedElement, Map<IRfNamedElement, LogicForm>>(this.cacheLimit);
        }
        this.concurrentBlockLogicForm.put(searchElemType, cbLogic);
    }

    public void addAssignAndPortExpressionLogic(IRfNamedElement searchElemType, List<IHidOperator> apLogic) {
        if (searchElemType == null) {
            return;
        }
        if (this.assignAndPortExpressionLogic == null) {
            this.assignAndPortExpressionLogic = new LRUCache<IRfNamedElement, List<IHidOperator>>(this.cacheLimit);
        }
        this.assignAndPortExpressionLogic.put(searchElemType, apLogic);
    }

    public void addElemLogic(Object elem, TCLogic loadDrivers) {
        if (elem == null) {
            return;
        }
        if (this.elemLogic == null) {
            this.elemLogic = new LRUCache<Object, TCLogic>(this.cacheLimit);
        }
        this.elemLogic.put(elem, loadDrivers);
    }

    public void addElemLogicForm(IHidOperator elem, LogicForm logicForm) {
        if (elem == null) {
            return;
        }
        if (this.elemLogicForm == null) {
            this.elemLogicForm = new LRUCache<IHidOperator, LogicForm>(this.cacheLimit);
        }
        this.elemLogicForm.put(elem, logicForm);
    }

    public void addPredefinedGateOperator(IRfInstanceElement gateInstance, IHidOperator operator) {
        if (gateInstance == null) {
            return;
        }
        if (this.predefinedGateOperators == null) {
            this.predefinedGateOperators = new LRUCache<IRfInstanceElement, IHidOperator>(this.cacheLimit);
        }
        this.predefinedGateOperators.put(gateInstance, operator);
    }

    public void setAssignAndPortExpressionQualifiers(HidOperatorQualifier[] qualifiers) {
        if (qualifiers == null) {
            return;
        }
        this.assignAndPortExpressionQualifiers = qualifiers;
    }

    public Map<IRfPortElement, Set<TCConnSignal>> getPortConnections(TCNode instance) {
        if (this.portConnections == null) {
            return null;
        }
        return this.portConnections.get(instance);
    }

    public Map<IRfNamedElement, List<IHidOperator>> getConcurrentBlockLogic(IRfNamedElement searchElem) {
        if (this.concurrentBlockLogic == null) {
            return null;
        }
        return this.concurrentBlockLogic.get(searchElem);
    }

    public Map<IRfNamedElement, LogicForm> getConcurrentBlocksLogicForm(IRfNamedElement searchElem) {
        if (this.concurrentBlockLogicForm == null) {
            return null;
        }
        return this.concurrentBlockLogicForm.get(searchElem);
    }

    public List<IHidOperator> getAssignAndPortExpressionLogic(IRfNamedElement searchElem) {
        if (this.assignAndPortExpressionLogic == null) {
            return null;
        }
        return this.assignAndPortExpressionLogic.get(searchElem);
    }

    public TCLogic getElemLogic(Object elem) {
        if (this.elemLogic == null) {
            return null;
        }
        return this.elemLogic.get(elem);
    }

    public LogicForm getElemLogicForm(Object elem) {
        if (this.elemLogicForm == null) {
            return null;
        }
        return this.elemLogicForm.get(elem);
    }

    public IHidOperator getPredefinedGateOperator(IRfInstanceElement predefinedGateInstance) {
        if (this.predefinedGateOperators == null) {
            return null;
        }
        return this.predefinedGateOperators.get(predefinedGateInstance);
    }

    public HidOperatorQualifier[] getAssignAndPortExpressionQualifiers() {
        return this.assignAndPortExpressionQualifiers;
    }

    public void clean() {
        this.portConnections = null;
        this.concurrentBlockLogic = null;
        this.concurrentBlockLogicForm = null;
        this.assignAndPortExpressionLogic = null;
        this.elemLogic = null;
        this.elemLogicForm = null;
        this.predefinedGateOperators = null;
        this.assignAndPortExpressionQualifiers = null;
    }

    public void init(int cacheLimit) {
        if (cacheLimit <= 0) {
            throw new IllegalArgumentException("Illegal cache limit: " + cacheLimit);
        }
        this.cacheLimit = cacheLimit;
        this.clean();
    }
}

