/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.logic.form.LFConverter;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LFOperatorConverter;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.actions.CanceledTraceException;
import ro.amiq.dvt.ui.trace.connections.TCViewMessages;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.model.TCPathRedundance;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.trace.connections.utils.TCCache;
import ro.amiq.dvt.ui.trace.connections.utils.TCConfiguration;
import ro.amiq.dvt.ui.trace.connections.utils.TCInterfaceInterest;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.TCWrapperAdapter;
import ro.amiq.dvt.ui.views.designhierarchy.IDHNodeFactory;

public final class TCUtils {
    private static final EnumSet<HidFlatteningOption> READER_WRITTER_HID_FLATTENING = EnumSet.noneOf(HidFlatteningOption.class);

    private TCUtils() {
    }

    private static void traceSignalRecursive(TCPathPoint hot, TCBundle bundle) throws CanceledTraceException {
        boolean isEnd = true;
        isEnd &= TCUtils.traceSignalOutside(hot, bundle);
        if (isEnd &= TCUtils.traceSignalInside(hot, bundle)) {
            bundle.ends.put(hot.node, hot);
        }
    }

    private static void traceSignalIterative(TCBundle bundle) throws CanceledTraceException {
        while (!bundle.boundary.isEmpty()) {
            boolean isEnd = true;
            TCPathPoint hot = bundle.boundary.poll();
            isEnd &= TCUtils.traceSignalOutside(hot, bundle);
            if (!(isEnd &= TCUtils.traceSignalInside(hot, bundle))) continue;
            bundle.ends.put(hot.node, hot);
        }
    }

    private static boolean traceSignalOutside(TCPathPoint hot, TCBundle bundle) throws CanceledTraceException {
        boolean isEnd = true;
        TCNode ancestor = hot.node.parent;
        if (ancestor == null) {
            return isEnd;
        }
        isEnd &= TCUtils.traceSignalInPortConnectionsOutside(hot, bundle, ancestor, ancestor.getClosestAncestorInstanceSkippingBlocks());
        return isEnd &= TCUtils.traceSignalOfCompositeOutside(hot, bundle, ancestor);
    }

    private static boolean traceSignalOfCompositeOutside(TCPathPoint hot, TCBundle bundle, TCNode ancestor) throws CanceledTraceException {
        boolean isEnd = true;
        TCUtils.checkCanceled(bundle);
        if (TCUtils.resolveInterfaceInterest(hot.node.namedElement) != TCInterfaceInterest.INTERFACE_AS_INSTANCE) {
            return isEnd;
        }
        TCInterfaceInterest hotSignalInterest = TCUtils.resolveInterfaceInterest(hot.signal);
        if (hotSignalInterest != TCInterfaceInterest.PORT_OF_INTERFACE && hotSignalInterest != TCInterfaceInterest.FIELD_OF_INTERFACE) {
            return isEnd;
        }
        IRfNamedElement interfaceSignal = HierarchicalElement.of(hot.node.namedElement, hot.signal);
        if (interfaceSignal == null) {
            return isEnd;
        }
        TCPathPoint effect = TCPathPoint.of(ancestor, interfaceSignal, null);
        TCUtils.chainHotSignal(effect, hot, bundle);
        isEnd = false;
        return isEnd;
    }

    private static boolean traceSignalInside(TCPathPoint hot, TCBundle bundle) throws CanceledTraceException {
        boolean isEnd = true;
        return isEnd &= TCUtils.traceSignalInPortConnectionsAndLogic(hot, bundle, hot.node, hot.node.getClosestAncestorInstanceSkippingBlocks());
    }

    private static boolean traceSignalInPortConnectionsAndLogic(TCPathPoint hot, TCBundle bundle, TCNode searchNode, TCNode closestAncestorInstanceNode) throws CanceledTraceException {
        boolean isEnd = true;
        TCUtils.checkCanceled(bundle);
        for (TCNode blockNode : searchNode.getDirectDescendantBlocks()) {
            isEnd &= TCUtils.traceSignalInPortConnectionsAndLogic(hot, bundle, blockNode, closestAncestorInstanceNode);
        }
        isEnd &= TCUtils.traceSignalInPortConnectionsInside(hot, bundle, searchNode, closestAncestorInstanceNode);
        IRfDesignElement searchElemType = DesignUtils.getDesign(searchNode.designRequest());
        if (searchElemType == null) {
            return isEnd;
        }
        isEnd &= TCUtils.traceSignalInConcurrentBlocks(hot, bundle, searchNode, closestAncestorInstanceNode, searchElemType);
        List<IHidOperator> assignsAndPortExpressionsLogic = TCUtils.getAssignAndPortExpressionOperators(searchElemType, bundle);
        TCUtils.collectPredefinedGateInstanceOperator(assignsAndPortExpressionsLogic, searchElemType, hot.node, bundle);
        if (assignsAndPortExpressionsLogic.isEmpty()) {
            return isEnd;
        }
        searchElemType = searchElemType instanceof IRfPredefinedGate ? searchNode.namedElement : searchElemType;
        String filePath = TCUtils.getFilePath(searchElemType);
        LanguageKind languageKind = searchElemType.getLanguageKind();
        LFOperatorConverter converter = TCUtils.newLFOperatorConverter(filePath, languageKind, bundle);
        for (IHidOperator operator : assignsAndPortExpressionsLogic) {
            TCUtils.checkCanceled(bundle);
            isEnd &= TCUtils.traceSignalInAssigns(hot, bundle, operator, searchNode, closestAncestorInstanceNode, searchElemType, filePath, languageKind, converter);
            isEnd &= TCUtils.traceSignalInPortExpressions(hot, bundle, operator, searchNode, closestAncestorInstanceNode, searchElemType, filePath, languageKind);
        }
        return isEnd;
    }

    private static LFOperatorConverter newLFOperatorConverter(String filePath, LanguageKind languageKind, TCBundle bundle) {
        return new LFOperatorConverter(bundle.converterOptions, bundle.assignHidFlattening, GoToInfo.sourceSupplierFor(filePath, languageKind), bundle.monitor);
    }

    private static void collectPredefinedGateInstanceOperator(List<IHidOperator> assignsAndPortExpressionsLogic, IRfNamedElement searchElementType, TCNode nodeInstance, TCBundle bundle) {
        if (!(searchElementType instanceof IRfPredefinedGate) || nodeInstance == null || !(nodeInstance.namedElement instanceof IRfInstanceElement) || assignsAndPortExpressionsLogic == null) {
            return;
        }
        IHidOperator operator = TCCache.INSTANCE.getPredefinedGateOperator((IRfInstanceElement)nodeInstance.namedElement);
        if (operator == null) {
            operator = TCUtils.makeOperatorForPredefinedGateInstance((IRfPredefinedGate)searchElementType, nodeInstance, bundle);
            TCCache.INSTANCE.addPredefinedGateOperator((IRfInstanceElement)nodeInstance.namedElement, operator);
        }
        assignsAndPortExpressionsLogic.add(operator);
    }

    private static boolean traceSignalInPortConnectionsOutside(TCPathPoint hot, TCBundle bundle, TCNode ancestor, TCNode closestAncestorInstanceNode) throws CanceledTraceException {
        boolean isEnd = true;
        if (ancestor == null) {
            return isEnd;
        }
        TCUtils.checkCanceled(bundle);
        IRfPortElement hotPort = TCUtils.getConnectionPort(hot.signal);
        if (hotPort == null) {
            return isEnd;
        }
        boolean hotPortIncludesDirection = TCUtils.internalIncludesDirection(bundle.traceOperation, TCUtils.includesInputDirection(hotPort), TCUtils.includesOutputDirection(hotPort));
        TCInterfaceInterest hotPortInterest = TCUtils.resolveInterfaceInterest(hotPort);
        LFOperatorConverter converter = TCUtils.newLFOperatorConverter(TCUtils.getFilePath(hot.node.namedElement), hot.node.namedElement.getLanguageKind(), bundle);
        TCUtils.debug("Outside of", hot.node, hot.signal, false, new Object[0]);
        if (hotPortIncludesDirection || hotPortInterest == TCInterfaceInterest.INTERFACE_AS_PORT || hotPortInterest == TCInterfaceInterest.MODPORT_AS_PORT) {
            Set<TCConnSignal> conns = TCUtils.mapInstancePortConnections(hot.node, converter, bundle.portConnectionHidFlattening).get(hotPort);
            if (conns == null) {
                return isEnd;
            }
            ArrayList<LFProgram> allAssociations = new ArrayList<LFProgram>(conns.size());
            TCStatement statement = null;
            for (TCConnSignal conn : conns) {
                TCUtils.checkCanceled(bundle);
                LogicForm logicForm = conn.getLogicForm(ancestor.designHint, closestAncestorInstanceNode != null ? closestAncestorInstanceNode.getELInstance() : null);
                if (logicForm != null) {
                    allAssociations.addAll(logicForm.content);
                }
                statement = conn.statement;
            }
            LogicForm logicForm = LogicForm.normOf(allAssociations);
            Set<IRfNamedElement> granted = TCUtils.grantContinueOutside(hot, logicForm, ancestor, closestAncestorInstanceNode, bundle);
            if (granted == null) {
                return isEnd;
            }
            if (granted.isEmpty()) {
                isEnd = false;
            }
            for (IRfNamedElement candidate : granted) {
                TCPathPoint causeFromEffect;
                TCUtils.checkCanceled(bundle);
                TCNode candidateEnclosingNode = TCUtils.getEnclosingNode(candidate.getEnclosingScope(), ancestor);
                if (candidateEnclosingNode == null) continue;
                TCPathPoint effect = TCPathPoint.of(candidateEnclosingNode, candidate, DesignUtils.getLogicSupplier2(conns, hotPort.isOutput()), statement);
                if (!effect.equals(causeFromEffect = bundle.causedBy.getCauseFromEffect(hot))) {
                    isEnd = false;
                }
                TCUtils.chainHotSignal(effect, hot, bundle);
            }
        }
        return isEnd;
    }

    private static boolean traceSignalInPortConnectionsInside(TCPathPoint hot, TCBundle bundle, TCNode searchNode, TCNode closestAncestorInstanceNode) throws CanceledTraceException {
        boolean isEnd = true;
        TCUtils.checkCanceled(bundle);
        TCUtils.debug("Inside of", hot.node, hot.signal, false, new Object[0]);
        boolean ignoreDirection = bundle.configurations.contains((Object)TCConfiguration.IGNORE_DIRECTION);
        for (TCNode descendent : searchNode.getDirectDescendantInstances()) {
            TCUtils.checkCanceled(bundle);
            if (hot.signal instanceof HierarchicalElement && ((HierarchicalElement)hot.signal).getFirstSegment() == descendent.namedElement) continue;
            LFOperatorConverter converter = TCUtils.newLFOperatorConverter(TCUtils.getFilePath(descendent.namedElement), descendent.namedElement.getLanguageKind(), bundle);
            for (Map.Entry<IRfPortElement, Set<TCConnSignal>> entryPC : TCUtils.mapInstancePortConnections(descendent, converter, bundle.portConnectionHidFlattening).entrySet()) {
                TCUtils.checkCanceled(bundle);
                IRfPortElement portPC = entryPC.getKey();
                boolean portIncludesDirection = TCUtils.internalIncludesDirection(bundle.traceOperation, TCUtils.includesOutputDirection(portPC), TCUtils.includesInputDirection(portPC));
                TCInterfaceInterest portPCInterest = TCUtils.resolveInterfaceInterest(portPC);
                if (!ignoreDirection && !portIncludesDirection && portPCInterest != TCInterfaceInterest.INTERFACE_AS_PORT && portPCInterest != TCInterfaceInterest.MODPORT_AS_PORT) continue;
                Set<TCConnSignal> conns = entryPC.getValue();
                block2: for (TCConnSignal conn : conns) {
                    TCUtils.checkCanceled(bundle);
                    LogicForm logicForm = conn.getLogicForm(searchNode.designHint, null);
                    Set<IRfNamedElement> granted = TCUtils.grantContinueInside(hot, logicForm, searchNode, closestAncestorInstanceNode, bundle);
                    if (granted == null) continue;
                    for (IRfNamedElement candidate : granted) {
                        TCPathPoint causeFromEffect;
                        TCPathPoint effect = TCPathPoint.of(descendent, candidate, DesignUtils.getLogicSupplier2(conns, portPC.isOutput()), conn.statement);
                        if (!effect.equals(causeFromEffect = bundle.causedBy.getCauseFromEffect(hot))) {
                            isEnd = false;
                        }
                        if (TCUtils.chainHotSignal(effect, hot, bundle)) continue block2;
                    }
                }
            }
        }
        return isEnd;
    }

    private static boolean traceSignalInAssigns(TCPathPoint hot, TCBundle bundle, final IHidOperator assign, TCNode searchNode, TCNode closestAncestorInstanceNode, IRfNamedElement searchElemType, final String filePath, final LanguageKind languageKind, LFOperatorConverter converter) throws CanceledTraceException {
        HidOperatorQualifier assignQualifier;
        boolean isEnd = true;
        if (hot == null || bundle == null || assign == null || searchElemType == null || filePath == null) {
            return isEnd;
        }
        TCUtils.checkCanceled(bundle);
        HidOperatorQualifier hidOperatorQualifier = assign.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) ? HidOperatorQualifier.IS_DECLARATION_ASSIGN : (assign.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_EXPRESSION) ? HidOperatorQualifier.IS_DECLARATION_EXPRESSION : (assign.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN) ? HidOperatorQualifier.IS_CONTINUOUS_ASSIGN : (assign.hasOccurrence(HidOperatorQualifier.IS_SELECT_CONTINUOUS_ASSIGN) ? HidOperatorQualifier.IS_SELECT_CONTINUOUS_ASSIGN : (assignQualifier = assign.hasOccurrence(HidOperatorQualifier.IS_ALIAS) ? HidOperatorQualifier.IS_ALIAS : null))));
        if (assignQualifier == null) {
            return isEnd;
        }
        LogicForm logicForm = TCCache.INSTANCE.getElemLogicForm(assign);
        if (logicForm == null) {
            logicForm = LFConverter.INSTANCE.convertOperatorAndNormalize(converter, assign, searchElemType);
            TCCache.INSTANCE.addElemLogicForm(assign, logicForm);
        }
        TCUtils.debug("Assign", hot.node, hot.signal, false, " in \"", assign, "\"");
        Supplier<TCStatement> statementSupplier = new Supplier<TCStatement>(){

            @Override
            public TCStatement get() {
                HidOperatorOccurrence occurrence = assign.getOccurrence();
                GoToInfo goToInfo = GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), "", languageKind);
                TCStatement statement = TCStatement.of(TCStatement.TCStatementKind.ASSIGN, goToInfo);
                return statement;
            }
        };
        return isEnd &= TCUtils.internalTraceSignalInAssigns(hot, logicForm, searchNode, closestAncestorInstanceNode, statementSupplier, bundle, false);
    }

    private static boolean internalTraceSignalInAssigns(TCPathPoint hot, LogicForm logicForm, TCNode searchNode, TCNode closestAncestorInstanceNode, Supplier<TCStatement> statementSupplier, TCBundle bundle, boolean isInBlock) throws CanceledTraceException {
        boolean isEnd = true;
        Set<IRfNamedElement> granted = TCUtils.grantContinue(hot, bundle, logicForm, searchNode, closestAncestorInstanceNode, isInBlock);
        if (granted == null) {
            return isEnd;
        }
        if (TCUtils.addWriterOrReader(searchNode, statementSupplier, bundle)) {
            return isEnd;
        }
        for (IRfNamedElement candidate : granted) {
            TCUtils.checkCanceled(bundle);
            TCNode candidateEnclosingNode = TCUtils.getEnclosingNode(candidate.getEnclosingScope(), searchNode);
            if (candidateEnclosingNode == null) continue;
            TCStatement statement = statementSupplier.get();
            TCPathPoint effect = TCPathPoint.of(candidateEnclosingNode, candidate, DesignUtils.getLogicSupplier2(logicForm), statement);
            if (hot.equals(effect)) continue;
            TCUtils.chainHotSignal(effect, hot, bundle);
            isEnd = false;
        }
        if (granted.isEmpty()) {
            isEnd = false;
        }
        return isEnd;
    }

    private static boolean traceSignalInPortExpressions(TCPathPoint hot, TCBundle bundle, IHidOperator portExpression, TCNode searchNode, TCNode closestAncestorInstanceNode, IRfNamedElement searchElemType, String filePath, LanguageKind languageKind) throws CanceledTraceException {
        boolean isEnd = true;
        if (hot == null || bundle == null || portExpression == null || searchElemType == null || filePath == null) {
            return isEnd;
        }
        TCUtils.checkCanceled(bundle);
        if (!portExpression.hasOccurrence(HidOperatorQualifier.IS_PORT_EXPRESSION)) {
            return isEnd;
        }
        TCUtils.debug("PortExpression", hot.node, hot.signal, false, new Object[0]);
        IHidObject lhSide = portExpression.getLHValue();
        IHidObject rhSide = portExpression.getFirstRHValue();
        if (lhSide instanceof IHid && rhSide instanceof IHid && ((IHid)lhSide).getName().equals(((IHid)rhSide).getName())) {
            return isEnd;
        }
        return isEnd &= TCUtils.traceSignalInPortExpressionsSide(true, hot, bundle, portExpression, searchNode, closestAncestorInstanceNode, filePath, languageKind);
    }

    private static boolean traceSignalInPortExpressionsSide(boolean isRightSide, TCPathPoint hot, TCBundle bundle, IHidOperator portExpression, TCNode searchNode, TCNode closestAncestorInstanceNode, String filePath, LanguageKind languageKind) throws CanceledTraceException {
        boolean isEnd = true;
        TCUtils.checkCanceled(bundle);
        for (IHid hid : isRightSide ? portExpression.getRHHids(bundle.assignHidFlattening) : portExpression.getLHHids(bundle.assignHidFlattening)) {
            TCUtils.checkCanceled(bundle);
            if (!TCUtils.isSameOrCompatibleSignal2(hot.signal, TCUtils.resolveSignal(hid, searchNode, closestAncestorInstanceNode, true))) continue;
            if (TCUtils.addWriterOrReader(portExpression, searchNode, filePath, TCStatement.TCStatementKind.PORT_EXPRESSION, languageKind, bundle)) {
                return isEnd;
            }
            for (IHid candidateHid : isRightSide ? portExpression.getLHHids(bundle.assignHidFlattening) : portExpression.getRHHids(bundle.assignHidFlattening)) {
                HidOperatorOccurrence occurrence;
                GoToInfo goToInfo;
                TCStatement statement;
                TCPathPoint effect;
                TCUtils.checkCanceled(bundle);
                IRfNamedElement candidate = TCUtils.resolveSignal(candidateHid, searchNode, closestAncestorInstanceNode, true);
                if (candidate == null || !DesignUtils.isValidSignalCandidate(candidate, null) || hot.equals(effect = TCPathPoint.of(hot.node, candidate, null, statement = TCStatement.of(TCStatement.TCStatementKind.PORT_EXPRESSION, goToInfo = GoToInfo.of(filePath, (occurrence = portExpression.getOccurrence()).getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), candidate.toString(), languageKind))))) continue;
                TCUtils.chainHotSignal(effect, hot, bundle);
                isEnd = false;
            }
            return isEnd;
        }
        return isEnd;
    }

    private static boolean traceSignalInConcurrentBlocks(TCPathPoint hot, TCBundle bundle, TCNode searchNode, TCNode closestAncestorInstanceNode, IRfNamedElement searchElemType) throws CanceledTraceException {
        boolean isEnd = true;
        if (hot == null || searchNode == null || bundle == null || searchElemType == null) {
            return isEnd;
        }
        TCUtils.checkCanceled(bundle);
        final LanguageKind languageKind = searchElemType.getLanguageKind();
        if (languageKind == LanguageKind.VLOG && bundle.configurations.contains((Object)TCConfiguration.IGNORE_COMBINATIONAL_ALWAYS_BLOCKS) || languageKind == LanguageKind.VHDL && bundle.configurations.contains((Object)TCConfiguration.IGNORE_PROCESSES)) {
            return isEnd;
        }
        Map<IRfNamedElement, LogicForm> concurrentBlocksLogicForm = TCCache.INSTANCE.getConcurrentBlocksLogicForm(searchElemType);
        if (concurrentBlocksLogicForm == null) {
            concurrentBlocksLogicForm = new LinkedHashMap<IRfNamedElement, LogicForm>(4);
            DesignUtils.collectConcurrentBlocksWithOperators(searchElemType, concurrentBlocksLogicForm, bundle.converterOptions, bundle.assignHidFlattening, bundle.monitor);
            TCCache.INSTANCE.addConcurrentBlocksLogicForm(searchElemType, concurrentBlocksLogicForm);
        }
        if (concurrentBlocksLogicForm.isEmpty()) {
            return isEnd;
        }
        TCUtils.debug("Concurrent blocks", searchNode, hot.signal, false, new Object[0]);
        for (Map.Entry<IRfNamedElement, LogicForm> logicFormOfBlock : concurrentBlocksLogicForm.entrySet()) {
            TCUtils.checkCanceled(bundle);
            final IRfNamedElement searchBlock = logicFormOfBlock.getKey();
            final LogicForm logicForm = logicFormOfBlock.getValue();
            Supplier<TCStatement> statementSupplier = new Supplier<TCStatement>(){

                @Override
                public TCStatement get() {
                    String filePath;
                    IRfDefElement declaration = searchBlock.getDeclaration();
                    int line = declaration != null ? declaration.getStartLine() : -1;
                    int offset = declaration != null ? declaration.getStartOffset() : -1;
                    int virtualOffset = -1;
                    ParserPath fileParserPath = declaration != null ? declaration.getParserPath() : null;
                    String string = filePath = fileParserPath != null ? fileParserPath.path : null;
                    if (languageKind == LanguageKind.VLOG) {
                        GoToInfo firstMarker = !logicForm.content.isEmpty() ? logicForm.content.get(0).getMarker() : null;
                        virtualOffset = firstMarker != null ? firstMarker.virtualOffset : -1;
                    }
                    GoToInfo goToInfo = GoToInfo.of(filePath, offset, virtualOffset, line, "", languageKind);
                    TCStatement statement = TCStatement.of(TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK, goToInfo);
                    return statement;
                }
            };
            isEnd &= TCUtils.internalTraceSignalInAssigns(hot, logicForm, searchNode, closestAncestorInstanceNode, statementSupplier, bundle, true);
        }
        return isEnd;
    }

    @NotNull
    private static Map<IRfPortElement, Set<TCConnSignal>> mapInstancePortConnections(TCNode node, LFOperatorConverter converter, Set<HidFlatteningOption> signalHidFlattening) {
        if (node.type != TCNode.TCNodeType.INSTANCE) {
            return Collections.emptyMap();
        }
        Map<IRfPortElement, Set<TCConnSignal>> portConnections = TCCache.INSTANCE.getPortConnections(node);
        if (portConnections != null) {
            return portConnections;
        }
        portConnections = DesignUtils.mapInstancePortConnections(node.designRequest(), node.dummyPortMap, signalHidFlattening, true, false, converter);
        TCCache.INSTANCE.addPortConnections(node, portConnections);
        return portConnections;
    }

    private static IHidOperator makeOperatorForPredefinedGateInstance(IRfPredefinedGate gateType, TCNode node, TCBundle bundle) {
        Map<IRfPortElement, Set<TCConnSignal>> portConnections = TCUtils.mapInstancePortConnections(node, null, bundle.portConnectionHidFlattening);
        if (portConnections.isEmpty()) {
            return null;
        }
        return DesignUtils.makeOperatorForPredefinedGateInstance(gateType, (IRfInstanceElement)node.namedElement, GoToInfo.sourceOf(node.namedElement), node.dummyPortMap, portConnections, bundle.portConnectionHidFlattening);
    }

    @NotNull
    private static List<IHidOperator> getAssignAndPortExpressionOperators(IRfNamedElement searchElemType, TCBundle bundle) {
        List<IHidOperator> assignsAndPortExpressionsLogic = TCCache.INSTANCE.getAssignAndPortExpressionLogic(searchElemType);
        if (assignsAndPortExpressionsLogic == null) {
            assignsAndPortExpressionsLogic = new ArrayList<IHidOperator>();
            DesignUtils.collectLocalOperators(assignsAndPortExpressionsLogic, searchElemType, TCUtils.getAssignAndPortExpressionQualifiers(bundle));
            TCCache.INSTANCE.addAssignAndPortExpressionLogic(searchElemType, assignsAndPortExpressionsLogic);
        }
        return assignsAndPortExpressionsLogic;
    }

    @NotNull
    private static Set<IRfNamedElement> grantContinue(TCPathPoint hot, TCBundle bundle, LogicForm normLogicForm, TCNode searchNode, TCNode closestAncestorInstanceNode, boolean isInBlock) {
        if (normLogicForm == null || normLogicForm.isEmpty()) {
            return null;
        }
        LinkedHashSet<IRfNamedElement> granted = null;
        for (LFProgram prog : normLogicForm.content) {
            Set<IRfNamedElement> result;
            LFFanIn fanIn = LFUtils.getExtendedFanInOfProgram(prog, bundle.assignHidFlattening);
            if (fanIn == null) continue;
            Set<IRfNamedElement> set = result = bundle.traceOperation == TCOperation.LOAD ? TCUtils.internalGrantContinueToLoads(fanIn, hot, searchNode, closestAncestorInstanceNode, isInBlock) : TCUtils.internalGrantContinueToDrivers(fanIn, hot, searchNode, closestAncestorInstanceNode, isInBlock);
            if (result == null) continue;
            if (granted == null) {
                granted = new LinkedHashSet<IRfNamedElement>(4);
            }
            granted.addAll(result);
        }
        return granted;
    }

    @NotNull
    private static Set<IRfNamedElement> grantContinueOutside(TCPathPoint hot, LogicForm normLogicForm, TCNode searchNode, TCNode closestAncestorInstanceNode, TCBundle bundle) {
        if (normLogicForm == null || normLogicForm.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IRfNamedElement> granted = null;
        for (LFProgram prog : normLogicForm.content) {
            LFFanIn fanIn = LFUtils.getExtendedFanInOfProgram(prog, bundle.portConnectionHidFlattening);
            if (fanIn == null) continue;
            IRfNamedElement load = fanIn.getCenterResolved(searchNode.designRequest(), closestAncestorInstanceNode != null ? closestAncestorInstanceNode.getELInstance() : null, null);
            if (!TCUtils.isSameOrCompatibleSignal2(hot.signal, load)) continue;
            for (IHid driverHid : fanIn.getBorder()) {
                IRfNamedElement driver = TCUtils.graftSignalToCandidate(TCUtils.resolveSignal(driverHid, searchNode, closestAncestorInstanceNode, true), hot.signal);
                if (DesignUtils.isValidSignalCandidate(driver, null)) {
                    if (granted == null) {
                        granted = new LinkedHashSet<IRfNamedElement>(2);
                    }
                    granted.add(driver);
                    continue;
                }
                TCUtils.addWriterOrReader(prog.getMarker(), searchNode, TCStatement.TCStatementKind.PORT_CONNECTION, bundle);
            }
        }
        return granted;
    }

    private static Set<IRfNamedElement> grantContinueInside(TCPathPoint hot, LogicForm normLogicForm, TCNode searchNode, TCNode closestAncestorInstanceNode, TCBundle bundle) {
        if (normLogicForm == null || normLogicForm.isEmpty()) {
            return null;
        }
        for (LFProgram prog : normLogicForm.content) {
            LFFanIn fanIn = LFUtils.getExtendedFanInOfProgram(prog, bundle.portConnectionHidFlattening);
            if (fanIn == null || !TCUtils.internalIncludesSignal(fanIn.getBorder(), hot.signal, searchNode, closestAncestorInstanceNode)) continue;
            IRfNamedElement load = fanIn.getCenterResolved(searchNode.designRequest(), closestAncestorInstanceNode != null ? closestAncestorInstanceNode.getELInstance() : null, null);
            if (!DesignUtils.isValidSignalCandidate(load = TCUtils.graftSignalToCandidate(load, hot.signal), null)) continue;
            return Collections.singleton(load);
        }
        return null;
    }

    private static Set<IRfNamedElement> internalGrantContinueToDrivers(LFFanIn fanIn, TCPathPoint hot, TCNode searchNode, TCNode closestInstanceNode, boolean isInBlock) {
        IRfNamedElement load = fanIn.getCenterResolved(searchNode.designRequest(), closestInstanceNode != null ? closestInstanceNode.getELInstance() : null, null);
        if (TCUtils.isSameOrCompatibleSignal2(hot.signal, load)) {
            LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>(fanIn.size());
            for (IHid driverHid : fanIn.getBorder()) {
                IRfNamedElement driver = TCUtils.graftSignalToCandidate(TCUtils.resolveSignal(driverHid, searchNode, closestInstanceNode, true), hot.signal);
                if ((!isInBlock || !DesignUtils.isValidBlockSignalCandidate(driver)) && !DesignUtils.isValidSignalCandidate(driver, null)) continue;
                result.add(driver);
            }
            return result;
        }
        return null;
    }

    private static Set<IRfNamedElement> internalGrantContinueToLoads(LFFanIn fanIn, TCPathPoint hot, TCNode searchNode, TCNode closestInstanceNode, boolean isInBlock) {
        if (TCUtils.internalIncludesSignal(fanIn.getBorder(), hot.signal, searchNode, closestInstanceNode)) {
            IRfNamedElement load = fanIn.getCenterResolved(searchNode.designRequest(), closestInstanceNode != null ? closestInstanceNode.getELInstance() : null, null);
            load = TCUtils.graftSignalToCandidate(load, hot.signal);
            if (isInBlock && DesignUtils.isValidBlockSignalCandidate(load) || DesignUtils.isValidSignalCandidate(load, null)) {
                return Collections.singleton(load);
            }
        }
        return null;
    }

    private static TCNode getEnclosingNode(IRfScopeElement scope, TCNode startNode) {
        if (scope == null || startNode == null) {
            return startNode;
        }
        TCNode currentNode = startNode;
        do {
            if (scope != DesignUtils.getDesign(currentNode.designRequest())) continue;
            return currentNode;
        } while (currentNode.type == TCNode.TCNodeType.BLOCK && (currentNode = currentNode.parent) != null);
        return currentNode == null ? startNode : currentNode;
    }

    private static String getFilePath(IRfNamedElement searchElemType) {
        IRfDefElement declaration = searchElemType.getDeclaration();
        ParserPath fileParserPath = declaration != null ? declaration.getParserPath() : null;
        return fileParserPath != null ? fileParserPath.path : null;
    }

    private static boolean includesOutputDirection(IRfPortElement port) {
        return port.isOutput() || port.isInout() || port.isBuffer();
    }

    private static boolean includesInputDirection(IRfPortElement port) {
        return port.isInput() || port.isInout() || port.isBuffer();
    }

    private static boolean internalIncludesDirection(TCOperation traceOperation, boolean directionForDrive, boolean directionForLoad) {
        return traceOperation == TCOperation.DRIVE ? directionForDrive : (traceOperation == TCOperation.LOAD ? directionForLoad : false);
    }

    private static IRfPortElement getConnectionPort(IRfNamedElement signal) {
        if (signal instanceof HierarchicalElement) {
            signal = ((HierarchicalElement)signal).getFirstSegment();
        }
        return signal instanceof IRfPortElement ? (IRfPortElement)signal : null;
    }

    private static IRfNamedElement resolveSignal(Object signal, TCNode searchNode, TCNode closestAncestorInstanceNode, boolean local) {
        ELInstance closestAncestorInstance;
        ELInstance eLInstance = closestAncestorInstance = closestAncestorInstanceNode != null ? closestAncestorInstanceNode.getELInstance() : null;
        if (searchNode == null) {
            return DesignUtils.resolveSignal(signal, DesignUtils.DesignRequest.of(null, null), closestAncestorInstance, null);
        }
        IRfNamedElement candidate = DesignUtils.resolveSignal(signal, searchNode.designRequest(), closestAncestorInstance, searchNode.dummyPortMap);
        if (candidate != null) {
            return candidate;
        }
        if (local || searchNode.type != TCNode.TCNodeType.BLOCK) {
            return null;
        }
        return TCUtils.resolveSignal(signal, searchNode.parent, closestAncestorInstanceNode, local);
    }

    private static IRfNamedElement graftSignalToCandidate(IRfNamedElement candidate, IRfNamedElement hotSignal) {
        if (candidate == null) {
            return null;
        }
        if (hotSignal instanceof HierarchicalElement) {
            return TCUtils.graftHierarchicalSignalToCandidate(candidate, (HierarchicalElement)hotSignal);
        }
        return candidate;
    }

    private static IRfNamedElement graftHierarchicalSignalToCandidate(IRfNamedElement candSignal, HierarchicalElement hotSignal) {
        List<IRfNamedElement> candList = candSignal instanceof HierarchicalElement ? ((HierarchicalElement)candSignal).getSegments() : Collections.singletonList(candSignal);
        List<IRfNamedElement> hotList = hotSignal.getSegments();
        int candSize = candList.size();
        int hotSize = hotList.size();
        int candIndex = 0;
        int hotIndex = 0;
        IRfNamedElement cand = candList.get(candIndex);
        IRfNamedElement hot = hotList.get(hotIndex);
        boolean found = false;
        while (hotIndex < hotSize || candIndex < candSize) {
            if (cand instanceof IRfModportElement || cand instanceof IRfClockingBlockElement) {
                if (++candIndex >= candSize) break;
                cand = candList.get(candIndex);
                continue;
            }
            if (hot instanceof IRfModportElement || hot instanceof IRfClockingBlockElement) {
                if (++hotIndex >= hotSize) break;
                hot = hotList.get(hotIndex);
                continue;
            }
            boolean partialFound = TCUtils.isSameOrCompatibleSegment(cand, hot, false);
            if (found && !partialFound) {
                found = false;
                break;
            }
            if (found |= partialFound) {
                ++hotIndex;
                if (++candIndex >= candSize) break;
                cand = candList.get(candIndex);
                if (hotIndex >= hotSize) continue;
                hot = hotList.get(hotIndex);
                continue;
            }
            if (candIndex + 1 < candSize) {
                cand = candList.get(++candIndex);
                continue;
            }
            if (hotIndex + 1 >= hotSize) break;
            hot = hotList.get(++hotIndex);
        }
        if (!found) {
            return candSignal;
        }
        ArrayList<IRfNamedElement> newSegments = new ArrayList<IRfNamedElement>(candList.size());
        for (IRfNamedElement segment : candList) {
            if (segment instanceof IRfModportElement || segment instanceof IRfClockingBlockElement) continue;
            newSegments.add(segment);
        }
        while (hotIndex < hotSize) {
            IRfNamedElement remaining;
            if ((remaining = hotList.get(hotIndex++)) instanceof IRfModportElement || remaining instanceof IRfClockingBlockElement) continue;
            newSegments.add(remaining);
        }
        return HierarchicalElement.of(newSegments.toArray(new IRfNamedElement[newSegments.size()]));
    }

    private static boolean hasSubPart(HierarchicalElement hotSignal, IRfNamedElement candidate) {
        if (hotSignal == null || candidate == null) {
            return false;
        }
        List<IRfNamedElement> candidateSegments = candidate instanceof HierarchicalElement ? ((HierarchicalElement)candidate).getSegments() : Collections.singletonList(candidate);
        Iterator<IRfNamedElement> ownIter = hotSignal.getSegments().iterator();
        Iterator<IRfNamedElement> otherIter = candidateSegments.iterator();
        boolean strictMatch = true;
        while (ownIter.hasNext() && otherIter.hasNext()) {
            boolean partialFound;
            IRfNamedElement otherSegment;
            IRfNamedElement segment = ownIter.next();
            if (segment instanceof IRfModportElement) {
                strictMatch = false;
                if (ownIter.hasNext()) {
                    segment = ownIter.next();
                }
            }
            if (segment instanceof IRfClockingBlockElement) {
                strictMatch = false;
                if (ownIter.hasNext()) {
                    segment = ownIter.next();
                }
            }
            if ((otherSegment = otherIter.next()) instanceof IRfModportElement) {
                strictMatch = false;
                if (!otherIter.hasNext()) break;
                otherSegment = otherIter.next();
            }
            if (otherSegment instanceof IRfClockingBlockElement) {
                strictMatch = false;
                if (!otherIter.hasNext()) break;
                otherSegment = otherIter.next();
            }
            if (partialFound = TCUtils.isSameOrCompatibleSegment(segment, otherSegment, strictMatch)) continue;
            return false;
        }
        return !otherIter.hasNext();
    }

    private static boolean isSameOrCompatibleSegment(IRfNamedElement first, IRfNamedElement second, boolean strictMatch) {
        IRfNamedElement secondAssocType;
        boolean isSecondInteresting;
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        TCInterfaceInterest firstInterfaceInterest = TCUtils.resolveInterfaceInterest(first);
        TCInterfaceInterest secondInterfaceInterest = TCUtils.resolveInterfaceInterest(second);
        if (firstInterfaceInterest == TCInterfaceInterest.PORT_OF_MODPORT_OR_CLOCKING_BLOCK && first instanceof IRfPortElement) {
            first = ((IRfPortElement)first).getDesignUnitPort();
        }
        if (secondInterfaceInterest == TCInterfaceInterest.PORT_OF_MODPORT_OR_CLOCKING_BLOCK && second instanceof IRfPortElement) {
            second = ((IRfPortElement)second).getDesignUnitPort();
        }
        if (strictMatch) {
            return first == second;
        }
        boolean isFirstInteresting = firstInterfaceInterest == TCInterfaceInterest.INTERFACE_AS_PORT || firstInterfaceInterest == TCInterfaceInterest.MODPORT_AS_PORT || firstInterfaceInterest == TCInterfaceInterest.INTERFACE_AS_INSTANCE || firstInterfaceInterest == TCInterfaceInterest.VIRTUAL_INTERFACE || firstInterfaceInterest == TCInterfaceInterest.VIRTUAL_MODPORT;
        boolean bl = isSecondInteresting = secondInterfaceInterest == TCInterfaceInterest.INTERFACE_AS_PORT || secondInterfaceInterest == TCInterfaceInterest.MODPORT_AS_PORT || secondInterfaceInterest == TCInterfaceInterest.INTERFACE_AS_INSTANCE || secondInterfaceInterest == TCInterfaceInterest.VIRTUAL_INTERFACE || secondInterfaceInterest == TCInterfaceInterest.VIRTUAL_MODPORT;
        if (isFirstInteresting && isSecondInteresting) {
            return true;
        }
        IRfNamedElement firstAssocType = first instanceof IRfAssociatedTypeElement ? ((IRfAssociatedTypeElement)first).getResolvedType(true) : null;
        IRfNamedElement iRfNamedElement = secondAssocType = second instanceof IRfAssociatedTypeElement ? ((IRfAssociatedTypeElement)second).getResolvedType(true) : null;
        return firstAssocType == secondAssocType;
    }

    private static boolean isSameOrCompatibleSignal2(IRfNamedElement hotSignal, IRfNamedElement otherSignal) {
        if (hotSignal == otherSignal) {
            return true;
        }
        if (!(hotSignal instanceof HierarchicalElement)) {
            return false;
        }
        return TCUtils.hasSubPart((HierarchicalElement)hotSignal, otherSignal);
    }

    private static boolean internalIncludesSignal(Collection<IHid> searchHids, IRfNamedElement hotSignal, TCNode searchNode, TCNode closestAncestorInstanceNode) {
        if (searchHids == null || searchHids.isEmpty()) {
            return false;
        }
        for (IHid hid : searchHids) {
            if (!TCUtils.isSameOrCompatibleSignal2(hotSignal, TCUtils.resolveSignal(hid, searchNode, closestAncestorInstanceNode, true))) continue;
            return true;
        }
        return false;
    }

    private static boolean addHotSignal(TCPathPoint effect, TCBundle bundle) throws CanceledTraceException {
        if (effect.node.addHotSignal(effect.signal, bundle.traceOperation)) {
            TCUtils.debug("\n--- Added signal", effect.node, effect.signal, true, new Object[0]);
            TCUtils.checkCanceled(bundle);
            bundle.boundary.add(effect);
            TCUtils.startNewTask(bundle);
            return true;
        }
        return false;
    }

    private static boolean chainHotSignal(TCPathPoint effect, TCPathPoint cause, TCBundle bundle) throws CanceledTraceException {
        TCUtils.checkCanceled(bundle);
        if (TCUtils.addWriterOrReader(effect, bundle)) {
            return true;
        }
        if (effect.node.addHotSignal(effect.signal, bundle.traceOperation)) {
            TCUtils.debug("\n--- Chained signal", effect.node, effect.signal, true, new Object[0]);
            bundle.causedBy.addLink(effect, cause);
            bundle.boundary.add(effect);
            return true;
        }
        bundle.redundance.addRedundant(effect, cause);
        return false;
    }

    private static boolean addWriterOrReader(TCPathPoint effect, TCBundle bundle) {
        if (bundle.extendedBoundary == null || effect == null || !bundle.configurations.contains((Object)TCConfiguration.COLLECT_WRITERS_AND_READERS)) {
            return false;
        }
        TCUtils.debug("\n--- Collected writer/reader", effect.node, effect.signal, true, new Object[0]);
        bundle.extendedBoundary.add(effect);
        return true;
    }

    private static boolean addWriterOrReader(GoToInfo goToInfo, TCNode searchNode, TCStatement.TCStatementKind statementKind, TCBundle bundle) {
        if (bundle.extendedBoundary == null || goToInfo == null || !bundle.configurations.contains((Object)TCConfiguration.COLLECT_WRITERS_AND_READERS)) {
            return false;
        }
        bundle.extendedBoundary.add(TCPathPoint.of(searchNode, null, TCStatement.of(statementKind, goToInfo)));
        return true;
    }

    private static boolean addWriterOrReader(IHidOperator candidate, TCNode searchNode, String filePath, TCStatement.TCStatementKind statementKind, LanguageKind languageKind, TCBundle bundle) {
        if (bundle.extendedBoundary == null || candidate == null || filePath == null || !bundle.configurations.contains((Object)TCConfiguration.COLLECT_WRITERS_AND_READERS)) {
            return false;
        }
        TCUtils.debug("\n--- Collected writer/reader", searchNode, null, true, new Object[0]);
        HidOperatorOccurrence occurence = candidate.getOccurrence();
        GoToInfo goToInfo = GoToInfo.of(filePath, occurence.getOffset(), occurence.getVirtualOffset(), occurence.getLine(), "", languageKind);
        bundle.extendedBoundary.add(TCPathPoint.of(searchNode, null, TCStatement.of(statementKind, goToInfo)));
        return true;
    }

    private static boolean addWriterOrReader(TCNode searchNode, Supplier<TCStatement> statementSupplier, TCBundle bundle) {
        if (bundle.extendedBoundary == null || !bundle.configurations.contains((Object)TCConfiguration.COLLECT_WRITERS_AND_READERS)) {
            return false;
        }
        TCUtils.debug("\n--- Collected writer/reader", searchNode, null, true, new Object[0]);
        TCStatement statement = statementSupplier.get();
        bundle.extendedBoundary.add(TCPathPoint.of(searchNode, null, statement));
        return true;
    }

    private static void startNewTask(TCBundle bundle) throws CanceledTraceException {
        TCUtils.traceSignalIterative(bundle);
    }

    private static void startNewTask(TCPathPoint hot, TCBundle bundle) throws CanceledTraceException {
        TCUtils.traceSignalRecursive(hot, bundle);
    }

    private static void debug(String message, TCNode node, IRfNamedElement hotSignal, boolean addNewLine, Object ... additions) {
    }

    public static void traceSignalGeneric(TCOperation traceOperation, TCNode selectedNode, IRfNamedElement selectedSignal, TCEndSet ends, TCPathChain causedBy, TCPathRedundance redundance, Set<TCConfiguration> configs, IProgressMonitor monitor) throws CanceledTraceException {
        if (traceOperation != TCOperation.DRIVE && traceOperation != TCOperation.LOAD) {
            return;
        }
        if (selectedNode == null || selectedSignal == null || causedBy == null || !ends.isEmpty()) {
            return;
        }
        EnumSet<HidFlatteningOption> portConnectionHidFlattening = null;
        EnumSet<HidFlatteningOption> assignHidFlattening = null;
        if (configs != null && configs.contains((Object)TCConfiguration.IGNORE_CONCAT_AND_ASSIGN_PATTERNS)) {
            portConnectionHidFlattening = EnumSet.copyOf(DesignUtils.PORT_CONNECTION_HID_FLATTENING);
            portConnectionHidFlattening.add(HidFlatteningOption.IGNORE_CONCAT_AND_ASSIGN_PATTERNS);
            assignHidFlattening = EnumSet.copyOf(DesignUtils.ASSIGN_HID_FLATTENING);
            assignHidFlattening.add(HidFlatteningOption.IGNORE_CONCAT_AND_ASSIGN_PATTERNS);
        }
        TCBundle startingBundle = new TCBundle(null, traceOperation, ends, causedBy, new ArrayDeque<TCPathPoint>(), null, redundance, configs, TCUtils.getConverterOptionsFromConfiguration(configs), portConnectionHidFlattening, assignHidFlattening, monitor, null);
        TCUtils.addHotSignal(TCPathPoint.of(selectedNode, selectedSignal, null), startingBundle);
    }

    public static void traceSignal(TCNode selectedNode, IRfNamedElement selectedSignal, TCEndSet sourceNodes, TCEndSet destinationNodes, TCPathChain driveCausedBy, TCPathChain loadCausedBy, TCPathRedundance driveRedundance, TCPathRedundance loadRedundance, Set<TCConfiguration> traceConfigs, IProgressMonitor monitor) throws CanceledTraceException {
        if (selectedNode == null || selectedSignal == null) {
            return;
        }
        TCNode origRoot = null;
        try {
            try {
                origRoot = TCUtils.getNodeRoot(selectedNode);
                if (!TCUtils.isNodeInTree(origRoot, selectedNode, monitor)) {
                    throw new CanceledTraceException("Internal Error: selected node not found");
                }
                monitor.subTask(TCViewMessages.fJobTaskTraceDriveText);
                TCUtils.traceSignalGeneric(TCOperation.DRIVE, selectedNode, selectedSignal, sourceNodes, driveCausedBy, driveRedundance, traceConfigs, monitor);
                monitor.subTask(TCViewMessages.fJobTaskTraceLoadText);
                TCUtils.traceSignalGeneric(TCOperation.LOAD, selectedNode, selectedSignal, destinationNodes, loadCausedBy, loadRedundance, traceConfigs, monitor);
            }
            catch (CanceledTraceException canceledTraceException) {
                throw new CanceledTraceException();
            }
        }
        finally {
            origRoot = null;
        }
    }

    public static void traceSignalInFullHierarchy(TCNode selectedNode, IRfPortElement selectedPort, TCPathChain causedBy, Set<TCConfiguration> configs, IProgressMonitor monitor) throws CanceledTraceException {
        if (selectedNode == null || selectedPort == null || causedBy == null) {
            return;
        }
        TCNode origRoot = TCUtils.getNodeRoot(selectedNode);
        TCNode[] origPreOrder = TCUtils.preOrderSubtree(origRoot, monitor);
        int idx = -1;
        int i = 0;
        while (i < origPreOrder.length) {
            if (origPreOrder[i] == selectedNode) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            throw new CanceledTraceException("Internal Error: selected node not found");
        }
        TCNode sigSrcTreeRoot = TCUtils.copyColdTree(origRoot, monitor);
        TCNode sigDestTreeRoot = TCUtils.copyColdTree(origRoot, monitor);
        TCNode[] sigSrcPreorder = TCUtils.preOrderSubtree(sigSrcTreeRoot, monitor);
        TCNode[] sigDestPreorder = TCUtils.preOrderSubtree(sigDestTreeRoot, monitor);
        if (configs == null) {
            configs = EnumSet.of(TCConfiguration.IGNORE_DIRECTION);
        }
        if (!configs.contains((Object)TCConfiguration.IGNORE_DIRECTION)) {
            configs.add(TCConfiguration.IGNORE_DIRECTION);
        }
        TCUtils.traceSignalGeneric(TCOperation.DRIVE, sigSrcPreorder[idx], selectedPort, new TCEndSet(), causedBy, null, configs, monitor);
        TCUtils.traceSignalGeneric(TCOperation.LOAD, sigDestPreorder[idx], selectedPort, new TCEndSet(), causedBy, null, configs, monitor);
        int i2 = 0;
        while (i2 < origPreOrder.length) {
            TCNode origNode = origPreOrder[i2];
            if (origNode.hotApplicable()) {
                TCNode[] tCNodeArray = new TCNode[]{sigSrcPreorder[i2], sigDestPreorder[i2]};
                int n = tCNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TCNode x = tCNodeArray[n2];
                    for (IRfNamedElement s : x.getHotSignals()) {
                        origNode.addHotSignal(s, TCOperation.DRIVE);
                    }
                    ++n2;
                }
            }
            ++i2;
        }
    }

    public static List<TCPathPoint> getSignalWritersOrReaders2(TCOperation operation, TCPathPoint hot, TCNode searchNode, IDVTJob updateJob, boolean isJumpToAssignment) {
        try {
            EnumSet<TCConfiguration> configuration = EnumSet.of(TCConfiguration.IGNORE_CONTINUOUS_ASSIGNS, TCConfiguration.IGNORE_COMBINATIONAL_ALWAYS_BLOCKS, TCConfiguration.IGNORE_PROCESSES, TCConfiguration.COLLECT_WRITERS_AND_READERS);
            TCBundle bundle = new TCBundle(null, operation, null, new TCPathChain(), new ArrayDeque<TCPathPoint>(), new ArrayDeque<TCPathPoint>(), null, configuration, LFConverterOptions.TRACE_WRITERS_AND_READERS, HidFlatteningOption.NONE_EXCLUDED, HidFlatteningOption.NONE_EXCLUDED, (IProgressMonitor)new NullProgressMonitor(), updateJob);
            TCUtils.traceSignalOutside(hot, bundle);
            TCUtils.traceSignalInside(hot, bundle);
            bundle = new TCBundle(null, operation, null, bundle.causedBy, bundle.boundary, bundle.extendedBoundary, null, configuration, LFConverterOptions.TRACE_WRITERS_AND_READERS_NO_ASSOCIATIONS, HidFlatteningOption.NONE_EXCLUDED, HidFlatteningOption.NONE_EXCLUDED, (IProgressMonitor)new NullProgressMonitor(), updateJob);
            TCUtils.collectSignalWritersOrReadersInDesign(hot, searchNode, bundle, isJumpToAssignment);
            ArrayList<TCPathPoint> result = new ArrayList<TCPathPoint>();
            Iterator iterator = bundle.extendedBoundary.iterator();
            LinkedHashSet<TCStatement> uniqueStatements = new LinkedHashSet<TCStatement>(bundle.extendedBoundary.size());
            while (iterator.hasNext()) {
                TCPathPoint point = (TCPathPoint)iterator.next();
                if (!isJumpToAssignment && point.statement == null || uniqueStatements.contains(point.statement)) {
                    iterator.remove();
                    continue;
                }
                uniqueStatements.add(point.statement);
                if (point.signal == null) {
                    point.signal = hot.signal;
                }
                result.add(point);
            }
            return result;
        }
        catch (CanceledTraceException canceledTraceException) {
            return Collections.emptyList();
        }
    }

    private static void collectSignalWritersOrReadersInDesign(TCPathPoint hot, TCNode searchNode, TCBundle bundle, boolean isJumpToAssignments) throws CanceledTraceException {
        IRfDesignElement entity;
        LogicForm normLogicForm2;
        if (hot == null || searchNode == null || bundle == null) {
            return;
        }
        TCUtils.checkCanceled(bundle);
        IRfDesignElement searchElemType = DesignUtils.getDesign(searchNode.designRequest());
        if (searchElemType == null) {
            return;
        }
        LogicForm normLogicForm = LFConverter.INSTANCE.convertElementAndNormalize(searchElemType, null, bundle.converterOptions, bundle.assignHidFlattening, bundle.monitor);
        if (DesignUtils.getDesignKind(searchElemType) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && (normLogicForm2 = LFConverter.INSTANCE.convertElementAndNormalize(entity = ((IRfBlockElement)searchElemType).getEntity(), null, bundle.converterOptions, bundle.assignHidFlattening, bundle.monitor)) != null) {
            if (normLogicForm != null) {
                normLogicForm.content.addAll(normLogicForm2.content);
            } else {
                normLogicForm = normLogicForm2;
            }
        }
        if (normLogicForm == null) {
            return;
        }
        TCUtils.debug("All Writers and Readers", searchNode, hot.signal, false, new Object[0]);
        TCUtils.checkCanceled(bundle);
        TCNode closestAncestorInstanceNode = searchNode.getClosestAncestorInstanceSkippingBlocks();
        for (LFProgram prog : normLogicForm.content) {
            LFFanIn extendedFanIn = LFUtils.getExtendedFanInOfProgram(prog, bundle.assignHidFlattening);
            if (extendedFanIn == null || !extendedFanIn.hasBorder() || bundle.traceOperation == TCOperation.LOAD && !TCUtils.internalIncludesSignal(extendedFanIn.getBorder(), hot.signal, searchNode, closestAncestorInstanceNode)) continue;
            if (bundle.traceOperation == TCOperation.DRIVE) {
                IRfNamedElement load = extendedFanIn.getCenterResolved(searchNode.designRequest(), closestAncestorInstanceNode != null ? closestAncestorInstanceNode.getELInstance() : null, null);
                if (!TCUtils.isSameOrCompatibleSignal2(hot.signal, load)) continue;
                if (!isJumpToAssignments) {
                    LFFormula formulaFromProgram = LFUtils.getFormulaFromProgram(prog);
                    LFUtils.flattenFormula(formulaFromProgram, formula -> {
                        LinkedHashSet<IHid> hids = new LinkedHashSet<IHid>();
                        formula.collectExprHids(hids, READER_WRITTER_HID_FLATTENING);
                        for (IHid hid : hids) {
                            int fieldKind;
                            IRfNamedElement cand = HidUtils.getResolvedElement(hid);
                            int n = fieldKind = cand instanceof IRfFieldElement ? ((IRfFieldElement)cand).getFieldKind() : 0;
                            if (fieldKind != 524288 && fieldKind != 512) continue;
                            return false;
                        }
                        TCUtils.addWriterOrReader(formula.getMarker(), searchNode, TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK, bundle);
                        return false;
                    });
                }
            }
            LFUtils.checkFanInOfProgram(prog, fanIn -> {
                TCUtils.addWriterOrReader(fanIn.getMarker(), searchNode, TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK, bundle);
                return true;
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    public static TCNode getNodeRoot(TCNode node) throws IllegalArgumentException {
        if (node != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.parent;
lbl4:
            // 2 sources

            ** while (node.parent != null)
        }
lbl5:
        // 1 sources

        return node;
    }

    private static TCNode[] preOrderSubtree(TCNode root, IProgressMonitor monitor) throws CanceledTraceException {
        ArrayList<TCNode> result = new ArrayList<TCNode>();
        ArrayDeque<TCNode> q = new ArrayDeque<TCNode>();
        q.add(root);
        while (!q.isEmpty()) {
            TCUtils.checkCanceled(monitor);
            TCNode n = (TCNode)q.remove();
            result.add(n);
            for (TCNode child : n.getChildren()) {
                TCUtils.checkCanceled(monitor);
                q.add(child);
            }
        }
        return result.toArray(new TCNode[0]);
    }

    private static boolean isNodeInTree(TCNode root, TCNode node, IProgressMonitor monitor) throws CanceledTraceException {
        if (root == node) {
            return true;
        }
        TCUtils.checkCanceled(monitor);
        for (TCNode child : root.getChildren()) {
            TCUtils.checkCanceled(monitor);
            if (!TCUtils.isNodeInTree(child, node, monitor)) continue;
            return true;
        }
        return false;
    }

    private static TCNode copyColdTree(TCNode node, IProgressMonitor monitor) throws CanceledTraceException {
        TCNode oldRoot = TCUtils.getNodeRoot(node);
        if (oldRoot == null) {
            return oldRoot;
        }
        TCNode newRoot = new TCNode(oldRoot.type, null, oldRoot.namedElement, oldRoot.dummyPortMap, true);
        newRoot.setDesignHint(oldRoot.designHint);
        ArrayDeque<TCNode> oldQueue = new ArrayDeque<TCNode>();
        ArrayDeque<TCNode> newQueue = new ArrayDeque<TCNode>();
        oldQueue.add(oldRoot);
        newQueue.add(newRoot);
        while (!oldQueue.isEmpty()) {
            TCUtils.checkCanceled(monitor);
            TCNode old = (TCNode)oldQueue.remove();
            TCNode fresh = (TCNode)newQueue.remove();
            for (TCNode oldChild : old.getChildren()) {
                TCUtils.checkCanceled(monitor);
                TCNode freshChild = new TCNode(oldChild.type, fresh, oldChild.namedElement, null, false);
                freshChild.setDesignHint(oldChild.designHint);
                fresh.addChild(freshChild);
                oldQueue.add(oldChild);
                newQueue.add(freshChild);
            }
        }
        return newRoot;
    }

    public static void clearHotData(TCNode node, boolean startWithTop) {
        if (startWithTop) {
            node = TCUtils.getNodeRoot(node);
        }
        if (node == null) {
            return;
        }
        node.clearHotData();
        for (TCNode child : node.getChildren()) {
            TCUtils.clearHotData(child, false);
        }
    }

    private static void checkCanceled(TCBundle bundle) throws CanceledTraceException {
        if (bundle.updateJob != null && bundle.updateJob.isCanceled()) {
            throw new CanceledTraceException();
        }
        if (bundle.monitor != null && bundle.monitor.isCanceled()) {
            throw new CanceledTraceException();
        }
    }

    private static void checkCanceled(IProgressMonitor monitor) throws CanceledTraceException {
        if (monitor != null && monitor.isCanceled()) {
            throw new CanceledTraceException();
        }
    }

    private static HidOperatorQualifier[] getAssignAndPortExpressionQualifiers(TCBundle bundle) {
        HidOperatorQualifier[] searchQualifiers = TCCache.INSTANCE.getAssignAndPortExpressionQualifiers();
        if (searchQualifiers == null) {
            ArrayList<HidOperatorQualifier> searchQualifiersList = new ArrayList<HidOperatorQualifier>(4);
            if (!bundle.configurations.contains((Object)TCConfiguration.IGNORE_CONTINUOUS_ASSIGNS)) {
                searchQualifiersList.add(HidOperatorQualifier.IS_DECLARATION_ASSIGN);
                searchQualifiersList.add(HidOperatorQualifier.IS_DECLARATION_EXPRESSION);
                searchQualifiersList.add(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN);
                searchQualifiersList.add(HidOperatorQualifier.IS_SELECT_CONTINUOUS_ASSIGN);
                searchQualifiersList.add(HidOperatorQualifier.IS_ALIAS);
            }
            if (!bundle.configurations.contains((Object)TCConfiguration.IGNORE_PORT_EXPRESSIONS)) {
                searchQualifiersList.add(HidOperatorQualifier.IS_PORT_EXPRESSION);
            }
            searchQualifiers = searchQualifiersList.toArray(new HidOperatorQualifier[searchQualifiersList.size()]);
            TCCache.INSTANCE.setAssignAndPortExpressionQualifiers(searchQualifiers);
        }
        return searchQualifiers;
    }

    @NotNull
    private static Set<LFConverterOptions> getConverterOptionsFromConfiguration(Set<TCConfiguration> config) {
        if (config != null && config.contains((Object)TCConfiguration.IGNORE_NONBLOCKING_ASSIGNMENTS)) {
            return LFConverterOptions.TRACE_NON_BLOCKING_SET;
        }
        return LFConverterOptions.TRACE_SET;
    }

    public static final TCInterfaceInterest resolveInterfaceInterest(IRfNamedElement hotSignal) {
        if (hotSignal instanceof HierarchicalElement) {
            return TCInterfaceInterest.NO_INTEREST;
        }
        if (hotSignal.getLanguageKind() != LanguageKind.VLOG) {
            return TCInterfaceInterest.NO_INTEREST;
        }
        if (hotSignal instanceof IRfModportElement) {
            return TCInterfaceInterest.MODPORT_OF_INTERFACE;
        }
        IRfNamedElement enclosingScope = (IRfNamedElement)hotSignal.getEnclosingScope();
        IRfNamedElement.ElementKind enclosingScopeDesignKind = DesignUtils.getDesignKind(DesignUtils.toGenericDesignElement(enclosingScope));
        while (enclosingScopeDesignKind == IRfNamedElement.ElementKind.VHDL_BLOCK || enclosingScopeDesignKind == IRfNamedElement.ElementKind.VLOG_GENERATE) {
            enclosingScope = (IRfNamedElement)enclosingScope.getEnclosingScope();
            enclosingScopeDesignKind = DesignUtils.getDesignKind(DesignUtils.toGenericDesignElement(enclosingScope));
        }
        if (enclosingScopeDesignKind == IRfNamedElement.ElementKind.VLOG_INTERFACE) {
            if (hotSignal instanceof IRfPortElement) {
                return TCInterfaceInterest.PORT_OF_INTERFACE;
            }
            if (DesignUtils.isFieldSignal(hotSignal)) {
                return TCInterfaceInterest.FIELD_OF_INTERFACE;
            }
            return TCInterfaceInterest.NO_INTEREST;
        }
        if (hotSignal instanceof IRfPortElement) {
            if (enclosingScope instanceof IRfModportElement || enclosingScope instanceof IRfClockingBlockElement) {
                return TCInterfaceInterest.PORT_OF_MODPORT_OR_CLOCKING_BLOCK;
            }
            if (((IRfPortElement)hotSignal).isModportPort()) {
                return TCInterfaceInterest.MODPORT_AS_PORT;
            }
            if (((IRfPortElement)hotSignal).isInterfacePort()) {
                return TCInterfaceInterest.INTERFACE_AS_PORT;
            }
            return TCInterfaceInterest.NO_INTEREST;
        }
        if (DesignUtils.isInterfaceInstance(hotSignal)) {
            return TCInterfaceInterest.INTERFACE_AS_INSTANCE;
        }
        if (DesignUtils.isFieldSignal(hotSignal)) {
            IRfNamedElement associatedType = ((IRfAssociatedTypeElement)hotSignal).getResolvedType(true);
            if (DesignUtils.getDesignKind(DesignUtils.toGenericDesignElement(associatedType)) == IRfNamedElement.ElementKind.VLOG_INTERFACE) {
                return TCInterfaceInterest.VIRTUAL_INTERFACE;
            }
            if (associatedType instanceof IRfModportElement) {
                return TCInterfaceInterest.VIRTUAL_MODPORT;
            }
            return TCInterfaceInterest.NO_INTEREST;
        }
        return TCInterfaceInterest.NO_INTEREST;
    }

    public static IRfNamedElement makeInterfaceSignal(IRfNamedElement particular, IRfNamedElement signalOrModport) {
        IRfNamedElement designPort;
        TCInterfaceInterest pi = TCUtils.resolveInterfaceInterest(particular);
        TCInterfaceInterest smi = TCUtils.resolveInterfaceInterest(signalOrModport);
        if (pi != TCInterfaceInterest.INTERFACE_AS_PORT && pi != TCInterfaceInterest.MODPORT_AS_PORT && pi != TCInterfaceInterest.INTERFACE_AS_INSTANCE && pi != TCInterfaceInterest.VIRTUAL_INTERFACE && pi != TCInterfaceInterest.VIRTUAL_MODPORT) {
            return null;
        }
        if (smi == TCInterfaceInterest.PORT_OF_MODPORT_OR_CLOCKING_BLOCK && (designPort = ((IRfPortElement)signalOrModport).getDesignUnitPort()) != null) {
            signalOrModport = designPort;
            smi = TCUtils.resolveInterfaceInterest(signalOrModport);
        }
        if (smi == TCInterfaceInterest.MODPORT_OF_INTERFACE) {
            return particular;
        }
        if (smi == TCInterfaceInterest.PORT_OF_INTERFACE || smi == TCInterfaceInterest.FIELD_OF_INTERFACE) {
            return HierarchicalElement.of(particular, signalOrModport);
        }
        return null;
    }

    private static void serializeTree(TCNode root, Deque<TCNode> serial, IProgressMonitor monitor) throws CanceledTraceException {
        if (root == null) {
            return;
        }
        serial.addFirst(root);
        for (TCNode child : root.getChildren()) {
            TCUtils.checkCanceled(monitor);
            TCUtils.serializeTree(child, serial, monitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void pruneEmptyInterfaceShellLeaves(TCNode root, boolean includeColdParents, TCOperation operation, TCEndSet sources, TCPathChain driveCausedBy, TCEndSet destinations, TCPathChain loadCausedBy, IProgressMonitor monitor) throws CanceledTraceException {
        if (root == null) {
            return;
        }
        TCUtils.checkCanceled(monitor);
        Deque<TCNode> ancestors = TCUtils.getAncestors(root, includeColdParents);
        if (ancestors.isEmpty()) {
            return;
        }
        root = ancestors.getFirst();
        ArrayDeque<TCNode> toPrune = new ArrayDeque<TCNode>();
        TCUtils.serializeTree(root, toPrune, monitor);
        toPrune.removeLast();
        block5: while (!toPrune.isEmpty()) {
            HierarchicalElement interfaceSignal;
            TCUtils.checkCanceled(monitor);
            TCNode node = (TCNode)toPrune.remove();
            if (node.hasChildren() || (interfaceSignal = node.isInterfaceShell()) == null) continue;
            TCUtils.checkCanceled(monitor);
            TCPathPoint singlePoint = TCPathPoint.of(node, interfaceSignal, null);
            switch (operation) {
                case DRIVE: {
                    TCPathPoint driveCause;
                    if (sources == null || !sources.isEndNode(node) || (driveCause = driveCausedBy.getCauseFromEffect(singlePoint)) == null) continue block5;
                    TCUtils.removeNodeFromEnds(sources, node, singlePoint, driveCause);
                    break;
                }
                case LOAD: {
                    TCPathPoint loadCause;
                    if (destinations == null || !destinations.isEndNode(node) || (loadCause = loadCausedBy.getCauseFromEffect(singlePoint)) == null) continue block5;
                    TCUtils.removeNodeFromEnds(destinations, node, singlePoint, loadCause);
                    break;
                }
                case DRIVE_AND_LOAD: {
                    if (sources == null || !sources.isEndNode(node) || destinations == null || !destinations.isEndNode(node)) continue block5;
                    TCPathPoint driveCause1 = driveCausedBy.getCauseFromEffect(singlePoint);
                    TCPathPoint loadCause1 = loadCausedBy.getCauseFromEffect(singlePoint);
                    if (driveCause1 == null || loadCause1 == null) continue block5;
                    TCUtils.removeNodeFromEnds(sources, node, singlePoint, driveCause1);
                    TCUtils.removeNodeFromEnds(destinations, node, singlePoint, loadCause1);
                }
            }
            node.parent.removeChild(node);
            node.deepClean();
        }
    }

    private static void removeNodeFromEnds(TCEndSet ends, TCNode node, TCPathPoint singlePoint, TCPathPoint driveCause) {
        ends.put(driveCause.node, driveCause);
        ends.removeSignalPoint(singlePoint);
        ends.removeNode(node);
    }

    public static Deque<TCNode> getAncestors(TCNode traceStart, boolean includeColdParents) {
        ArrayDeque<TCNode> ancestors = new ArrayDeque<TCNode>();
        ancestors.addFirst(traceStart);
        TCNode p = traceStart.parent;
        while (p != null && (includeColdParents || p.hotVisible() || !p.hotApplicable())) {
            ancestors.addFirst(p);
            p = p.parent;
        }
        if (!includeColdParents) {
            p = (TCNode)ancestors.getFirst();
            while (!p.hotApplicable()) {
                ancestors.removeFirst();
                p = (TCNode)ancestors.getFirst();
            }
        }
        return ancestors;
    }

    public static IRfNamedElement adjustInterfaceWithModport(IRfNamedElement signalType, IRfPortElement connectedPort) {
        if (signalType instanceof IRfDesignElement && DesignUtils.getDesignKind(signalType) == IRfNamedElement.ElementKind.VLOG_INTERFACE && connectedPort.isGenericModportPort()) {
            String modportName = connectedPort.getGenericModportName();
            if (modportName == null) {
                return null;
            }
            IRfModportElement modportType = ((IRfDesignElement)signalType).getModportWithPrefix(modportName, 1);
            if (modportType == null) {
                return null;
            }
            return modportType;
        }
        return signalType;
    }

    public static TCNode makeDesignHierarchyElabMode(IRfSingleLangProject rfProject, ElementPath dhTopElementPath, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        if (rfProject == null || dhTopElementPath == null) {
            return null;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return null;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return null;
        }
        IDVTElementWrapper rootWrapper = TCUtils.buildDHElabMode(dhTopElementPath, dummyPortMap, memory);
        if (rootWrapper == null) {
            return null;
        }
        return rootWrapper.getRfElement(TCNode.class);
    }

    public static IDVTElementWrapper buildDHElabMode(ElementPath rootPath, final Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap, IELMemory memory) {
        if (rootPath == null || memory == null) {
            return null;
        }
        IDHNodeFactory<TCWrapperAdapter> factory = new IDHNodeFactory<TCWrapperAdapter>(){

            @Override
            public TCWrapperAdapter create(IRfNamedElement element) {
                TCNode node = TCNode.of(element, dummyPortMap);
                return new TCWrapperAdapter(node);
            }

            @Override
            public boolean allowEmptyGenerateBlocks() {
                return true;
            }
        };
        ELInstance rootElInstance = memory.instanceFor(rootPath);
        if (rootElInstance == null) {
            return null;
        }
        IDVTElementWrapper rootWrapper = TCUtils.createTCNodeWrapperNewElab(rootElInstance, (IDHNodeFactory<? extends IDVTElementWrapper>)factory);
        if (rootWrapper == null) {
            return null;
        }
        HashMap<ElementPath, IDVTElementWrapper> wrappersByElementPath = new HashMap<ElementPath, IDVTElementWrapper>();
        wrappersByElementPath.put(rootPath, rootWrapper);
        Map<ElementPath, ELInstance> subtreeOf = memory.subtreeOf(rootPath, false);
        if (subtreeOf == null || subtreeOf.isEmpty()) {
            return rootWrapper;
        }
        for (Map.Entry<ElementPath, ELInstance> entry : subtreeOf.entrySet()) {
            IDVTElementWrapper parentWrapper;
            ElementPath parentPath;
            ELInstance elInstance = entry.getValue();
            ElementPath elementPath = entry.getKey();
            IDVTElementWrapper childWrapper = TCUtils.createTCNodeWrapperNewElab(elInstance, (IDHNodeFactory<? extends IDVTElementWrapper>)factory);
            if (childWrapper == null || (parentPath = ElementPath.upperPathOf(elementPath)) == null || parentPath.isEmpty() || (parentWrapper = (IDVTElementWrapper)wrappersByElementPath.get(parentPath)) == null) continue;
            childWrapper.setParent(parentWrapper);
            parentWrapper.addChild(childWrapper);
            wrappersByElementPath.put(elementPath, childWrapper);
        }
        return rootWrapper;
    }

    public static IDVTElementWrapper createTCNodeWrapperNewElab(ELInstance instance, IDHNodeFactory<? extends IDVTElementWrapper> factory) {
        if (factory == null || instance == null) {
            return null;
        }
        IRfInstanceElement element = instance.getDescription();
        if (element == null) {
            return null;
        }
        IRfNamedElement designElement = instance.getBinding(false);
        if (!(designElement instanceof IRfDesignElement)) {
            return null;
        }
        IDVTElementWrapper childWrapper = factory.create(element);
        if (!(childWrapper instanceof TCWrapperAdapter)) {
            return null;
        }
        childWrapper.setInstanceType((IRfDesignElement)designElement);
        TCNode chidlTCNode = childWrapper.getRfElement(TCNode.class);
        if (chidlTCNode == null) {
            return childWrapper;
        }
        if (element instanceof DummyInstance && ((DummyInstance)element).isGenerateInstance()) {
            chidlTCNode.setLabel(((DummyInstance)element).getName());
        }
        ElementPath elementPath = instance.getHierarchyPath();
        if (element instanceof IRfInstanceElement && element.isArray() && elementPath != null && !elementPath.isEmpty()) {
            chidlTCNode.setLabel(elementPath.lastSegment());
        }
        return childWrapper;
    }

    public static IELMemory getELMemory(TCNode topNode) {
        if (topNode == null) {
            return null;
        }
        IRfNamedElement namedElement = topNode.namedElement;
        if (namedElement == null) {
            return null;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return RfMixedLangManager.getInstance().getELMemory(rfProject.getProject());
    }

    public static class TCBundle {
        public final ExecutorService executor;
        public final TCOperation traceOperation;
        public final TCEndSet ends;
        public final TCPathChain causedBy;
        public final Set<TCConfiguration> configurations;
        public final Set<LFConverterOptions> converterOptions;
        public final Set<HidFlatteningOption> portConnectionHidFlattening;
        public final Set<HidFlatteningOption> assignHidFlattening;
        public final IProgressMonitor monitor;
        public final IDVTJob updateJob;
        public final Queue<TCPathPoint> boundary;
        public final Queue<TCPathPoint> extendedBoundary;
        public final TCPathRedundance redundance;

        public TCBundle(ExecutorService executor, TCOperation traceOperation, TCEndSet sourcesOrDestinations, TCPathChain causedBy, Queue<TCPathPoint> boundary, Queue<TCPathPoint> extendedBoundary, TCPathRedundance redundance, Set<TCConfiguration> configurations, Set<LFConverterOptions> converterOptions, Set<HidFlatteningOption> commonHidFlattening, Set<HidFlatteningOption> assignAndPortExpressionHidFlattening, IProgressMonitor monitor, IDVTJob updateJob) {
            this.executor = executor;
            this.traceOperation = traceOperation != null ? traceOperation : TCOperation.DRIVE;
            this.ends = sourcesOrDestinations != null ? sourcesOrDestinations : new TCEndSet();
            this.causedBy = causedBy != null ? causedBy : new TCPathChain();
            this.boundary = boundary != null ? boundary : new ArrayDeque();
            this.extendedBoundary = extendedBoundary;
            this.configurations = configurations != null ? configurations : EnumSet.noneOf(TCConfiguration.class);
            this.converterOptions = converterOptions != null ? converterOptions : TCUtils.getConverterOptionsFromConfiguration(configurations);
            this.portConnectionHidFlattening = commonHidFlattening != null ? commonHidFlattening : DesignUtils.PORT_CONNECTION_HID_FLATTENING;
            this.assignHidFlattening = assignAndPortExpressionHidFlattening != null ? assignAndPortExpressionHidFlattening : DesignUtils.ASSIGN_HID_FLATTENING;
            this.redundance = redundance != null ? redundance : new TCPathRedundance();
            this.monitor = monitor;
            this.updateJob = updateJob;
        }
    }
}

