/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.trace.connections.TCEditorJob;
import ro.amiq.dvt.ui.trace.connections.TCJob;
import ro.amiq.dvt.ui.trace.connections.TCViewMessages;
import ro.amiq.dvt.ui.trace.connections.WhyViewElement;
import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCNodeSignalPair;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsBatch;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsCommon;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TCTreeElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;

public interface TCViewUtils
extends TCViewUtilsCommon {
    public static final int START_WHY_NODE_COLOR = 9;
    public static final int START_TRACE_NODE_COLOR = 9;
    public static final int SELECTED_WHY_NODE_COLOR = 3;
    public static final int SELECTED_WHY_PORT_COLOR = 3;
    public static final String DVT_PORTS_VIEW_FACTORY_EXTENSION_POINT_ID = "ro.amiq.dvt.portsViewFactory";
    public static final String DVT_PORTS_VIEW_FACTORY_CONTRIBUTOR_ELEMENT = "portsViewFactory";
    public static final int NOF_SIGNALS_SHOWN = 10;
    public static final String ELLIPSIS = "...";
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$ui$trace$connections$utils$TCOperation;
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$ui$trace$connections$utils$TCViewUtilsBatch$TCEndPointKind;

    static {
        $SWITCH_TABLE$ro$amiq$dvt$ui$trace$connections$utils$TCViewUtilsBatch$TCEndPointKind = TCViewUtils.$SWITCH_TABLE$ro$amiq$dvt$ui$trace$connections$utils$TCViewUtilsBatch$TCEndPointKind();
        $SWITCH_TABLE$ro$amiq$dvt$ui$trace$connections$utils$TCOperation = TCViewUtils.$SWITCH_TABLE$ro$amiq$dvt$ui$trace$connections$utils$TCOperation();
    }

    public static String getTraceTextFromOperation(TCOperation traceOperation) {
        switch (traceOperation) {
            case DRIVE_AND_LOAD: {
                return TCViewMessages.fTraceDriveAndLoadText;
            }
            case DRIVE: {
                return TCViewMessages.fTraceDriveText;
            }
            case LOAD: {
                return TCViewMessages.fTraceLoadText;
            }
        }
        return "";
    }

    public static void popDialog(int messageType, String dialogMessage) {
        ViewsUtils.popOKDialog(messageType, TCViewMessages.fJobText, dialogMessage);
    }

    public static boolean shouldContinueWithTraceOperation(TraceMessageDialogType type) {
        Job[] allJobs = Job.getJobManager().find(null);
        ArrayList<Job> traceJobs = new ArrayList<Job>();
        Job[] jobArray = allJobs;
        int n = allJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getName().startsWith(TCViewMessages.fJobText)) {
                traceJobs.add(job);
            }
            ++n2;
        }
        if (traceJobs.isEmpty()) {
            return true;
        }
        MessageDialog ms = null;
        String messageDialogText = "A Trace Connections operation is already in progress.";
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (type == TraceMessageDialogType.QUESTION) {
            messageDialogText = String.valueOf(messageDialogText) + " Do you want to stop it and start a new one?";
            ms = new MessageDialog(shell, "", null, messageDialogText, 2, new String[]{"No", "Yes"}, 0);
        } else {
            ms = new MessageDialog(shell, "", null, messageDialogText, 2, new String[]{"Ok"}, 0);
        }
        int option = 1;
        if (!TestHelper.isTestMode()) {
            option = ms.open();
        }
        if (option == 1) {
            for (Job job : traceJobs) {
                if (job == null || job.getState() == 0) continue;
                job.cancel();
            }
            return true;
        }
        return option != 0 && option != -1;
    }

    public static String getPrefixForTraceOperation(TCOperation operation) {
        if (operation == null) {
            return "";
        }
        switch (operation) {
            case DRIVE: {
                return "TraceDrivePort.";
            }
            case LOAD: {
                return "TraceLoadPort.";
            }
            case DRIVE_AND_LOAD: {
                return "TraceDriveAndLoadPort.";
            }
        }
        return "";
    }

    public static ImageDescriptor getImageForTraceOperation(TCOperation operation) {
        if (operation == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        switch (operation) {
            case DRIVE: {
                return DVTImages.TRACE_DRIVE;
            }
            case LOAD: {
                return DVTImages.TRACE_LOAD;
            }
            case DRIVE_AND_LOAD: {
                return DVTImages.TRACE_DRIVE_AND_LOAD;
            }
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static IDVTElementWrapper getWrapperFromTreeSelection(TreeItem[] selection) {
        if (selection == null || selection.length != 1) {
            return null;
        }
        TreeItem item = selection[0];
        if (item == null || item.isDisposed()) {
            return null;
        }
        Object data = item.getData();
        if (!(data instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)data;
    }

    public static WhyViewElement getWhyViewElementFromWrapper(IDVTElementWrapper selection) {
        if (selection == null) {
            return null;
        }
        Object elem = selection.getRfElement();
        if (!(elem instanceof WhyViewElement)) {
            return null;
        }
        return (WhyViewElement)elem;
    }

    public static TCNode getTraceNode(IDVTElementWrapper element) {
        return element != null ? (TCNode)element.getAdapter(TCNode.class) : null;
    }

    public static TCNodeSignalPair getTraceNodeSignalPair(IDVTElementWrapper element) {
        return element == null ? null : (TCNodeSignalPair)element.getAdapter(TCNodeSignalPair.class);
    }

    public static TCNode[] getPathFromModelRoot(TCNode node, UpdateJob updateJob) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("Cannot trace path from mode root for NULL node");
        }
        if (ViewsUtils.isCanceled(updateJob)) {
            return null;
        }
        ArrayDeque<TCNode> deque = new ArrayDeque<TCNode>();
        while (node != null) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return null;
            }
            deque.addFirst(node);
            node = node.parent;
        }
        return deque.toArray(new TCNode[0]);
    }

    public static ElementPath getInstancePath(TCNode node) {
        if (node == null) {
            return ElementPath.EMPTY_PATH;
        }
        String name = "";
        IRfNamedElement nodeElement = node.namedElement;
        name = nodeElement != null ? nodeElement.getName() : "";
        return ElementPath.join(node.parent != null ? TCViewUtils.getInstancePath(node.parent) : null, name);
    }

    public static ImageDescriptor getEndKindOverlay(TCViewUtilsBatch.TCEndPointKind endKind) {
        if (endKind == null) {
            return null;
        }
        switch (endKind) {
            case SOURCE: {
                return DVTImages.OVR_TARGET_RED;
            }
            case DESTINATION: {
                return DVTImages.OVR_TARGET_GREEN;
            }
            case MIXED: {
                return DVTImages.OVR_TARGET_MIXED;
            }
        }
        return null;
    }

    public static Image getEndKindDecoratedImage(Image image, TCViewUtilsBatch.TCEndPointKind endKind) {
        if (image == null || endKind == null) {
            return image;
        }
        ImageDescriptor overImageDescriptor = TCViewUtils.getEndKindOverlay(endKind);
        if (overImageDescriptor == null) {
            return image;
        }
        return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(image, overImageDescriptor, 0));
    }

    public static void startTCJobWithChecks(IRfNamedElement conn, ElementPath partialInstancePath, boolean matchPrefix, boolean forceShowDiagramAll, IProject project, TCOperation traceOperation) {
        IRfNamedElement entity = TCViewUtils.getModuleOrEntityWithChecks(conn);
        if (entity == null) {
            return;
        }
        TCJob job = new TCJob(conn, entity, partialInstancePath, matchPrefix, forceShowDiagramAll, project, traceOperation);
        job.schedule(0L);
    }

    public static void startTCEditorJobWithChecks(IRfNamedElement conn, ElementPath partialInstancePath, boolean matchPrefix, boolean forceShowDiagramAll, IProject project, TCOperation traceOperation) {
        IRfNamedElement entity = TCViewUtils.getModuleOrEntityWithChecks(conn);
        if (entity == null) {
            return;
        }
        TCEditorJob job = new TCEditorJob(conn, entity, partialInstancePath, matchPrefix, forceShowDiagramAll, project, traceOperation);
        job.schedule(0L);
    }

    public static IRfNamedElement getModuleOrEntityWithChecks(IRfNamedElement conn) {
        if (!TCViewUtils.shouldContinueWithTraceOperation(TraceMessageDialogType.INFORMATION)) {
            return null;
        }
        if (conn == null) {
            TCViewUtils.popDialog(2, TCViewMessages.fIncorrectSignalMessage);
            return null;
        }
        IRfNamedElement entity = TCViewUtilsCommon.getModuleOrEntity(conn);
        if (entity == null) {
            TCViewUtils.popDialog(2, TCViewMessages.fIncorrectSignalMessage);
            return null;
        }
        return entity;
    }

    public static IRfNamedElement getModuleOrEntity(IRfNamedElement tracedConn) {
        if (tracedConn instanceof HierarchicalElement) {
            tracedConn = ((HierarchicalElement)tracedConn).getFirstSegment();
        }
        if (tracedConn == null) {
            return null;
        }
        IRfScopeElement enclosingScope = tracedConn.getEnclosingScope();
        if (!(enclosingScope instanceof IRfNamedElement)) {
            return null;
        }
        IRfNamedElement elem = (IRfNamedElement)enclosingScope;
        IRfNamedElement.ElementKind designElementKind = DesignUtils.getDesignKind(elem);
        return DesignUtils.isValidDesignKind(designElementKind) ? elem : null;
    }

    public static ElementPath getCurrentBreadcrumb(boolean stripRootSegment) {
        BreadcrumbInput breadcrumbInput;
        block5: {
            IEditorPart editorPart;
            block4: {
                try {
                    editorPart = DVTFileUtils.getInstance().getActiveEditor();
                    if (editorPart instanceof DDiagramEditor) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, (DDiagramEditor)editorPart);
            if (breadcrumbInput != null) break block5;
            return null;
        }
        return breadcrumbInput.getElementPath(stripRootSegment);
    }

    public static String getCopyHierarchyName(TCNode node, boolean isVHDL) {
        if (node == null) {
            return "";
        }
        IRfNamedElement element = node.namedElement;
        if (element == null) {
            return "";
        }
        return DHViewUtils.getCopyHierarchyName(element, isVHDL);
    }

    public static String pathToRoot(TCNode node, String separator, ViewsUtils.ITreePathAccessor<TCNode> acc) {
        DVTStringBuilder pathBuilder = new DVTStringBuilder();
        TCViewUtils.pathToRootRecursive(node, pathBuilder, separator, acc);
        if (pathBuilder.length() == 0) {
            return "";
        }
        return pathBuilder.toString();
    }

    public static void pathToRootRecursive(TCNode node, DVTStringBuilder path, String separator, ViewsUtils.ITreePathAccessor<TCNode> acc) {
        if (node == null || acc == null) {
            return;
        }
        String text = acc.getNameForPath(node);
        if (text == null || text.isEmpty()) {
            return;
        }
        if (path.length() != 0) {
            path.prepend(separator);
        }
        path.prepend(text);
        TCViewUtils.pathToRootRecursive(node.parent, path, separator, acc);
    }

    public static TCTreeElementWrapper makeFullViewTree(TCNode node, UpdateJob updateJob) {
        if (node == null) {
            throw new IllegalArgumentException("Can't make a Port Connections View Tree from NULL model.");
        }
        if (ViewsUtils.isCanceled(updateJob)) {
            return null;
        }
        TCNode modelRoot = TCUtils.getNodeRoot(node);
        TCTreeElementWrapper dummyRoot = new TCTreeElementWrapper(null, null);
        TCTreeElementWrapper visibleRoot = new TCTreeElementWrapper(modelRoot, dummyRoot);
        dummyRoot.addChild(visibleRoot);
        TCViewUtils.expandWrapperSubtree(visibleRoot, true, updateJob);
        return dummyRoot.hasChildren() ? (TCTreeElementWrapper)dummyRoot.getChildren().get(0) : null;
    }

    public static void expandWrapperSubtree(TCTreeElementWrapper root, boolean includeColdNodes, UpdateJob updateJob) {
        ArrayDeque<TCTreeElementWrapper> queue = new ArrayDeque<TCTreeElementWrapper>();
        queue.add(root);
        while (!queue.isEmpty()) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            TCTreeElementWrapper crt = (TCTreeElementWrapper)queue.remove();
            TCNode tracePortsNode = crt.getNode();
            if (tracePortsNode == null) {
                return;
            }
            for (TCNode child : tracePortsNode.getChildren()) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return;
                }
                if (!includeColdNodes && !child.hotVisible() && child.hotApplicable()) continue;
                TCTreeElementWrapper childWrapper = new TCTreeElementWrapper(child, crt);
                crt.addChild(childWrapper);
                queue.add(childWrapper);
            }
        }
    }

    public static TCTreeElementWrapper makeHotViewTree(TCNode traceStart, boolean includeColdParents, UpdateJob updateJob) {
        TCTreeElementWrapper dummyRoot;
        if (traceStart == null) {
            throw new IllegalArgumentException("Can't make Trace Connections View Tree from NULL model");
        }
        if (!traceStart.hotVisible()) {
            throw new IllegalArgumentException("Can't make HOT Trace Connections View Tree from COLD start node");
        }
        Deque<TCNode> ancestors = TCUtils.getAncestors(traceStart, includeColdParents);
        TCTreeElementWrapper leaf = dummyRoot = new TCTreeElementWrapper(null, null);
        for (TCNode p : ancestors) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return null;
            }
            TCTreeElementWrapper child = new TCTreeElementWrapper(p, leaf);
            leaf.addChild(child);
            leaf = child;
        }
        TCViewUtils.expandWrapperSubtree(leaf, false, updateJob);
        return dummyRoot.hasChildren() ? (TCTreeElementWrapper)dummyRoot.getChildren().get(0) : null;
    }

    public static List<IDVTElementWrapper> makeHotViewList(TCNode traceStart, TCPathPoint startPathPoint, TCEndSet sources, TCEndSet destinations, UpdateJob updateJob) {
        if (traceStart == null) {
            throw new IllegalArgumentException("Can't make Trace Connections View list from NULL model");
        }
        if (!traceStart.hotVisible()) {
            throw new IllegalArgumentException("Can't make HOT Trace Connections View list from COLD start node");
        }
        ArrayDeque<TCNode> queue = new ArrayDeque<TCNode>();
        queue.add(traceStart);
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>(4);
        while (!queue.isEmpty()) {
            if (ViewsUtils.isCanceled(updateJob)) {
                return result;
            }
            TCNode node = (TCNode)queue.remove();
            if (node.hotVisible() && TCViewUtilsBatch.getEndNodeKind(node, sources, destinations, null) != null) {
                List<IRfNamedElement> hotSignals = node.getHotSignals();
                for (IRfNamedElement hotSignal : hotSignals) {
                    TCViewUtilsBatch.TCEndPointKind signalEndPointKind = TCViewUtilsBatch.getEndPointKind(TCPathPoint.of(node, hotSignal, null), sources, destinations, startPathPoint);
                    if (signalEndPointKind == null || signalEndPointKind == TCViewUtilsBatch.TCEndPointKind.START) continue;
                    result.add(new TCTreeElementWrapper(new TCNodeSignalPair(node, hotSignal, signalEndPointKind)));
                }
            }
            for (TCNode child : node.getChildren()) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return result;
                }
                queue.add(child);
            }
        }
        if (!result.isEmpty()) {
            Collections.sort(result, (first, second) -> {
                TCNodeSignalPair firstElement = first.getRfElement(TCNodeSignalPair.class);
                if (firstElement == null) {
                    return -1;
                }
                TCNodeSignalPair secondElement = second.getRfElement(TCNodeSignalPair.class);
                return firstElement.compareTo(secondElement);
            });
        }
        return result;
    }

    public static String shortenTextInFront(String textValue, int furtherRestriction, Control control) {
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        try {
            int maxWidth = control.getBounds().width - 5 - furtherRestriction;
            int maxExtent = gc.textExtent((String)textValue).x;
            if (maxExtent < maxWidth) {
                gc.dispose();
                String string = textValue;
                return string;
            }
            int length = textValue.length();
            int charsToClip = Math.round(0.95f * (float)length * (1.0f - (float)maxWidth / (float)maxExtent));
            int pivot = 0;
            int end = pivot + charsToClip + 1;
            while (end < length) {
                String s2 = textValue.substring(end, length);
                String s = ELLIPSIS + s2;
                int l = gc.textExtent((String)s).x;
                if (l < maxWidth) {
                    gc.dispose();
                    String string = s;
                    return string;
                }
                ++end;
            }
        }
        finally {
            gc.dispose();
        }
        return textValue;
    }

    public static enum TraceMessageDialogType {
        QUESTION,
        INFORMATION;

    }
}

