/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.trace.connections.utils;

import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;

public interface TCViewUtilsBatch {
    public static TCEndPointKind getEndPointKind(TCPathPoint point, TCEndSet sources, TCEndSet destinations, TCPathPoint startPoint) {
        if (point == null) {
            return null;
        }
        if (point.equals(startPoint)) {
            return TCEndPointKind.START;
        }
        if (sources == null && destinations == null) {
            return null;
        }
        boolean isSource = false;
        boolean isDestination = false;
        if (sources != null) {
            isSource = sources.isEndSignalPoint(point);
        }
        if (destinations != null) {
            isDestination = destinations.isEndSignalPoint(point);
        }
        if (isSource && isDestination) {
            return TCEndPointKind.MIXED;
        }
        if (isSource) {
            return TCEndPointKind.SOURCE;
        }
        if (isDestination) {
            return TCEndPointKind.DESTINATION;
        }
        return null;
    }

    public static TCEndPointKind getEndNodeKind(TCNode node, TCEndSet sources, TCEndSet destinations, TCNode startNode) {
        if (node == null) {
            return null;
        }
        if (node.equals(startNode)) {
            return TCEndPointKind.START;
        }
        if (sources == null && destinations == null) {
            return null;
        }
        boolean isSource = false;
        boolean isDestination = false;
        if (sources != null) {
            isSource = sources.isEndNode(node);
        }
        if (destinations != null) {
            isDestination = destinations.isEndNode(node);
        }
        if (isSource && isDestination) {
            return TCEndPointKind.MIXED;
        }
        if (isSource) {
            return TCEndPointKind.SOURCE;
        }
        if (isDestination) {
            return TCEndPointKind.DESTINATION;
        }
        return null;
    }

    public static enum TCEndPointKind {
        SOURCE,
        DESTINATION,
        MIXED,
        START;

    }
}

