/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.uvmre.commands;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLErrorHandler;

public class UVMElaborationPropertyTester
extends PropertyTester {
    private static final String XML_FILE_EXTENSION = "xml";
    private static final String ELAB_MODEL_TAG = "uvm-elaboration-model";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)receiver;
        String fileExtension = file.getFileExtension();
        if (!XML_FILE_EXTENSION.equals(fileExtension)) {
            return false;
        }
        try {
            IProject project = file.getProject();
            if (project == null) return false;
            if (!project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return false;
            }
            IPath location = file.getLocation();
            if (location == null) {
                return false;
            }
            File xmlFile = location.toFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(XMLErrorHandler.INSTANCE);
            Document document = builder.parse(xmlFile);
            NodeList children = document.getChildNodes();
            int childrenCount = children.getLength();
            int i = 0;
            while (true) {
                if (i >= childrenCount) {
                    return false;
                }
                if (ELAB_MODEL_TAG.equals(children.item(i).getNodeName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }
}

