/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.DVTSelectionChangedEvent;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.DVTHelpListener;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.MenuCommandInstaller;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyPortsView;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class AbstractFilteredView
extends ViewPart
implements IFilterableView,
IPropertyChangeListener,
IDVTView,
ISelectionProvider,
IDVTNotificationsHost {
    public static final String FILTER_BY_NAME = "Filter by: name";
    public static final String FILTER_BY_HIERARCHICAL_NAME = "Filter by: hierarchical name";
    public static final String FILTER_BY_HIERARCHICAL_NAME_PORT = "Filter by: hierarchical name .port";
    public static final String FILTER_BY_HIERARCHICAL_NAME_MEMBER = "Filter by: hierarchical name .member";
    public static final String FILTERED_BY_GUI_FILTERS = "All filtered by Content Filters.";
    public static final String NO_DATA = "No data.";
    public static final String NO_DVT_PROJECT_SELECTED = "[no DVT Project or file selected]";
    public static final List<IDVTElementWrapper> INPUT_SELECT_PROJECT_OR_FILE = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Select a DVT Project or file."));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_LAYERS_VIEW = new ArrayList<IDVTElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Place the editor cursor"));
            this.add(new BasicElementWrapper("on a class/struct, method etc."));
            this.add(new BasicElementWrapper("and press Shift + F3."));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_TYPE_HIERARCHY_VIEW = new ArrayList<IDVTElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Place the editor cursor"));
            this.add(new BasicElementWrapper("on a class/unit/struct etc."));
            this.add(new BasicElementWrapper("and press F4"));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_SEQUENCE_TREE_VIEW = new ArrayList<IDVTElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Place the editor cursor"));
            this.add(new BasicElementWrapper("on a UVM/OVM sequence class"));
            this.add(new BasicElementWrapper("and press Ctrl + Alt + Shift + S"));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_CALL_HIERARCHY_VIEW = new ArrayList<IDVTElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Place the editor cursor"));
            this.add(new BasicElementWrapper("on a function/task"));
            this.add(new BasicElementWrapper("and press Ctrl + Alt + H"));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_DESIGN_HIERARCHY_VIEW = new ArrayList<IDVTElementWrapper>(2){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Select a DVT Project or file,"));
            this.add(new BasicElementWrapper("then click the \"Select Top\" button"));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_DESIGN_HIERARCHY_VIEW_NO_TOP = new ArrayList<IDVTElementWrapper>(2){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Click the \"Select Top\" button or"));
            this.add(new BasicElementWrapper("Place the editor cursor"));
            this.add(new BasicElementWrapper("on a module/entity"));
            this.add(new BasicElementWrapper("and press Shift + F4"));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_VERIFICATION_HIERARCHY_VIEW = INPUT_DESIGN_HIERARCHY_VIEW;
    public static final List<IDVTElementWrapper> INPUT_VERIFICATION_HIERARCHY_NO_TOP = new ArrayList<IDVTElementWrapper>(2){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Click the \"Select Top\" button or"));
            this.add(new BasicElementWrapper("Place the editor cursor"));
            this.add(new BasicElementWrapper("on a UVM based class/unit"));
            this.add(new BasicElementWrapper("and press Shift + F6"));
        }
    };
    public static final List<IDVTElementWrapper> INPUT_TRACE_CONNECTIONS_VIEW = new ArrayList<IDVTElementWrapper>(2){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Use the Design Hierarchy View"));
            this.add(new BasicElementWrapper("to trace connections."));
        }
    };
    public static final List<BasicElementWrapper> INPUT_DESIGN_HIERARCHY_PORTS_VIEW = new ArrayList<BasicElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Select an element in the"));
            this.add(new BasicElementWrapper("Design Hierarchy tree"));
            this.add(new BasicElementWrapper("to see its ports."));
        }
    };
    public static final List<BasicElementWrapper> INPUT_TRACE_CONNECTIONS_PORTS_VIEW = new ArrayList<BasicElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Select an element in the"));
            this.add(new BasicElementWrapper("Trace Connections tree"));
            this.add(new BasicElementWrapper("to see its signals."));
        }
    };
    public static final List<BasicElementWrapper> INPUT_TRACE_CONNECTIONS_WHY_VIEW = new ArrayList<BasicElementWrapper>(3){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Right-click on a signal"));
            this.add(new BasicElementWrapper("and select 'Show Path'."));
        }
    };
    public static final List<IDVTElementWrapper> NO_DATA_MESSAGE = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper(AbstractFilteredView.NO_DATA));
        }
    };
    public static final List<IDVTElementWrapper> NO_MATCHES_FOUND = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("No matches found."));
        }
    };
    public static final List<IDVTElementWrapper> NO_RESULTS_MESSAGE = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("No results found."));
        }
    };
    public static final List<IDVTElementWrapper> UPDATE_JOB_MESSAGE_INPUT = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper("Updating..."));
        }
    };
    public static final List<IDVTElementWrapper> GUI_FILTERED_EMPTY_CONTENT = new ArrayList<IDVTElementWrapper>(1){
        private static final long serialVersionUID = 1L;
        {
            this.add(new BasicElementWrapper(AbstractFilteredView.FILTERED_BY_GUI_FILTERS));
        }
    };
    public static final String DEFAULT_FILTER_ID = "default-filter";
    public static final String DEFAULT_TREE_ID = "default-tree";
    private Map<String, TextFilterObject> fTextFilters = new HashMap<String, TextFilterObject>();
    private AtomicBoolean fIsDirty = new AtomicBoolean(false);
    protected int fExpandLevel;
    protected ViewDataContainer fDataContainer;
    protected static boolean fLastSelectInMembersView;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private Composite fControlParent;
    private Composite fNotificationsHostComposite;

    public void init(IViewSite site) throws PartInitException {
        site.setSelectionProvider((ISelectionProvider)this);
        super.init(site);
    }

    public void dispose() {
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        this.fDataContainer = null;
        for (TextFilterObject textFilter : this.fTextFilters.values()) {
            textFilter.dispose();
        }
        this.fTextFilters.clear();
        this.fTextFilters = null;
        this.removeSelectionChangedListener(InspectViewSelectionListener.getInstance());
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts) {
        this.createTextFilter(textFilterId, parent, treeId, searchForPorts, null);
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts, List<String> quickSearchPreferences) {
        this.fTextFilters.put(textFilterId, new TextFilterObject(this, textFilterId, parent, treeId, searchForPorts, quickSearchPreferences));
    }

    protected void setTextFilterMessage(String textFilterId, String message) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterMessage(message);
    }

    protected void setTextFilterSWTBotId(String textFilterId, String id) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterSWTBotId(id);
    }

    protected void setTextFilterPreferences(String textFilterId, List<String> preferences, SelectionListener listener) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setPreferencs(preferences, listener);
    }

    protected void setTextFilterFont(String textFilterId, Font font) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterFont(font);
    }

    protected void initTextFilterSilent(String textFilterId, String text) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.initTextFilterSilent(text);
    }

    private TextFilterObject getTextFilterObject(String textFilterId) {
        if (textFilterId == null) {
            return null;
        }
        if (this.fTextFilters == null) {
            return null;
        }
        return this.fTextFilters.get(textFilterId);
    }

    public Text getTextFilter(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        Text textFilter = textFilterObject.getTextFilter();
        if (textFilter.isDisposed()) {
            return null;
        }
        return textFilter;
    }

    public boolean isFiltered(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    public boolean isFiltered() {
        return this.isFiltered(DEFAULT_FILTER_ID);
    }

    public MenuManager installContextMenuAndSelectionListener(final Control control) {
        if (control == null || control.isDisposed()) {
            return null;
        }
        control.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (control instanceof Table) {
                    fLastSelectInMembersView = true;
                }
                ISelection selection = AbstractFilteredView.this.getSelection(control);
                if (TestHelper.isTestMode() && AbstractFilteredView.this instanceof LazyDesignHierarchyPortsView) {
                    selection = AbstractFilteredView.this.getSelection(AbstractFilteredView.DEFAULT_TREE_ID);
                }
                AbstractFilteredView.this.fireSelectionChanged(new DVTSelectionChangedEvent(AbstractFilteredView.this, selection, event));
            }
        });
        control.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent event) {
            }

            public void focusGained(FocusEvent event) {
                AbstractFilteredView.this.fireSelectionChanged(new DVTSelectionChangedEvent(AbstractFilteredView.this, AbstractFilteredView.this.getSelection(control), null));
            }
        });
        return MenuCommandInstaller.installContextMenu((IWorkbenchPart)this, control);
    }

    public StringMatcher getStringMatcher(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getStringMatcher();
    }

    public void setTextFilterText(String textFilterId, String text) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterText(text);
    }

    public String getTextFilterText(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getTextFilterText();
    }

    public StringMatcher[] getSearchSegments(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return new StringMatcher[0];
        }
        return textFilterObject.getSearchSegments();
    }

    public boolean[] getSearchStrictness(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return new boolean[0];
        }
        return textFilterObject.getSearchTextStrictness();
    }

    public String getSearchPort(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    public void resetTextFilter(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.resetTextFilter(textFilterId);
    }

    public void setTextFilterBackground(String textFilterId, Color color) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterBackground(color);
    }

    public void setTextFilterFocus(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setFocus();
    }

    public boolean isTextFilterFocus(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFocusControl();
    }

    public void setTextFilterSelection(String textFilterId, int start, int end) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setSelection(start, end);
    }

    public IDVTElementWrapper getSelectedWrapper(String treeId) {
        TreeItem[] sel = this.getTree(treeId).getSelection();
        if (sel == null || sel.length == 0 || sel[0].getData() == null) {
            return null;
        }
        if (!(sel[0].getData() instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)sel[0].getData();
    }

    public ListenerList getSelectionChangedListeners() {
        return this.fSelectionChangedListeners;
    }

    public void setSelectionChangedListeners(ListenerList selectionChangedListeners) {
        this.fSelectionChangedListeners = selectionChangedListeners;
    }

    public ISelection getSelection() {
        return this.getSelection(this.getTree(DEFAULT_TREE_ID));
    }

    public ISelection getSelection(String treeId) {
        return this.getSelection(this.getTree(treeId));
    }

    private ISelection getSelection(Control control) {
        if (control instanceof Tree) {
            return this.getSelection((Tree)control);
        }
        if (control instanceof Table) {
            return this.getSelection((Table)control);
        }
        return null;
    }

    private ISelection getSelection(Tree tree) {
        if (tree == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        TreeItem[] treeItemArray = tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i.getData() != null) {
                list.add(i.getData());
            }
            ++n2;
        }
        return new StructuredSelection(list.toArray());
    }

    private ISelection getSelection(Table table) {
        if (table == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        TableItem[] tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            if (i.getData() != null) {
                list.add(i.getData());
            }
            ++n2;
        }
        return new StructuredSelection(list.toArray());
    }

    public void setSelection(ISelection selection) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void testHelpSelectViewItem(TreeItem item, String treeId) {
        this.testHelpSelectViewItem(item, treeId, false);
    }

    public void testHelpSelectViewItem(TreeItem item, String treeId, boolean emulateUserSelection) {
        Tree tree = this.getTree(treeId);
        if (tree == null || tree.isDisposed()) {
            return;
        }
        tree.setSelection(item);
        tree.showSelection();
        tree.notifyListeners(13, (Event)new DVTSyntheticEvent(emulateUserSelection));
    }

    public Composite testHelpGetControlParent() {
        return this.fControlParent;
    }

    protected KeyAdapter getKeyListener(String filterTextId, String treeId) {
        return new CustomKeyAdapter(filterTextId, treeId);
    }

    private void clearExpandLevel(List<IDVTElementWrapper> input) {
        if (input == null) {
            return;
        }
        for (IDVTElementWrapper w : input) {
            w.setExpanded(0);
            this.clearExpandLevel(w.getChildren());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void setFocusOnTree(String treeId) {
        Tree tree = this.getTree(treeId);
        if (tree == null) {
            return;
        }
        tree.setFocus();
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        if (dataContainer == null) {
            return;
        }
        this.fDataContainer = dataContainer;
    }

    @Override
    public IProject getProject() {
        if (this.fDataContainer == null) {
            return null;
        }
        return this.fDataContainer.getProject();
    }

    public HistoryItem getHistoryItem() {
        if (this.fDataContainer == null) {
            return null;
        }
        return this.fDataContainer.getHistoryItem();
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.fDataContainer;
    }

    public void createPartControl(Composite parent) {
        this.createNotificationsHostComposite(parent);
        parent.addHelpListener((HelpListener)DVTHelpListener.getInstance());
        this.createUpperPartControl(this.fControlParent);
        this.customCreatePartControl(this.fControlParent);
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().registerView(this);
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fExpandLevel = -1;
    }

    private void createNotificationsHostComposite(Composite parent) {
        Composite topContainter = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(topContainter);
        if (parent.getLayout() instanceof GridLayout) {
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)topContainter);
        }
        this.fNotificationsHostComposite = new Composite(topContainter, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.fNotificationsHostComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fNotificationsHostComposite);
        this.fControlParent = new Composite(topContainter, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fControlParent);
        if (parent.getLayout() instanceof FillLayout) {
            this.fControlParent.setLayout((Layout)new FillLayout());
        } else if (parent.getLayout() instanceof GridLayout) {
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fControlParent);
        }
    }

    @Override
    public Composite getNotificationsHostComposite() {
        return this.fNotificationsHostComposite;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.fIsDirty.set(isDirty);
    }

    @Override
    public boolean isDirty() {
        return this.fIsDirty.get();
    }

    public void createUpperPartControl(Composite parent) {
    }

    public abstract void customCreatePartControl(Composite var1);

    public abstract Tree getTree(String var1);

    public abstract Object getTreeRootElement(String var1);

    public boolean isViewVisible() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage.isPartVisible((IWorkbenchPart)this);
    }

    protected class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super("Collapse All", 1);
            this.setDescription("Collapse All");
            this.setToolTipText("Collapse All");
            this.setImageDescriptor(DVTImages.COLLAPSE_TREE);
        }

        public void run() {
            AbstractFilteredView.this.fExpandLevel = 0;
            TreeViewContentProvider contentProvider = AbstractFilteredView.this.getExpandableContentProvider();
            if (contentProvider == null) {
                return;
            }
            List<IDVTElementWrapper> input = contentProvider.getInput();
            if (input == null) {
                return;
            }
            AbstractFilteredView.this.clearExpandLevel(input);
            contentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(input), 0);
        }
    }

    class CustomKeyAdapter
    extends KeyAdapter {
        private final String fFilterObjectId;
        private final String fTreeId;

        public CustomKeyAdapter(String filterObjectId, String treeId) {
            this.fFilterObjectId = filterObjectId;
            this.fTreeId = treeId;
        }

        public String getFilterObjectId() {
            return this.fFilterObjectId;
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                AbstractFilteredView.this.gotoSelectedElement(this.fTreeId);
            } else if (event.keyCode == 8) {
                TextFilterObject textFilterObject = AbstractFilteredView.this.fTextFilters.get(this.fFilterObjectId);
                if (textFilterObject == null) {
                    return;
                }
                Text filterText = textFilterObject.getTextFilter();
                if (filterText == null) {
                    return;
                }
                String currentText = filterText.getText();
                filterText.setFocus();
                filterText.setText(currentText.substring(0, Math.max(0, currentText.length() - 1)));
                filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
            } else if (event.character != '\u0000' && (Character.isJavaIdentifierPart(event.character) && event.keyCode != 27 && event.keyCode != 127 || event.character == '*' || event.character == '.' || event.character == '?')) {
                if (event.character != (char)event.keyCode) {
                    return;
                }
                TextFilterObject textFilterObject = AbstractFilteredView.this.fTextFilters.get(this.fFilterObjectId);
                if (textFilterObject == null) {
                    return;
                }
                Text filterText = textFilterObject.getTextFilter();
                if (filterText == null) {
                    return;
                }
                filterText.setText(String.valueOf(filterText.getText()) + event.character);
                filterText.setFocus();
                filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
            } else if (event.keyCode == 0x1000003) {
                Tree tree = AbstractFilteredView.this.getTree(this.fTreeId);
                if (tree == null) {
                    return;
                }
                TreeItem[] selection = tree.getSelection();
                if (selection.length == 0) {
                    return;
                }
                selection[0].setExpanded(false);
                IDVTElementWrapper element = AbstractFilteredView.this.getSelectedWrapper(this.fTreeId);
                if (element != null) {
                    element.setExpanded(-2);
                }
            } else if (event.keyCode == 0x1000004) {
                Tree tree = AbstractFilteredView.this.getTree(this.fTreeId);
                if (tree == null) {
                    return;
                }
                TreeItem[] selection = tree.getSelection();
                if (selection.length == 0) {
                    return;
                }
                selection[0].setExpanded(true);
                IDVTElementWrapper element = AbstractFilteredView.this.getSelectedWrapper(this.fTreeId);
                if (element != null) {
                    element.setExpanded(1);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    protected class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            super("Expand All", 1);
            this.setDescription("Expand All");
            this.setToolTipText("Expand All");
            this.setImageDescriptor(DVTImages.EXPAND_TREE);
        }

        public void run() {
            AbstractFilteredView.this.fExpandLevel = -1;
            TreeViewContentProvider contentProvider = AbstractFilteredView.this.getExpandableContentProvider();
            if (contentProvider == null) {
                return;
            }
            List<IDVTElementWrapper> input = contentProvider.getInput();
            if (input == null) {
                return;
            }
            AbstractFilteredView.this.clearExpandLevel(input);
            contentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(input), -1);
        }
    }
}

