/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.AbstractMembersView;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.SortKind;

public abstract class AbstractFilteredViewWithMembers
extends AbstractFilteredView
implements IRfFilterableTreeAccessor,
IUpdateJobImpl {
    private SashForm fMainSashForm;
    private SashForm fUpperSashForm;
    private Composite fSashChildTree;
    private Composite fSashChildPorts;
    private boolean fShowPortsViewBelow = false;
    private boolean fShowPortsView = true;
    private int[] fSashWeights = new int[]{2, 1};
    private AbstractMembersView portsView;
    private final Action fPortsViewAction = new PortsViewAction();
    private static GridLayout layout = new GridLayout(1, true);
    private static GridLayout twoPartLayout;

    static {
        AbstractFilteredViewWithMembers.layout.marginWidth = 0;
        AbstractFilteredViewWithMembers.layout.marginHeight = 0;
        AbstractFilteredViewWithMembers.layout.verticalSpacing = 0;
        twoPartLayout = new GridLayout(2, false);
        AbstractFilteredViewWithMembers.twoPartLayout.marginWidth = 0;
        AbstractFilteredViewWithMembers.twoPartLayout.marginHeight = 0;
        AbstractFilteredViewWithMembers.twoPartLayout.verticalSpacing = 0;
    }

    private void showPortsView(boolean below) {
        this.fShowPortsView = true;
        this.fShowPortsViewBelow = below;
        this.setShowPortsBelowPreference(below);
        this.setShowPortsPreference(true);
        Composite parent = this.fUpperSashForm.getParent();
        SashForm oldSash = this.fUpperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.fSashWeights = oldWeights;
        }
        this.fUpperSashForm = new SashForm(parent, this.fShowPortsViewBelow ? 512 : 256);
        this.fUpperSashForm.setLayout((Layout)twoPartLayout);
        this.fUpperSashForm.setLayoutData((Object)new GridData(1808));
        this.fSashChildTree.setParent((Composite)this.fUpperSashForm);
        if (this.fSashChildPorts == null) {
            this.fSashChildPorts = new Composite((Composite)this.fUpperSashForm, 0);
            this.fSashChildPorts.setLayout((Layout)layout);
            this.fSashChildPorts.setFont(this.fMainSashForm.getFont());
            this.fSashChildPorts.setLayoutData((Object)new GridData(1808));
            this.portsView = this.makePortsViewInstance();
            this.portsView.initAndShow(this.fSashChildPorts);
            this.fSashChildPorts.layout();
            this.fUpperSashForm.setWeights(this.fSashWeights);
        } else {
            this.fSashChildPorts.setParent((Composite)this.fUpperSashForm);
        }
        oldSash.dispose();
        parent.layout();
        IDVTElementWrapper selection = this.getSelectedWrapper("default-tree");
        this.portsView.updateMembers(selection, this.getSearchPort("default-filter"), this.getSortKind());
    }

    protected abstract AbstractMembersView makePortsViewInstance();

    protected abstract SortKind getSortKind();

    private void hidePortsView() {
        this.fShowPortsView = false;
        this.setShowPortsPreference(false);
        int[] oldWeights = this.fUpperSashForm.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.fSashWeights = oldWeights;
        }
        if (this.fSashChildPorts != null && !this.fSashChildPorts.isDisposed()) {
            this.fSashChildPorts.dispose();
        }
        this.fSashChildPorts = null;
        if (this.hasPortsView()) {
            this.portsView.dispose();
        }
        this.portsView = null;
        this.fUpperSashForm.setWeights(new int[]{1});
        this.fUpperSashForm.layout();
    }

    protected boolean hasPortsView() {
        return this.fShowPortsView && this.portsView != null;
    }

    protected void cleanPortsView(boolean showEmptyMessage) {
        if (this.hasPortsView()) {
            this.portsView.cleanView(showEmptyMessage);
        }
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)layout);
        this.fMainSashForm = new SashForm(parent, 512);
        this.fMainSashForm.setLayout((Layout)layout);
        this.fMainSashForm.setFont(parent.getFont());
        this.fMainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)this.fMainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)layout);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        this.fUpperSashForm = new SashForm(fUpperSashFormComposite, this.fShowPortsViewBelow ? 512 : 256);
        this.fUpperSashForm.setLayout((Layout)twoPartLayout);
        this.fUpperSashForm.setLayoutData((Object)new GridData(1808));
        this.fSashChildTree = new Composite((Composite)this.fUpperSashForm, 0);
        this.fSashChildTree.setLayout((Layout)layout);
        this.fSashChildTree.setLayoutData((Object)new GridData(1808));
        this.createTreeViewPart(this.fSashChildTree);
        this.fShowPortsView = this.getShowPortsPreference();
        this.fShowPortsViewBelow = this.getShowPortsBelowPreference();
        if (this.fShowPortsView) {
            this.showPortsView(this.fShowPortsViewBelow);
        }
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.createViewToolbar(toolbarManager);
    }

    protected abstract boolean getShowPortsBelowPreference();

    protected abstract boolean getShowPortsPreference();

    protected abstract void setShowPortsBelowPreference(boolean var1);

    protected abstract void setShowPortsPreference(boolean var1);

    protected abstract void createTreeViewPart(Composite var1);

    public AbstractMembersView testHelpGetPortsView() {
        return this.portsView;
    }

    public void testHelpShowPortsView() {
        this.showPortsView(false);
    }

    protected void createViewToolbar(IToolBarManager toolbarManager) {
        toolbarManager.add((IAction)this.fPortsViewAction);
    }

    protected void installSelectionListenerForMembers(Tree tree) {
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                fLastSelectInMembersView = false;
                if (!AbstractFilteredViewWithMembers.this.hasPortsView()) {
                    return;
                }
                IDVTElementWrapper selection = AbstractFilteredViewWithMembers.this.getSelectedWrapper("default-tree");
                if (selection == null || selection.getRfElement() instanceof String) {
                    return;
                }
                AbstractFilteredViewWithMembers.this.portsView.updateMembers(selection, AbstractFilteredViewWithMembers.this.getSearchPort("default-filter"), AbstractFilteredViewWithMembers.this.getSortKind());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.hasPortsView() && (this.portsView.isFocused() || fLastSelectInMembersView)) {
            return this.portsView.getSelection();
        }
        return super.getSelection();
    }

    public abstract String getMembersName();

    @Override
    public void stringMatcherUpdated(String treeID) {
        try {
            String textFilterText = this.getTextFilterText("default-filter");
            if (textFilterText != null && textFilterText.contains(".") && !this.hasPortsView()) {
                this.showPortsView(this.fShowPortsViewBelow);
            }
            this.getTree("default-tree").setRedraw(false);
            this.update(null);
            this.getTree("default-tree").setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public AbstractMembersView testGetMembersView() {
        return this.portsView;
    }

    private class PortsViewAction
    extends Action {
        public PortsViewAction() {
            super("Show/Hide " + AbstractFilteredViewWithMembers.this.getMembersName(), 5);
            this.setImageDescriptor(DVTImages.SHOW_HIDE_PORTS);
            this.setMenuCreator(new PortsViewMenuCreator());
        }

        public void run() {
            if (AbstractFilteredViewWithMembers.this.hasPortsView()) {
                AbstractFilteredViewWithMembers.this.hidePortsView();
            } else {
                AbstractFilteredViewWithMembers.this.showPortsView(AbstractFilteredViewWithMembers.this.fShowPortsViewBelow);
            }
            this.setChecked(true);
        }

        public void runWithEvent(Event event) {
            this.setChecked(true);
            super.runWithEvent(event);
            this.setChecked(true);
        }
    }

    private class PortsViewMenuCreator
    implements IMenuCreator {
        private PortsViewMenuCreator() {
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            Menu menu = new Menu(parent);
            Action vertAction = new Action("Show " + AbstractFilteredViewWithMembers.this.getMembersName() + " Below", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    AbstractFilteredViewWithMembers.this.showPortsView(true);
                }
            };
            vertAction.setChecked(AbstractFilteredViewWithMembers.this.fSashChildPorts != null && AbstractFilteredViewWithMembers.this.fShowPortsViewBelow);
            ActionContributionItem vertItem = new ActionContributionItem((IAction)vertAction);
            vertItem.fill(menu, -1);
            Action horizAction = new Action("Show " + AbstractFilteredViewWithMembers.this.getMembersName() + " to the Right", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    AbstractFilteredViewWithMembers.this.showPortsView(false);
                }
            };
            horizAction.setChecked(AbstractFilteredViewWithMembers.this.fSashChildPorts != null && !AbstractFilteredViewWithMembers.this.fShowPortsViewBelow);
            ActionContributionItem horizItem = new ActionContributionItem((IAction)horizAction);
            horizItem.fill(menu, -1);
            Action hideAction = new Action("Hide " + AbstractFilteredViewWithMembers.this.getMembersName(), 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    AbstractFilteredViewWithMembers.this.hidePortsView();
                }
            };
            hideAction.setChecked(AbstractFilteredViewWithMembers.this.fSashChildPorts == null && !AbstractFilteredViewWithMembers.this.fShowPortsView);
            ActionContributionItem hideItem = new ActionContributionItem((IAction)hideAction);
            hideItem.fill(menu, -1);
            return menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

