/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTMembersViewContentProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.IDVTViewWithMembersContributor;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.SortKind;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.comparators.LabelProviderWrapperComparator;
import ro.amiq.dvt.ui.views.comparators.PromoteComparator;
import ro.amiq.dvt.utils.CompositeComparator;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class AbstractMembersView
extends AbstractFilteredView {
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.NO_INFORMATION);
    private AbstractFilteredView fTreeView;
    private TableViewer fTable;
    private IMembersLabelProvider fDefaultLabelProvider = new DVTBaseLabelProvider();
    private IMembersLabelProvider fTableLabelProvider;
    private AtomicBoolean fUpdateFromFilter = new AtomicBoolean(true);
    private StringMatcher fPortToPromote;
    private IDVTElementWrapper selectedElement;
    private SortKind fSortKind;
    private Label fInfoLabel;
    private boolean fContentFilteringEnabled;
    private Label fContentFilteredIndication;
    public MenuManager contextMenuManager;

    public AbstractMembersView(AbstractFilteredView treeView, boolean contentFilteringEnabled) {
        this.fContentFilteringEnabled = contentFilteringEnabled;
        this.fTreeView = treeView;
        if (treeView == null) {
            throw new IllegalArgumentException("The sub-view should have a non-null tree view");
        }
    }

    public void initAndShow(Composite parent) {
        this.setSite(this.fTreeView.getSite());
        this.setSelectionChangedListeners(this.fTreeView.getSelectionChangedListeners());
        this.createPartControl(parent);
    }

    @Override
    public void createUpperPartControl(Composite parent) {
        if (!this.fContentFilteringEnabled) {
            return;
        }
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)container);
        this.fContentFilteredIndication = new Label(container, 0);
        this.fContentFilteredIndication.setEnabled(false);
        this.fContentFilteredIndication.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
        this.fContentFilteredIndication.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fContentFilteredIndication.setToolTipText("Content Filters matched!");
        GridDataFactory.fillDefaults().align(1, 128).grab(false, false).applyTo((Control)this.fContentFilteredIndication);
        this.fInfoLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fInfoLabel);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: name");
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        tableComposite.setLayout((Layout)new FillLayout(256));
        this.fTable = new TableViewer(tableComposite, 268436228);
        this.fTable.setContentProvider((IContentProvider)new DVTMembersViewContentProvider());
        this.fTableLabelProvider = this.fDefaultLabelProvider;
        this.fTable.setLabelProvider((IBaseLabelProvider)this.fTableLabelProvider);
        Control control = this.getControl();
        if (control != null) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    AbstractMembersView.this.gotoSelectedElement(null);
                }
            });
            control.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        }
        if (this.fTable != null) {
            this.contextMenuManager = this.installContextMenuAndSelectionListener((Control)this.fTable.getTable());
        }
    }

    private Control getControl() {
        if (this.fTable == null) {
            return null;
        }
        return this.fTable.getControl();
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(null);
        if (this.getViewContributor(this.selectedElement) == null) {
            return;
        }
        wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.MEMBER_PARENT_WRAPPER, this.selectedElement);
        this.getViewContributor(this.selectedElement).gotoSelectedMember(this.fTreeView.getProject(), wrapper);
    }

    public IDVTElementWrapper getSelectedElement() {
        return this.selectedElement;
    }

    public void updateMembers(IDVTElementWrapper element, String portToPromote, SortKind sortKind) {
        this.selectedElement = element;
        this.computeCurrentLabelProvider();
        this.fPortToPromote = portToPromote == null ? null : ViewsUtils.createCamelCaseOrRegexMatcher(portToPromote, true, false);
        this.fSortKind = sortKind;
        this.showFilteredMembers();
    }

    private void computeCurrentLabelProvider() {
        this.fTableLabelProvider = this.fDefaultLabelProvider;
        if (this.selectedElement == null) {
            return;
        }
        IDVTViewWithMembersContributor viewContributor = this.getViewContributor(this.selectedElement);
        if (viewContributor == null) {
            return;
        }
        IMembersLabelProvider membersViewLabelProvider = viewContributor.getMembersViewLabelProvider();
        if (membersViewLabelProvider == null) {
            return;
        }
        this.fTableLabelProvider = membersViewLabelProvider;
    }

    private void showFilteredMembers() {
        this.fTableLabelProvider.setBoldMatcher(this.fPortToPromote);
        this.fTable.setLabelProvider((IBaseLabelProvider)this.fTableLabelProvider);
        IDVTViewWithMembersContributor viewContributor = this.getViewContributor(this.selectedElement);
        if (viewContributor == null) {
            this.cleanView(true);
            ObjectionManager.getInstance().clearForMembers(this);
            return;
        }
        MembersViewInput input = viewContributor.getMembersInput(this.selectedElement, this.getStringMatcher("default-filter"));
        List<Object> elements = input.getElements();
        if (elements == null) {
            elements = Collections.emptyList();
        }
        if (this.fInfoLabel != null) {
            this.fInfoLabel.setText("");
            DVTBaseLabelProvider elementLabelProvider = viewContributor.getLabelProvider(this.selectedElement);
            if (!(this.selectedElement.getRfElement() instanceof DVTLanguageElement) && elementLabelProvider != null) {
                int nofMembers = elements.size();
                String elementLabel = elementLabelProvider.getText(this.selectedElement);
                String members = ViewsUtils.getUnitName("member", nofMembers, " ", "");
                this.fInfoLabel.setText(String.valueOf(elementLabel) + " [" + nofMembers + members + "]");
            }
        }
        CompositeComparator<IDVTElementWrapper> compositeComparator = new CompositeComparator<IDVTElementWrapper>();
        if (this.fPortToPromote != null) {
            compositeComparator.add(new PromoteComparator(this.fPortToPromote, this.fTableLabelProvider));
        }
        if (this.fSortKind == SortKind.ALPHABETICAL) {
            compositeComparator.add(new LabelProviderWrapperComparator(this.fTableLabelProvider, true));
        } else if (this.fSortKind == SortKind.CATEGORY) {
            compositeComparator.add(viewContributor.getMembersCategoryComparator());
            compositeComparator.add(new LabelProviderWrapperComparator(this.fTableLabelProvider, true));
        }
        Collections.sort(elements, compositeComparator);
        if (this.fContentFilteredIndication != null) {
            this.fContentFilteredIndication.setEnabled(input.isContentFiltered());
        }
        if (elements.isEmpty()) {
            elements = this.selectedElement.getRfElement() instanceof DVTLanguageElement ? this.getHelpMsg() : (input.isContentFiltered() ? AbstractFilteredView.GUI_FILTERED_EMPTY_CONTENT : (this.isFiltered() ? NO_MATCHES_FOUND : this.getNoMembersMsg()));
        }
        this.fTable.setInput(elements);
        this.fTable.setSelection(null);
        ObjectionManager.getInstance().clearForMembers(this);
    }

    protected abstract List<IDVTElementWrapper> getNoMembersMsg();

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        if (!this.fUpdateFromFilter.get()) {
            this.fUpdateFromFilter.set(true);
            return;
        }
        this.showFilteredMembers();
        this.fTable.setSelection(null);
    }

    @Override
    public Tree getTree(String treeId) {
        return null;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return null;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    @Override
    public IDVTElementWrapper getSelectedWrapper(String treeId) {
        StructuredSelection sel = (StructuredSelection)this.getSelection(treeId);
        if (sel == null || sel.size() != 1) {
            return null;
        }
        Object elem = sel.getFirstElement();
        if (!(elem instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)elem;
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.fTable == null || this.fTable.getControl() == null || this.fTable.getControl().isDisposed()) {
            return null;
        }
        return this.fTable.getSelection();
    }

    public void cleanFilter() {
        Text textFilter = this.getTextFilter("default-filter");
        if (this.isFiltered()) {
            this.fUpdateFromFilter.set(false);
            textFilter.setText("");
            textFilter.setMessage("Filter by: name");
            Display d = Display.getCurrent();
            if (d != null) {
                DVTColorUtil.INSTANCE.setBackground((Control)textFilter, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
            }
            this.setFocus();
        }
    }

    public void cleanView(boolean showEmptyMessage) {
        this.selectedElement = null;
        this.fPortToPromote = null;
        this.fTableLabelProvider.setBoldMatcher(this.fPortToPromote);
        if (this.fTable == null || this.fTable.getControl() == null || this.fTable.getControl().isDisposed()) {
            return;
        }
        if (this.fInfoLabel != null) {
            this.fInfoLabel.setText("");
        }
        boolean noMatchesFound = this.isFiltered();
        List elements = this.getHelpMsg();
        if (!showEmptyMessage) {
            elements = new ArrayList<IDVTElementWrapper>();
        }
        if (noMatchesFound) {
            elements = NO_MATCHES_FOUND;
        }
        if (this.fContentFilteredIndication != null) {
            this.fContentFilteredIndication.setEnabled(false);
        }
        this.fTable.setInput((Object)elements);
        this.fTable.setSelection(null);
    }

    @Override
    public void dispose() {
        if (this.fContentFilteredIndication != null && !this.fContentFilteredIndication.isDisposed()) {
            this.fContentFilteredIndication.dispose();
        }
        this.fContentFilteredIndication = null;
        if (this.fInfoLabel != null && !this.fInfoLabel.isDisposed()) {
            this.fInfoLabel.dispose();
        }
        this.fInfoLabel = null;
        this.cleanView(false);
        super.dispose();
    }

    public boolean isFocused() {
        Control control = this.getControl();
        if (control == null) {
            return false;
        }
        return control.isFocusControl();
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    @Override
    public void update(BuildEvents updateEvent) {
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
    }

    public List<?> testHelpGetMembers() {
        return (List)this.fTable.getInput();
    }

    public IMembersLabelProvider testHelpGetLabelProvider() {
        return this.fTableLabelProvider;
    }

    protected abstract IDVTViewWithMembersContributor getViewContributor(IDVTElementWrapper var1);

    protected abstract List<IDVTElementWrapper> getHelpMsg();

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public IDVTView getParentView() {
        return this.fTreeView;
    }
}

