/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class AbstractTreeInformationControl
extends DVTPopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener,
IFilterableView {
    public static final String DEFAULT_TREE_ID = "default-tree";
    public static final String DEFAULT_FILTER_ID = "default-filter";
    private Map<String, TextFilterObject> fTextFilters = new HashMap<String, TextFilterObject>();
    protected IProject fProject;
    protected IPluginConfig fPluginConfig;
    private int fTreeStyle;
    private Tree fTree;
    private TreeViewContentProvider fLazyContentProvider;
    private Composite fViewMenuButtonComposite;
    private IAction fShowViewMenuAction;
    private Composite fTopComposite;

    public AbstractTreeInformationControl(IPluginConfig pluginConfig, Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField, IProject project) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        this.fPluginConfig = pluginConfig;
        this.fProject = project;
        this.fTreeStyle = treeStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite parent) {
        this.fTopComposite = parent;
        this.createTreeViewer(parent, this.fTreeStyle);
        this.fTree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                AbstractTreeInformationControl.this.handleKeyEvent(event);
                if (event.character == '\u001b') {
                    AbstractTreeInformationControl.this.dispose();
                } else if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    AbstractTreeInformationControl.this.gotoSelectedElement(AbstractTreeInformationControl.DEFAULT_TREE_ID);
                } else if (event.keyCode == 8) {
                    TextFilterObject textFilterObject = AbstractTreeInformationControl.this.fTextFilters.get(AbstractTreeInformationControl.DEFAULT_FILTER_ID);
                    if (textFilterObject == null) {
                        return;
                    }
                    Text filterText = textFilterObject.getTextFilter();
                    if (filterText == null) {
                        return;
                    }
                    String currentText = filterText.getText();
                    filterText.setFocus();
                    filterText.setText(currentText.substring(0, Math.max(0, currentText.length() - 1)));
                    filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
                } else if (event.character != '\u0000' && (Character.isJavaIdentifierPart(event.character) && event.keyCode != 27 || event.character == '*' || event.character == '.' || event.character == '?')) {
                    if (event.character != (char)event.keyCode) {
                        return;
                    }
                    TextFilterObject textFilterObject = AbstractTreeInformationControl.this.fTextFilters.get(AbstractTreeInformationControl.DEFAULT_FILTER_ID);
                    if (textFilterObject == null) {
                        return;
                    }
                    Text filterText = textFilterObject.getTextFilter();
                    if (filterText == null) {
                        return;
                    }
                    filterText.setText(String.valueOf(filterText.getText()) + event.character);
                    filterText.setFocus();
                    filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
                } else if (event.keyCode == 0x1000003) {
                    TreeItem[] selection = AbstractTreeInformationControl.this.fTree.getSelection();
                    if (selection.length == 0) {
                        return;
                    }
                    selection[0].setExpanded(false);
                    IDVTElementWrapper element = (IDVTElementWrapper)selection[0].getData();
                    element.setExpanded(-2);
                } else if (event.keyCode == 0x1000004) {
                    TreeItem[] selection = AbstractTreeInformationControl.this.fTree.getSelection();
                    if (selection.length == 0) {
                        return;
                    }
                    selection[0].setExpanded(true);
                    IDVTElementWrapper element = (IDVTElementWrapper)selection[0].getData();
                    element.setExpanded(1);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractTreeInformationControl.this.gotoSelectedElement();
            }
        });
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (AbstractTreeInformationControl.this.fTree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (AbstractTreeInformationControl.this.fTree.equals(e.getSource())) {
                    TreeItem o = AbstractTreeInformationControl.this.fTree.getItem(new Point(e.x, e.y));
                    TreeItem selection = AbstractTreeInformationControl.this.fTree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractTreeInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.addDisposeListener(this);
        return this.fTree;
    }

    public AbstractTreeInformationControl(IPluginConfig pluginConfig, Shell parent, int shellStyle, int treeStyle, IProject project) {
        this(pluginConfig, parent, shellStyle, treeStyle, null, false, project);
    }

    protected void createTreeViewer(Composite parent, int style) {
        this.fTree = new Tree(parent, 0x10000004 | style & 0xFFFFFFFD);
        this.fLazyContentProvider = new TreeViewContentProvider(this.fTree, this.getLabelProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = this.fTree.getItemHeight() * 12;
        this.fTree.setLayoutData((Object)gd);
        this.getShell().setText(this.getTitle());
    }

    protected abstract String getTitle();

    protected abstract DVTBaseLabelProvider getLabelProvider();

    protected void setInputWrappers(List<IDVTElementWrapper> input) {
        if (this.fTree == null) {
            return;
        }
        this.fTree.setRedraw(false);
        this.fLazyContentProvider.setInput(input, -1);
        this.fTree.setRedraw(true);
    }

    @Override
    protected abstract String getId();

    protected boolean hasHeader() {
        return false;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void updateStatusFieldText() {
        this.setInfoText(this.getStatusFieldText());
    }

    protected void handleStatusFieldClicked() {
    }

    protected String getStatusFieldText() {
        return "";
    }

    public abstract void update();

    protected Object getSelectedElement() {
        if (this.fTree == null) {
            return null;
        }
        TreeItem[] sel = this.fTree.getSelection();
        if (sel == null || sel.length == 0) {
            return null;
        }
        return sel[0].getData();
    }

    protected abstract void gotoSelectedElement();

    public void setInformation(String information) {
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean close() {
        if (this.getTextFilterObject(DEFAULT_FILTER_ID) != null) {
            this.getTextFilterObject(DEFAULT_FILTER_ID).dispose();
        }
        if (this.fTree != null && this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        this.fTree = null;
        return super.close();
    }

    public void dispose() {
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fTree = null;
    }

    public boolean hasContents() {
        return this.fTree != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || !this.getPersistSize() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.fTree.isFocusControl() || this.getTextFilterObject(DEFAULT_FILTER_ID).isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter().setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts) {
        this.fTextFilters.put(textFilterId, new TextFilterObject(this, textFilterId, parent, treeId, searchForPorts));
    }

    protected void setTextFilterMessage(String textFilterId, String message) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterMessage(message);
    }

    protected TextFilterObject getTextFilterObject(String textFilterId) {
        if (textFilterId == null) {
            return null;
        }
        return this.fTextFilters.get(textFilterId);
    }

    public StringMatcher[] getSearchSegments(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return new StringMatcher[0];
        }
        return textFilterObject.getSearchSegments();
    }

    public String getSearchPort(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    public boolean[] getSearchStrictness(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return new boolean[0];
        }
        return textFilterObject.getSearchTextStrictness();
    }

    public StringMatcher getStringMatcher(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getStringMatcher();
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.createTextFilter(DEFAULT_FILTER_ID, parent, DEFAULT_TREE_ID, false);
        }
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractTreeInformationControl.this.showDialogMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.createTextFilter(DEFAULT_FILTER_ID, parent, DEFAULT_TREE_ID, false);
        return this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter();
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter(), this.fTree});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.getTextFilterObject(DEFAULT_FILTER_ID).getControl()});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTree});
        }
    }

    protected IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected Tree getTree() {
        return this.fTree;
    }

    public IDVTElementWrapper getSelectedWrapper() {
        TreeItem[] sel = this.getTree().getSelection();
        if (sel == null || sel.length == 0 || sel[0].getData() == null) {
            return null;
        }
        if (!(sel[0].getData() instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)sel[0].getData();
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        this.gotoSelectedElement();
    }

    @Override
    public void setFocusOnTree(String treeId) {
        this.getTree().setFocus();
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        DVTColorUtil.INSTANCE.setBackground((Control)this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter(), this.getBackground());
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.update();
    }

    public void handleKeyEvent(KeyEvent event) {
    }

    protected void setInfoText(String text) {
        super.setInfoText(text);
        if (this.fTopComposite == null) {
            return;
        }
        this.fTopComposite.layout(true);
    }

    protected Color getForeground() {
        if ((this.getShellStyle() & 0x80000) != 0) {
            return DVTColorUtil.INSTANCE.getSystemColor(28);
        }
        return DVTColorUtil.INSTANCE.getSystemColor(24);
    }

    protected Color getBackground() {
        if ((this.getShellStyle() & 0x80000) != 0) {
            return DVTColorUtil.INSTANCE.getSystemColor(29);
        }
        return DVTColorUtil.INSTANCE.getSystemColor(25);
    }
}

