/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.CombGen;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.KPermGen;

public class AbstractWrapperHelper {
    public static boolean equalElement(Object r1, Object r2) {
        boolean equalInst = r1.equals(r2);
        return equalInst;
    }

    public static boolean equalElementType(Object r1, Object r2) {
        boolean equalInst = r1.equals(r2);
        if (equalInst) {
            return true;
        }
        if (r1 instanceof IRfInstanceElement && r2 instanceof IRfInstanceElement) {
            IRfInstanceElement ir1 = (IRfInstanceElement)r1;
            IRfInstanceElement ir2 = (IRfInstanceElement)r2;
            IRfNamedElement design = ir1.getGenericDesign(null);
            return design != null && design.equals(ir2.getGenericDesign(null));
        }
        return false;
    }

    public static boolean equalTreesOrdered1(IDVTElementWrapper t1, IDVTElementWrapper t2) {
        boolean childCountMatch;
        boolean rootMatch = t1.getRfElement().equals(t2.getRfElement());
        if (!rootMatch) {
            return false;
        }
        List c1 = t1.getChildren();
        List c2 = t2.getChildren();
        boolean bl = childCountMatch = c1.size() == c2.size();
        if (!childCountMatch) {
            return false;
        }
        int i = 0;
        while (i < c1.size()) {
            boolean childMatch = AbstractWrapperHelper.equalTreesOrdered1((IDVTElementWrapper)c1.get(i), (IDVTElementWrapper)c2.get(i));
            if (!childMatch) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalTreesOrdered2(IDVTElementWrapper t1, IDVTElementWrapper t2) {
        boolean countMatch;
        List<IDVTElementWrapper> flatT1 = AbstractWrapperHelper.flattenDFS(t1);
        List<IDVTElementWrapper> flatT2 = AbstractWrapperHelper.flattenDFS(t2);
        boolean bl = countMatch = flatT1.size() == flatT2.size();
        if (!countMatch) {
            return false;
        }
        int i = 0;
        while (i < flatT1.size()) {
            boolean nodeMatch = flatT1.get(i).getRfElement().equals(flatT2.get(i).getRfElement());
            if (!nodeMatch) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalTreesUnordered(IDVTElementWrapper t1, IDVTElementWrapper t2) {
        boolean childCountMatch;
        boolean rootMatch = t1.getRfElement().equals(t2.getRfElement());
        if (!rootMatch) {
            return false;
        }
        List c1 = t1.getChildren();
        List c2 = t2.getChildren();
        boolean bl = childCountMatch = c1.size() == c2.size();
        if (!childCountMatch) {
            return false;
        }
        if (c2.isEmpty()) {
            return true;
        }
        KPermGen pkg = new KPermGen(c1.size(), c2.size());
        while (pkg.hasNext()) {
            int[] perm = pkg.next();
            boolean permMatch = true;
            int i = 0;
            while (i < c2.size()) {
                boolean childMatch = AbstractWrapperHelper.equalTreesUnordered((IDVTElementWrapper)c1.get(perm[i]), (IDVTElementWrapper)c2.get(i));
                if (!childMatch) {
                    permMatch = false;
                    break;
                }
                ++i;
            }
            if (!permMatch) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTreeUnorderedHere(IDVTElementWrapper t1, IDVTElementWrapper t2) {
        boolean childCountContains;
        boolean rootMatch = t1.getRfElement().equals(t2.getRfElement());
        if (!rootMatch) {
            return false;
        }
        List c1 = t1.getChildren();
        List c2 = t2.getChildren();
        boolean bl = childCountContains = c1.size() >= c2.size();
        if (!childCountContains) {
            return false;
        }
        if (c2.isEmpty()) {
            return true;
        }
        KPermGen pkg = new KPermGen(c1.size(), c2.size());
        while (pkg.hasNext()) {
            int[] perm = pkg.next();
            boolean permMatch = true;
            int i = 0;
            while (i < c2.size()) {
                boolean childMatch = AbstractWrapperHelper.containsTreeUnorderedHere((IDVTElementWrapper)c1.get(perm[i]), (IDVTElementWrapper)c2.get(i));
                if (!childMatch) {
                    permMatch = false;
                    break;
                }
                ++i;
            }
            if (!permMatch) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTreeOrderedAnywhere(IDVTElementWrapper t1, IDVTElementWrapper t2) {
        if (AbstractWrapperHelper.containsTreeOrderedHere(t1, t2)) {
            return true;
        }
        for (IDVTElementWrapper ch : t1.getChildren()) {
            if (!AbstractWrapperHelper.containsTreeOrderedAnywhere(ch, t2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTreeOrderedHere(IDVTElementWrapper t1, IDVTElementWrapper t2) {
        boolean childCountContains;
        boolean rootMatch = t1.getRfElement().equals(t2.getRfElement());
        if (!rootMatch) {
            return false;
        }
        List c1 = t1.getChildren();
        List c2 = t2.getChildren();
        if (c2 == null || c2.isEmpty()) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        boolean bl = childCountContains = c1.size() >= c2.size();
        if (!childCountContains) {
            return false;
        }
        CombGen pkg = new CombGen(c1.size(), c2.size());
        while (pkg.hasMore()) {
            int[] perm = pkg.getNext();
            boolean permMatch = true;
            int i = 0;
            while (i < c2.size()) {
                boolean childMatch = AbstractWrapperHelper.containsTreeOrderedHere((IDVTElementWrapper)c1.get(perm[i]), (IDVTElementWrapper)c2.get(i));
                if (!childMatch) {
                    permMatch = false;
                    break;
                }
                ++i;
            }
            if (!permMatch) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTreeOrderedHereAccum(IDVTElementWrapper t1, IDVTElementWrapper t2, List<IDVTElementWrapper> list) {
        boolean childCountContains;
        boolean rootMatch = AbstractWrapperHelper.equalElement(t1.getRfElement(), t2.getRfElement());
        if (!rootMatch) {
            return false;
        }
        list.add(t1);
        List c1 = t1.getChildren();
        List c2 = t2.getChildren();
        if (c2 == null || c2.isEmpty()) {
            return true;
        }
        if (c1 == null) {
            list.clear();
            return false;
        }
        boolean bl = childCountContains = c1.size() >= c2.size();
        if (!childCountContains) {
            list.clear();
            return false;
        }
        CombGen pkg = new CombGen(c1.size(), c2.size());
        while (pkg.hasMore()) {
            int[] perm = pkg.getNext();
            boolean permMatch = true;
            int i = 0;
            while (i < c2.size()) {
                boolean childMatch = AbstractWrapperHelper.containsTreeOrderedHereAccum((IDVTElementWrapper)c1.get(perm[i]), (IDVTElementWrapper)c2.get(i), list);
                if (!childMatch) {
                    permMatch = false;
                    break;
                }
                ++i;
            }
            if (!permMatch) continue;
            return true;
        }
        list.clear();
        return false;
    }

    public static List<IDVTElementWrapper> flattenDFS(IDVTElementWrapper t) {
        ArrayList<IDVTElementWrapper> flat = new ArrayList<IDVTElementWrapper>();
        ArrayList<IDVTElementWrapper> S = new ArrayList<IDVTElementWrapper>();
        S.add(t);
        while (!S.isEmpty()) {
            IDVTElementWrapper pop = (IDVTElementWrapper)S.remove(S.size() - 1);
            List children = pop.getChildren();
            if (children != null) {
                S.addAll(children);
            }
            flat.add(pop);
        }
        return flat;
    }

    public static IDVTElementWrapper mintreeRoot(IDVTElementWrapper src, IDVTElementWrapper dst) {
        IDVTElementWrapper p = src;
        while (p != null) {
            IDVTElementWrapper q = dst;
            while (q != null) {
                if (p == q) {
                    return p;
                }
                q = q.getParent();
            }
            p = p.getParent();
        }
        throw new RuntimeException("Source and Destination must be on the same tree");
    }

    public static IDVTElementWrapper makePattern(IDVTElementWrapper src, IDVTElementWrapper dst) {
        BasicElementWrapper result;
        int dstIdx;
        IDVTElementWrapper root = AbstractWrapperHelper.mintreeRoot(src, dst);
        BasicElementWrapper lastSrcPattern = null;
        IDVTElementWrapper p = src;
        while (true) {
            BasicElementWrapper pattern = new BasicElementWrapper(p.fElement);
            if (lastSrcPattern != null) {
                pattern.addChild(lastSrcPattern);
            }
            lastSrcPattern = pattern;
            if (p == root) break;
            p = p.getParent();
        }
        if (lastSrcPattern == null) {
            throw new RuntimeException("Source problems");
        }
        BasicElementWrapper lastDstPattern = null;
        IDVTElementWrapper p2 = dst;
        while (true) {
            BasicElementWrapper pattern = new BasicElementWrapper(p2.fElement);
            if (lastDstPattern != null) {
                pattern.addChild(lastDstPattern);
            }
            lastDstPattern = pattern;
            if (p2 == root) break;
            p2 = p2.getParent();
        }
        if (lastDstPattern == null) {
            throw new RuntimeException("Dest problems");
        }
        int srcIdx = root.getChildren().indexOf(src);
        if (srcIdx < (dstIdx = root.getChildren().indexOf(dst))) {
            lastSrcPattern.getChildren().addAll(lastDstPattern.getChildren());
            result = lastSrcPattern;
        } else {
            lastDstPattern.getChildren().addAll(lastSrcPattern.getChildren());
            result = lastDstPattern;
        }
        return result;
    }

    public static List<IDVTElementWrapper> mintreeMatch(IDVTElementWrapper src, IDVTElementWrapper dst) {
        ArrayList<IDVTElementWrapper> occurences = new ArrayList<IDVTElementWrapper>();
        IDVTElementWrapper root = AbstractWrapperHelper.mintreeRoot(src, dst);
        IDVTElementWrapper p = src;
        while (p != root) {
            occurences.add(p);
            p = p.getParent();
        }
        occurences.add(root);
        p = dst;
        while (p != root) {
            occurences.add(p);
            p = p.getParent();
        }
        return occurences;
    }

    public static List<IDVTElementWrapper> directMatch(IDVTElementWrapper t, IDVTElementWrapper src, IDVTElementWrapper dst) {
        IDVTElementWrapper pattern = AbstractWrapperHelper.makePattern(src, dst);
        return AbstractWrapperHelper.directMatch(t, pattern);
    }

    public static List<IDVTElementWrapper> directMatch(IDVTElementWrapper t, IDVTElementWrapper treePattern) {
        ArrayList<IDVTElementWrapper> occurences = new ArrayList<IDVTElementWrapper>();
        List<IDVTElementWrapper> flat = AbstractWrapperHelper.flattenDFS(t);
        ArrayList<IDVTElementWrapper> accum = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper node : flat) {
            accum.clear();
            if (!AbstractWrapperHelper.containsTreeOrderedHereAccum(node, treePattern, accum)) continue;
            occurences.addAll(accum);
        }
        return occurences;
    }

    public static List<IDVTElementWrapper> allMatch(IDVTElementWrapper t, IDVTElementWrapper src, IDVTElementWrapper dst) {
        IDVTElementWrapper pattern = AbstractWrapperHelper.makePattern(src, dst);
        List<IDVTElementWrapper> flatPatterns = AbstractWrapperHelper.flattenDFS(pattern);
        return AbstractWrapperHelper.allMatch(t, flatPatterns);
    }

    public static List<IDVTElementWrapper> allMatch(IDVTElementWrapper t, List<IDVTElementWrapper> nodePatterns) {
        ArrayList<IDVTElementWrapper> occurences = new ArrayList<IDVTElementWrapper>();
        List<IDVTElementWrapper> flat = AbstractWrapperHelper.flattenDFS(t);
        for (IDVTElementWrapper node : flat) {
            for (IDVTElementWrapper nodePattern : nodePatterns) {
                if (!AbstractWrapperHelper.equalElementType(node.getRfElement(), nodePattern.getRfElement())) continue;
                occurences.add(node);
            }
        }
        return occurences;
    }

    public static List<IDVTElementWrapper> indirectMatch(IDVTElementWrapper t, IDVTElementWrapper src, IDVTElementWrapper dst) {
        IDVTElementWrapper pattern = AbstractWrapperHelper.makePattern(src, dst);
        return AbstractWrapperHelper.indirectMatch(t, pattern);
    }

    public static List<IDVTElementWrapper> indirectMatch(IDVTElementWrapper t, IDVTElementWrapper treePattern) {
        ArrayList<IDVTElementWrapper> occurences = new ArrayList<IDVTElementWrapper>();
        List<IDVTElementWrapper> flatPatterns = AbstractWrapperHelper.flattenDFS(treePattern);
        List<IDVTElementWrapper> all = AbstractWrapperHelper.allMatch(t, flatPatterns);
        List<IDVTElementWrapper> direct = AbstractWrapperHelper.directMatch(t, treePattern);
        for (IDVTElementWrapper p : all) {
            boolean found = false;
            for (IDVTElementWrapper q : direct) {
                if (p != q) continue;
                found = true;
                break;
            }
            if (found) continue;
            occurences.add(p);
        }
        return occurences;
    }

    public static <T extends IDVTElementWrapper> T duplicateTree(T t) {
        if (t == null) {
            return null;
        }
        IDVTElementWrapper root = t.create();
        ArrayList S = new ArrayList();
        ArrayList<IDVTElementWrapper> R = new ArrayList<IDVTElementWrapper>();
        S.add(t);
        R.add(root);
        while (!S.isEmpty()) {
            IDVTElementWrapper pop = (IDVTElementWrapper)S.remove(S.size() - 1);
            List children = pop.getChildren();
            if (children != null) {
                S.addAll(children);
            }
            IDVTElementWrapper popR = (IDVTElementWrapper)R.remove(R.size() - 1);
            popR.fElement = pop.fElement;
            if (children == null) continue;
            for (IDVTElementWrapper child : children) {
                popR.addChild(child.create());
            }
            R.addAll(popR.getChildren());
        }
        return (T)root;
    }

    public static List<IDVTElementWrapper> duplicateTreeKeepReferences(IDVTElementWrapper t, List<IDVTElementWrapper> nodes) {
        IDVTElementWrapper root = t.create();
        ArrayList<IDVTElementWrapper> rootAndNodes = new ArrayList<IDVTElementWrapper>();
        ArrayList<IDVTElementWrapper> S = new ArrayList<IDVTElementWrapper>();
        ArrayList<IDVTElementWrapper> R = new ArrayList<IDVTElementWrapper>();
        S.add(t);
        R.add(root);
        rootAndNodes.add(root);
        block0: while (!S.isEmpty()) {
            IDVTElementWrapper popS = (IDVTElementWrapper)S.remove(S.size() - 1);
            List childrenS = popS.getChildren();
            if (childrenS != null) {
                S.addAll(childrenS);
            }
            IDVTElementWrapper popR = (IDVTElementWrapper)R.remove(R.size() - 1);
            popR.fElement = popS.fElement;
            if (childrenS != null) {
                for (IDVTElementWrapper child : childrenS) {
                    popR.addChild(child.create());
                }
                List childrenR = popR.getChildren();
                if (childrenR != null) {
                    R.addAll(childrenR);
                }
            }
            for (IDVTElementWrapper node : nodes) {
                if (node != popS) continue;
                rootAndNodes.add(popR);
                continue block0;
            }
        }
        return rootAndNodes;
    }

    public static void trimTreeFromLeafs(List<IDVTElementWrapper> leafs) {
    }

    public static boolean containsEqualsEquals(List<IDVTElementWrapper> nodes, IDVTElementWrapper n) {
        for (IDVTElementWrapper node : nodes) {
            if (node != n) continue;
            return true;
        }
        return false;
    }

    public static List<IDVTElementWrapper> parents(List<IDVTElementWrapper> nodes) {
        ArrayList<IDVTElementWrapper> parents = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper node : nodes) {
            IDVTElementWrapper parent = node.getParent();
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    public static List<IDVTElementWrapper> ancestors(List<IDVTElementWrapper> nodes) {
        ArrayList<IDVTElementWrapper> ancestors = new ArrayList<IDVTElementWrapper>();
        List<IDVTElementWrapper> parents = nodes;
        do {
            for (IDVTElementWrapper parent : parents) {
                if (AbstractWrapperHelper.containsEqualsEquals(ancestors, parent)) continue;
                ancestors.add(parent);
            }
        } while (!(parents = AbstractWrapperHelper.parents(parents)).isEmpty());
        return ancestors;
    }

    public static void filterUnimportantDFS(IDVTElementWrapper t, List<IDVTElementWrapper> important) {
        List<IDVTElementWrapper> ancestors = AbstractWrapperHelper.ancestors(important);
        ArrayList<IDVTElementWrapper> S = new ArrayList<IDVTElementWrapper>();
        S.add(t);
        while (!S.isEmpty()) {
            IDVTElementWrapper pop = (IDVTElementWrapper)S.remove(S.size() - 1);
            if (AbstractWrapperHelper.containsEqualsEquals(ancestors, pop)) {
                List children = pop.getChildren();
                if (children == null) continue;
                S.addAll(children);
                continue;
            }
            if (pop.getParent() == null) continue;
            pop.getParent().getChildren().remove(pop);
        }
    }

    public static void main(String[] args) {
        BasicElementWrapper AA = new BasicElementWrapper(9);
        BasicElementWrapper A = new BasicElementWrapper(10);
        BasicElementWrapper B = new BasicElementWrapper(11);
        BasicElementWrapper C = new BasicElementWrapper(12);
        BasicElementWrapper D = new BasicElementWrapper(13);
        BasicElementWrapper E = new BasicElementWrapper(14);
        BasicElementWrapper F = new BasicElementWrapper(15);
        BasicElementWrapper G = new BasicElementWrapper(16);
        BasicElementWrapper H = new BasicElementWrapper(17);
        BasicElementWrapper A2 = new BasicElementWrapper(10);
        BasicElementWrapper C2 = new BasicElementWrapper(12);
        BasicElementWrapper F2 = new BasicElementWrapper(15);
        BasicElementWrapper G2 = new BasicElementWrapper(16);
        BasicElementWrapper H2 = new BasicElementWrapper(17);
        AA.addChild(A);
        A.addChild(B);
        A.addChild(C);
        A.addChild(D);
        C.addChild(E);
        C.addChild(F);
        C.addChild(G);
        G.addChild(H);
        A2.addChild(C2);
        C2.addChild(F2);
        C2.addChild(G2);
        G2.addChild(H2);
        boolean r = AbstractWrapperHelper.equalTreesOrdered1(A, A2);
        r = AbstractWrapperHelper.equalTreesUnordered(A, A2);
        r = AbstractWrapperHelper.containsTreeOrderedAnywhere(AA, A2);
        TestHelper.out.println(r);
    }
}

