/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCDvtInit;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.LanguageElementFileInstance;
import ro.amiq.dvt.model.reflection.views.BCTreeElementWrapper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;

public class BCLabelProvider
extends DVTBaseLabelProvider {
    @Override
    public Image getImage(Object object) {
        if (!(object instanceof BCTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object rfElement = ((BCTreeElementWrapper)object).getRfElement();
        Image result = null;
        if (rfElement instanceof BCFileInstance) {
            BCFileInstance instance = (BCFileInstance)rfElement;
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(((IDVTElementWrapper)object).getProject(), instance.getFilePath());
            result = file != null ? DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE) : DVTImages.imageCache.getImage(DVTImages.NONE);
            if (result == null) {
                return DVTImages.imageCache.getImage(DVTImages.NONE);
            }
        }
        if (rfElement instanceof LanguageElementFileInstance) {
            LanguageElementFileInstance langaguElementFileInstance = (LanguageElementFileInstance)rfElement;
            if (LanguageKind.VLOG == langaguElementFileInstance.getLanguageKind()) {
                result = DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
            } else if (LanguageKind.SLN == langaguElementFileInstance.getLanguageKind()) {
                result = DVTImages.imageCache.getImage(DVTImages.SLN_LANGUAGE);
            } else if (LanguageKind.E == langaguElementFileInstance.getLanguageKind()) {
                result = DVTImages.imageCache.getImage(DVTImages.E_LANGUAGE);
            } else if (LanguageKind.VHDL == langaguElementFileInstance.getLanguageKind()) {
                result = DVTImages.imageCache.getImage(DVTImages.VHDL_LANGUAGE);
            } else if (LanguageKind.PSS == langaguElementFileInstance.getLanguageKind()) {
                result = DVTImages.imageCache.getImage(DVTImages.PSS_LANGUAGE);
            } else if (LanguageKind.MSDL == langaguElementFileInstance.getLanguageKind()) {
                result = DVTImages.imageCache.getImage(DVTImages.SDL_LANGUAGE);
            }
            if (result == null) {
                return DVTImages.imageCache.getImage(DVTImages.NONE);
            }
        } else if (rfElement instanceof BCDvtInit) {
            result = DVTImages.imageCache.getImage(DVTImages.BC_INVOCATION);
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, object);
        }
        return result;
    }

    @Override
    public String getText(Object object) {
        return this.internalGetText(object);
    }

    private String internalGetText(Object object) {
        if (!(object instanceof BCTreeElementWrapper)) {
            return "";
        }
        BCTreeElementWrapper treeElementWrapper = (BCTreeElementWrapper)object;
        Object element = treeElementWrapper.getRfElement();
        if (!(element instanceof BCFileInstance || element instanceof LanguageElementFileInstance || element instanceof BCDvtInit)) {
            return "";
        }
        if (element instanceof BCFileInstance) {
            BCFileInstance instance = (BCFileInstance)element;
            String name = instance.getShortFileName();
            if (name == null) {
                return "";
            }
            int index = instance.getIndex();
            if (index <= 0) {
                return name;
            }
            if (instance.getInvocationString() != null) {
                String invocationString = instance.getInvocationString();
                if (invocationString == null) {
                    return null;
                }
                String[] arr = invocationString.split(" ");
                if (arr == null || arr.length < 2) {
                    return name;
                }
                return Path.fromOSString((String)arr[arr.length - 1]).lastSegment();
            }
            return name;
        }
        if (element instanceof LanguageElementFileInstance) {
            LanguageElementFileInstance instance = (LanguageElementFileInstance)element;
            LanguageKind languageKind = instance.getLanguageKind();
            if (languageKind == null) {
                return "";
            }
            int startIndex = instance.getStartIndex();
            if (startIndex <= 0) {
                return "";
            }
            int endIndex = instance.getEndIndex();
            if (endIndex <= 0) {
                return "";
            }
            if (startIndex > endIndex) {
                return "";
            }
            return String.valueOf(languageKind.getViewName()) + " [" + startIndex + " - " + endIndex + "]";
        }
        if (element instanceof BCDvtInit) {
            BCDvtInit instance = (BCDvtInit)element;
            int invocationNumber = instance.getInvocNumber();
            List<Invocation> invocations = BuildConfigManager.getInvocations(instance.getProject());
            if (invocations == null || invocationNumber < 0 || invocationNumber >= invocations.size()) {
                return "";
            }
            Invocation invocation = invocations.get(invocationNumber);
            if (invocation == null) {
                return "";
            }
            BuildConfigParser.InvocationState state = invocation.getState();
            if (state == null) {
                return "";
            }
            String invocationString = state.invocationString;
            if (invocationString == null || "".equals(invocationString)) {
                invocationString = "+dvt_init+dvt [implicit]";
            }
            if (state.fPrecompiledState == BuildConfigParser.InvocationPrecompiledState.AUTO_LOAD) {
                invocationString = "[Auto-P] " + invocationString;
            }
            if (state.fKind == BuildConfigParser.InvocationKind.REUSE_CONFIG) {
                invocationString = "+" + IBuildConfigParserConstants.Directive.INCLUDE_CONFIG;
            }
            return String.valueOf(invocationString) + " [" + Integer.toString(invocationNumber) + "]";
        }
        return null;
    }

    public Object[] getChildren(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && ((IDVTElementWrapper)wrapper).getChildren() != null) {
            return ((IDVTElementWrapper)wrapper).getChildren().toArray();
        }
        return null;
    }
}

