/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.DVTInfoPopup;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;

public enum BCXmlTopSaver {
    INSTANCE;


    public void writeTopToBCXML(final HistoryItem historyItem, BCXmlTopSaverViewType viewType) {
        if (historyItem == null || historyItem.getProject() == null) {
            return;
        }
        boolean isWriteFailed = false;
        String topTitle = "";
        switch (viewType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                isWriteFailed = !BuildConfigManager.setDesignHierarchyTop(historyItem.getProject(), historyItem.toString(), true, historyItem.getLanguage());
                topTitle = "Cannot Save Design Hierarchy Top";
                break;
            }
        }
        if (!isWriteFailed) {
            return;
        }
        DVTInfoPopup popup = new DVTInfoPopup(topTitle, "<a>.dvt/build_config.xml</a> is not writable", null);
        popup.open();
        popup.addLinkListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPropertyDialogOn((Shell)Display.getCurrent().getActiveShell(), (IAdaptable)historyItem.getProject().getFile(".dvt/build.config.xml"), (String)"org.eclipse.ui.propertypages.info.file", null, null).open();
            }
        });
    }

    public HistoryItem getHistoryItemFromBCXml(String bcXMLString, IProject project, HistoryItemType historyItemType) {
        return RfMixedLangManager.getInstance().getHistoryItemFromBCXmlString(bcXMLString, project, historyItemType);
    }

    public HistoryItem createHistoryItem(DVTXmlSaveConfig config, IProject project, HistoryItemType historyItemType) {
        return RfMixedLangManager.getInstance().createHistoryItem(config, project, historyItemType);
    }

    public NamedElementAndConfigInfo getNamedElementAndConfigFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        return RfMixedLangManager.getInstance().getNamedElementAndConfigFromHistoryItem(historyItem, project, viewType);
    }

    public HistoryItemType getHistoryItemTypeFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        return RfMixedLangManager.getInstance().getHistoryItemTypeFromHistoryItem(historyItem, project, viewType);
    }
}

