/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IDVTXModelManager;
import ro.amiq.dvt.interpreter.XUpdateEvent;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;

public class BuildEventManager {
    private static BuildEventManager fInstance;
    private static final Object fSyncInstance;
    private final Set<IBuildEventManagerListener> fListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildEventManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new BuildEventManager();
            }
        }
        return fInstance;
    }

    public void registerListener(IBuildEventManagerListener listener) {
        this.fListeners.add(listener);
    }

    public void unregisterListener(IBuildEventManagerListener listener) {
        this.fListeners.remove(listener);
    }

    public void notifyFullBuild(IProject project) {
        for (IBuildEventManagerListener listener : this.fListeners) {
            listener.notifyFullBuild(project);
        }
    }

    public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        for (IBuildEventManagerListener listener : this.fListeners) {
            listener.notifyIncrementalBuild(project, changedFiles, updateViewIds);
        }
    }

    public void notifyCleanBuild(IProject project) {
        for (IBuildEventManagerListener listener : this.fListeners) {
            listener.notifyCleanBuild(project);
        }
    }

    public void notifyXModelListenerResourceChanges(IProject project, XUpdateEvent updateEvent) {
        for (IBuildEventManagerListener listener : this.fListeners) {
            if (!(listener instanceof IDVTXModelManager)) continue;
            ((IDVTXModelManager)listener).notifyXModelListenerResourceChanges(project, updateEvent);
        }
    }
}

