/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.math.BigInteger;
import ro.amiq.dvt.test.TestHelper;

public class CombGen {
    private int[] a;
    private int n;
    private int r;
    private BigInteger numLeft;
    private BigInteger total;

    public CombGen(int n, int r) {
        if (r > n) {
            throw new IllegalArgumentException();
        }
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.r = r;
        this.a = new int[r];
        BigInteger nFact = CombGen.getFactorial(n);
        BigInteger rFact = CombGen.getFactorial(r);
        BigInteger nminusrFact = CombGen.getFactorial(n - r);
        this.total = nFact.divide(rFact.multiply(nminusrFact));
        this.reset();
    }

    public void reset() {
        int i = 0;
        while (i < this.a.length) {
            this.a[i] = i;
            ++i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) > 0;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        int i = n;
        while (i > 1) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
            --i;
        }
        return fact;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int i = this.r - 1;
        while (this.a[i] == this.n - this.r + i) {
            --i;
        }
        this.a[i] = this.a[i] + 1;
        int j = i + 1;
        while (j < this.r) {
            this.a[j] = this.a[i] + j - i;
            ++j;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }

    public static void main(String[] args) {
        String[] elements = new String[]{"a", "b", "c", "d"};
        CombGen x = new CombGen(elements.length, 3);
        while (x.hasMore()) {
            StringBuilder combination = new StringBuilder();
            int[] indices = x.getNext();
            int i = 0;
            while (i < indices.length) {
                combination.append(elements[indices[i]]);
                ++i;
            }
            TestHelper.out.println(combination.toString());
        }
    }
}

