/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.ui.views.DVTBaseLabelProviderCommon;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class DVTBaseLabelProvider
extends DVTBaseLabelProviderCommon
implements IColorProvider,
ITableFontProvider {
    private StringMatcher fBoldMatcher;

    protected ILabelDecorator getDefaultLabelDecorator() {
        return DVTPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public DVTBaseLabelProvider() {
        this.fDecorator = this.getDefaultLabelDecorator();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        if (this.fDecorator != null) {
            this.fDecorator.addListener(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        if (this.fDecorator != null) {
            this.fDecorator.removeListener(listener);
        }
    }

    public ILabelDecorator getDecorator() {
        return this.fDecorator;
    }

    @Override
    protected void setBoldFont(IDVTElementWrapper w) {
        if (w == null) {
            return;
        }
        if (!(w.getItem() instanceof TreeItem)) {
            return;
        }
        TreeItem i = (TreeItem)w.getItem();
        if (i.isDisposed()) {
            return;
        }
        Display d = i.getDisplay();
        Font f2 = i.getFont();
        if (d == null || f2 == null) {
            return;
        }
        FontData[] fd = f2.getFontData();
        if (fd == null || fd.length == 0) {
            return;
        }
        i.setFont(FontFactory.getInstance().getSWTFont(new FontData(fd[0].getName(), fd[0].getHeight(), 1)));
    }

    protected void setBoldFont(IDVTElementWrapper w, int color) {
        if (w == null) {
            return;
        }
        if (!(w.getItem() instanceof TreeItem)) {
            return;
        }
        TreeItem i = (TreeItem)w.getItem();
        if (i.isDisposed()) {
            return;
        }
        Display d = i.getDisplay();
        Font f2 = i.getFont();
        if (d == null || f2 == null) {
            return;
        }
        FontData[] fd = f2.getFontData();
        if (fd == null || fd.length == 0) {
            return;
        }
        i.setFont(FontFactory.getInstance().getSWTFont(new FontData(fd[0].getName(), fd[0].getHeight(), 1)));
        i.setForeground(d.getSystemColor(color));
    }

    @Override
    public Font getFont(Object element, int columnIndex) {
        if (this.fBoldMatcher == null || !ViewsUtils.matchCamelCaseOrRegex(this.fBoldMatcher, this.getText(element))) {
            return null;
        }
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        Display current = Display.getCurrent();
        if (fontRegistry != null && current != null) {
            return fontRegistry.getBold(current.getSystemFont().getFontData()[0].getName());
        }
        return null;
    }

    @Override
    public void setBoldMatcher(StringMatcher portToPromote) {
        this.fBoldMatcher = portToPromote;
    }
}

